/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.result;

import com.alibaba.graphscope.common.ir.type.ArbitraryMapType;
import com.alibaba.graphscope.common.ir.type.GraphLabelType;
import com.alibaba.graphscope.common.ir.type.GraphPathType;
import com.alibaba.graphscope.common.ir.type.GraphSchemaType;
import com.alibaba.graphscope.gaia.proto.Common;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String getLabelName(Common.NameOrId nameOrId, @Nullable GraphLabelType labelTypes) {
        switch (nameOrId.getItemCase()) {
            case NAME: {
                return nameOrId.getName();
            }
        }
        ArrayList<Integer> labelIds = new ArrayList<Integer>();
        if (labelTypes != null) {
            for (GraphLabelType.Entry labelType : labelTypes.getLabelsEntry()) {
                if (labelType.getLabelId().intValue() == nameOrId.getId()) {
                    return labelType.getLabel();
                }
                labelIds.add(labelType.getLabelId());
            }
        }
        logger.warn("label id={} not found, expected ids are {}", (Object)nameOrId.getId(), labelIds);
        return String.valueOf(nameOrId.getId());
    }

    public static String getSrcLabelName(Common.NameOrId nameOrId, @Nullable GraphLabelType labelTypes) {
        switch (nameOrId.getItemCase()) {
            case NAME: {
                return nameOrId.getName();
            }
        }
        ArrayList labelIds = new ArrayList();
        if (labelTypes != null) {
            for (GraphLabelType.Entry labelType : labelTypes.getLabelsEntry()) {
                if (labelType.getSrcLabelId().intValue() != nameOrId.getId()) continue;
                return labelType.getSrcLabel();
            }
        }
        logger.warn("src label id={} not found, expected ids are {}", (Object)nameOrId.getId(), labelIds);
        return String.valueOf(nameOrId.getId());
    }

    public static String getDstLabelName(Common.NameOrId nameOrId, @Nullable GraphLabelType labelTypes) {
        switch (nameOrId.getItemCase()) {
            case NAME: {
                return nameOrId.getName();
            }
        }
        ArrayList labelIds = new ArrayList();
        if (labelTypes != null) {
            for (GraphLabelType.Entry labelType : labelTypes.getLabelsEntry()) {
                if (labelType.getDstLabelId().intValue() != nameOrId.getId()) continue;
                return labelType.getDstLabel();
            }
        }
        logger.warn("dst label id={} not found, expected ids are {}", (Object)nameOrId.getId(), labelIds);
        return String.valueOf(nameOrId.getId());
    }

    public static @Nullable GraphLabelType getLabelTypes(RelDataType dataType) {
        if (dataType instanceof GraphSchemaType) {
            return ((GraphSchemaType)dataType).getLabelType();
        }
        return null;
    }

    public static RelDataType getVertexType(RelDataType graphPathType) {
        return graphPathType instanceof GraphPathType ? ((GraphPathType)graphPathType).getComponentType().getGetVType() : graphPathType;
    }

    public static RelDataType getEdgeType(RelDataType graphPathType) {
        if (graphPathType instanceof GraphPathType) {
            return Objects.requireNonNull(((GraphPathType)graphPathType).getComponentType().getExpandType(), "cannot get expand type from graph path " + graphPathType);
        }
        return graphPathType;
    }

    public static String parseLabelValue(Common.Value value, GraphLabelType type) {
        switch (value.getItemCase()) {
            case STR: {
                return value.getStr();
            }
            case I32: {
                return Utils.parseLabelValue(value.getI32(), type);
            }
            case I64: {
                return Utils.parseLabelValue(value.getI64(), type);
            }
        }
        throw new IllegalArgumentException("cannot parse label value with type=" + value.getItemCase().name());
    }

    public static String parseLabelValue(long labelId, GraphLabelType type) {
        ArrayList expectedLabelIds = Lists.newArrayList();
        for (GraphLabelType.Entry entry : type.getLabelsEntry()) {
            if ((long)entry.getLabelId().intValue() == labelId) {
                return entry.getLabel();
            }
            expectedLabelIds.add(entry.getLabelId());
        }
        throw new IllegalArgumentException("cannot parse label value=" + labelId + " from expected type=" + type + ", expected ids are " + expectedLabelIds);
    }

    public static RelDataTypeField findFieldByPredicate(Predicate<RelDataTypeField> p, List<RelDataTypeField> typeFields) {
        return typeFields.stream().filter(k -> p.test(k)).findFirst().orElse(null);
    }

    public static ArbitraryMapType.KeyValueType getKeyValueType(Common.Value target, Map<RexNode, ArbitraryMapType.KeyValueType> keyValueTypeMap) {
        Map<Common.Value, ArbitraryMapType.KeyValueType> conversionType = keyValueTypeMap.entrySet().stream().collect(Collectors.toMap(entry -> com.alibaba.graphscope.common.ir.runtime.proto.Utils.protoValue((RexLiteral)entry.getKey()), Map.Entry::getValue));
        return conversionType.get(target);
    }
}

