/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.cypher.antlr4.visitor;

import com.alibaba.graphscope.common.antlr4.ExprUniqueAliasInfer;
import com.alibaba.graphscope.common.antlr4.ExprVisitorResult;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.ir.meta.function.GraphFunctions;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphAggCall;
import com.alibaba.graphscope.common.ir.rex.RexGraphDynamicParam;
import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.alibaba.graphscope.common.ir.rex.RexTmpVariable;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.GraphRexBuilder;
import com.alibaba.graphscope.common.ir.tools.GraphStdOperatorTable;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.type.GraphSchemaType;
import com.alibaba.graphscope.cypher.antlr4.visitor.GraphBuilderVisitor;
import com.alibaba.graphscope.cypher.antlr4.visitor.LiteralVisitor;
import com.alibaba.graphscope.cypher.antlr4.visitor.Utils;
import com.alibaba.graphscope.grammar.CypherGSBaseVisitor;
import com.alibaba.graphscope.grammar.CypherGSParser;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.NlsString;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExpressionVisitor
extends CypherGSBaseVisitor<ExprVisitorResult> {
    private final GraphBuilderVisitor parent;
    private final ExprUniqueAliasInfer aliasInfer;
    private final GraphBuilder builder;
    private final ParamManager paramManager;

    public ExpressionVisitor(GraphBuilderVisitor parent) {
        this.parent = Objects.requireNonNull(parent);
        this.aliasInfer = Objects.requireNonNull(parent.getAliasInfer());
        this.builder = parent.getGraphBuilder();
        this.paramManager = new ParamManager();
    }

    @Override
    public ExprVisitorResult visitOC_OrExpression(CypherGSParser.OC_OrExpressionContext ctx) {
        if (ObjectUtils.isEmpty(ctx.oC_AndExpression())) {
            throw new IllegalArgumentException("and expression should not be empty");
        }
        return Utils.binaryCall((SqlOperator)GraphStdOperatorTable.OR, ctx.oC_AndExpression().stream().map(k -> this.visitOC_AndExpression((CypherGSParser.OC_AndExpressionContext)((Object)k))).collect(Collectors.toList()), this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_AndExpression(CypherGSParser.OC_AndExpressionContext ctx) {
        if (ObjectUtils.isEmpty(ctx.oC_NotExpression())) {
            throw new IllegalArgumentException("operands should not be empty in 'AND' operator");
        }
        return Utils.binaryCall((SqlOperator)GraphStdOperatorTable.AND, ctx.oC_NotExpression().stream().map(k -> this.visitOC_NotExpression((CypherGSParser.OC_NotExpressionContext)((Object)k))).collect(Collectors.toList()), this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_NotExpression(CypherGSParser.OC_NotExpressionContext ctx) {
        ExprVisitorResult operand = this.visitOC_NullPredicateExpression(ctx.oC_NullPredicateExpression());
        List<TerminalNode> notNodes = ctx.NOT();
        return Utils.unaryCall((List<SqlOperator>)(ObjectUtils.isNotEmpty(notNodes) && (notNodes.size() & 1) != 0 ? ImmutableList.of((Object)GraphStdOperatorTable.NOT) : ImmutableList.of()), operand, this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_ComparisonExpression(CypherGSParser.OC_ComparisonExpressionContext ctx) {
        ArrayList<SqlOperator> operators = new ArrayList<SqlOperator>();
        ArrayList<ExprVisitorResult> operands = new ArrayList<ExprVisitorResult>();
        operands.add(this.visitOC_StringOrListPredicateExpression(ctx.oC_StringOrListPredicateExpression()));
        for (CypherGSParser.OC_PartialComparisonExpressionContext partialCtx : ctx.oC_PartialComparisonExpression()) {
            operands.add(this.visitOC_StringOrListPredicateExpression(partialCtx.oC_StringOrListPredicateExpression()));
            operators.addAll(Utils.getOperators(partialCtx.children, (List<String>)ImmutableList.of((Object)"=", (Object)"<>", (Object)"<", (Object)">", (Object)"<=", (Object)">="), false));
        }
        return Utils.binaryCall(operators, operands, this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_StringOrListPredicateExpression(CypherGSParser.OC_StringOrListPredicateExpressionContext ctx) {
        ArrayList operands = Lists.newArrayList((Object[])new ExprVisitorResult[]{this.visitOC_AddOrSubtractOrBitManipulationExpression(ctx.oC_AddOrSubtractOrBitManipulationExpression(0))});
        ArrayList operators = Lists.newArrayList();
        if (ctx.STARTS() != null && ctx.WITH() != null || ctx.ENDS() != null && ctx.WITH() != null || ctx.CONTAINS() != null) {
            RexNode rightExpr = this.visitOC_AddOrSubtractOrBitManipulationExpression(ctx.oC_AddOrSubtractOrBitManipulationExpression(1)).getExpr();
            Preconditions.checkArgument((rightExpr.getKind() == SqlKind.LITERAL && rightExpr.getType().getFamily() == SqlTypeFamily.CHARACTER ? 1 : 0) != 0, (Object)"the right operand of string predicate expression should be a string literal");
            String value = ((NlsString)((RexLiteral)rightExpr).getValueAs(NlsString.class)).getValue();
            StringBuilder regexPattern = new StringBuilder();
            if (ctx.STARTS() != null && ctx.WITH() != null) {
                regexPattern.append("^");
                regexPattern.append(value);
                regexPattern.append(".*");
            } else if (ctx.ENDS() != null && ctx.WITH() != null) {
                regexPattern.append(".*");
                regexPattern.append(value);
                regexPattern.append("$");
            } else {
                regexPattern.append(".*");
                regexPattern.append(value);
                regexPattern.append(".*");
            }
            operands.add(new ExprVisitorResult((RexNode)this.builder.literal(regexPattern.toString())));
            operators.add(GraphStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE);
        } else if (ctx.IN() != null) {
            operands.add(this.visitOC_AddOrSubtractOrBitManipulationExpression(ctx.oC_AddOrSubtractOrBitManipulationExpression(1)));
            operators.add(GraphStdOperatorTable.IN);
        }
        return Utils.binaryCall(operators, (List<ExprVisitorResult>)operands, this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_NullPredicateExpression(CypherGSParser.OC_NullPredicateExpressionContext ctx) {
        ExprVisitorResult operand = this.visitOC_ComparisonExpression(ctx.oC_ComparisonExpression());
        ArrayList operators = Lists.newArrayList();
        if (ctx.IS() != null && ctx.NOT() != null && ctx.NULL() != null) {
            operators.add(GraphStdOperatorTable.IS_NOT_NULL);
        } else if (ctx.IS() != null && ctx.NULL() != null) {
            operators.add(GraphStdOperatorTable.IS_NULL);
        }
        return Utils.unaryCall(operators, operand, this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_AddOrSubtractOrBitManipulationExpression(CypherGSParser.OC_AddOrSubtractOrBitManipulationExpressionContext ctx) {
        if (ObjectUtils.isEmpty(ctx.oC_MultiplyDivideModuloExpression())) {
            throw new IllegalArgumentException("multiply or divide expression should not be empty");
        }
        List<SqlOperator> operators = com.alibaba.graphscope.common.antlr4.Utils.getOperators(ctx.children, (List<String>)ImmutableList.of((Object)"+", (Object)"-", (Object)"&", (Object)"|", (Object)"^", (Object)"<<", (Object)">>"), false);
        return Utils.binaryCall(operators, ctx.oC_MultiplyDivideModuloExpression().stream().map(k -> this.visitOC_MultiplyDivideModuloExpression((CypherGSParser.OC_MultiplyDivideModuloExpressionContext)((Object)k))).collect(Collectors.toList()), this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_MultiplyDivideModuloExpression(CypherGSParser.OC_MultiplyDivideModuloExpressionContext ctx) {
        if (ObjectUtils.isEmpty(ctx.oC_UnaryAddOrSubtractExpression())) {
            throw new IllegalArgumentException("power expression should not be empty");
        }
        List<SqlOperator> operators = Utils.getOperators(ctx.children, (List<String>)ImmutableList.of((Object)"*", (Object)"/", (Object)"%"), false);
        return Utils.binaryCall(operators, ctx.oC_UnaryAddOrSubtractExpression().stream().map(k -> this.visitOC_UnaryAddOrSubtractExpression((CypherGSParser.OC_UnaryAddOrSubtractExpressionContext)((Object)k))).collect(Collectors.toList()), this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_UnaryAddOrSubtractExpression(CypherGSParser.OC_UnaryAddOrSubtractExpressionContext ctx) {
        ExprVisitorResult operand = (ExprVisitorResult)this.visitOC_ListOperatorExpression(ctx.oC_ListOperatorExpression());
        List<SqlOperator> operators = Utils.getOperators(ctx.children, (List<String>)ImmutableList.of((Object)"-", (Object)"+"), true);
        return Utils.unaryCall(operators, operand, this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_PropertyOrLabelsExpression(CypherGSParser.OC_PropertyOrLabelsExpressionContext ctx) {
        if (ctx.oC_PropertyLookup() == null) {
            return (ExprVisitorResult)this.visitOC_Atom(ctx.oC_Atom());
        }
        if (ctx.oC_Atom().oC_Literal() != null) {
            throw new IllegalArgumentException("cannot get property from an literal");
        }
        String propertyName = ctx.oC_PropertyLookup().oC_PropertyKeyName().getText();
        ExprVisitorResult exprRes = (ExprVisitorResult)this.visitOC_Atom(ctx.oC_Atom());
        RexNode expr = exprRes.getExpr();
        if (expr.getType() instanceof GraphSchemaType) {
            Preconditions.checkArgument((boolean)(expr instanceof RexGraphVariable), (String)"can not get property from the rex=", (Object)expr);
            String aliasName = ((RexGraphVariable)expr).getName().split("\\.")[0];
            return new ExprVisitorResult(exprRes.getAggCalls(), (RexNode)this.builder.variable(aliasName, propertyName));
        }
        if (SqlTypeFamily.DATETIME.getTypeNames().contains(expr.getType().getSqlTypeName())) {
            return new ExprVisitorResult(exprRes.getAggCalls(), this.builder.call((SqlOperator)GraphStdOperatorTable.EXTRACT, Utils.createIntervalExpr(null, Utils.createExtractUnit(propertyName), this.builder), expr));
        }
        throw new IllegalArgumentException("invalid property lookup operation, cannot get property or extract interval from expr=[" + expr + ", type=" + expr.getType() + "]");
    }

    @Override
    public ExprVisitorResult visitOC_ParenthesizedExpression(CypherGSParser.OC_ParenthesizedExpressionContext ctx) {
        return (ExprVisitorResult)this.visitOC_Expression(ctx.oC_Expression());
    }

    @Override
    public ExprVisitorResult visitOC_Variable(CypherGSParser.OC_VariableContext ctx) {
        String aliasName = ctx.getText();
        return new ExprVisitorResult((RexNode)this.builder.variable(aliasName));
    }

    @Override
    public ExprVisitorResult visitOC_PatternPredicate(CypherGSParser.OC_PatternPredicateContext ctx) {
        RelNode subQuery = ((GraphBuilder)((Object)this.parent.visitOC_RelationshipsPattern(ctx.oC_RelationshipsPattern()))).build();
        return new ExprVisitorResult((RexNode)RexSubQuery.exists((RelNode)subQuery));
    }

    @Override
    public ExprVisitorResult visitOC_Literal(CypherGSParser.OC_LiteralContext ctx) {
        if (ctx.StringLiteral() != null) {
            return new ExprVisitorResult((RexNode)this.builder.literal(LiteralVisitor.INSTANCE.visitTerminal(ctx.StringLiteral())));
        }
        if (ctx.NULL() != null) {
            return new ExprVisitorResult((RexNode)this.builder.literal(LiteralVisitor.INSTANCE.visitTerminal(ctx.NULL())));
        }
        return (ExprVisitorResult)super.visitOC_Literal(ctx);
    }

    @Override
    public ExprVisitorResult visitOC_ListLiteral(CypherGSParser.OC_ListLiteralContext ctx) {
        List<ExprVisitorResult> operands = ctx.oC_Expression().stream().map(k -> (ExprVisitorResult)this.visitOC_Expression((CypherGSParser.OC_ExpressionContext)((Object)k))).collect(Collectors.toList());
        ArrayList aggCallList = Lists.newArrayList();
        ArrayList expressions = Lists.newArrayList();
        operands.forEach(k -> {
            if (!k.getAggCalls().isEmpty()) {
                aggCallList.addAll(k.getAggCalls());
            }
            expressions.add(k.getExpr());
        });
        return new ExprVisitorResult(aggCallList, this.builder.call(GraphStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, expressions));
    }

    @Override
    public ExprVisitorResult visitOC_MapLiteral(CypherGSParser.OC_MapLiteralContext ctx) {
        List keys = ctx.oC_PropertyKeyName().stream().map(k -> k.getText()).collect(Collectors.toList());
        List values = ctx.oC_Expression().stream().map(k -> (ExprVisitorResult)this.visitOC_Expression((CypherGSParser.OC_ExpressionContext)((Object)k))).collect(Collectors.toList());
        Preconditions.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (Object)("keys size=" + keys.size() + " is not consistent with values size=" + values.size() + " in MapLiteral"));
        ArrayList aggCallList = Lists.newArrayList();
        ArrayList expressions = Lists.newArrayList();
        for (int i = 0; i < keys.size(); ++i) {
            ExprVisitorResult valueExpr = (ExprVisitorResult)values.get(i);
            if (!valueExpr.getAggCalls().isEmpty()) {
                aggCallList.addAll(valueExpr.getAggCalls());
            }
            expressions.add(this.builder.literal(keys.get(i)));
            expressions.add(valueExpr.getExpr());
        }
        return new ExprVisitorResult(aggCallList, this.builder.call(GraphStdOperatorTable.MAP_VALUE_CONSTRUCTOR, expressions));
    }

    @Override
    public ExprVisitorResult visitOC_Parameter(CypherGSParser.OC_ParameterContext ctx) {
        String paramName = ctx.oC_SymbolicName().getText();
        int paramIndex = this.paramManager.generate(paramName);
        GraphRexBuilder rexBuilder = (GraphRexBuilder)this.builder.getRexBuilder();
        RexGraphDynamicParam dynamicParam = rexBuilder.makeGraphDynamicParam(paramName, paramIndex);
        this.paramManager.addIdToName(dynamicParam.getIndex(), paramName);
        return new ExprVisitorResult((RexNode)dynamicParam);
    }

    @Override
    public ExprVisitorResult visitOC_BooleanLiteral(CypherGSParser.OC_BooleanLiteralContext ctx) {
        return new ExprVisitorResult((RexNode)this.builder.literal(LiteralVisitor.INSTANCE.visitOC_BooleanLiteral(ctx)));
    }

    @Override
    public ExprVisitorResult visitOC_IntegerLiteral(CypherGSParser.OC_IntegerLiteralContext ctx) {
        return new ExprVisitorResult((RexNode)this.builder.literal(LiteralVisitor.INSTANCE.visitOC_IntegerLiteral(ctx)));
    }

    @Override
    public ExprVisitorResult visitOC_DoubleLiteral(CypherGSParser.OC_DoubleLiteralContext ctx) {
        return new ExprVisitorResult((RexNode)this.builder.literal(LiteralVisitor.INSTANCE.visitOC_DoubleLiteral(ctx)));
    }

    @Override
    public ExprVisitorResult visitOC_AggregateFunctionInvocation(CypherGSParser.OC_AggregateFunctionInvocationContext ctx) {
        RelBuilder.AggCall aggCall;
        List variables = ctx.oC_Expression().stream().map(k -> ((ExprVisitorResult)this.visitOC_Expression((CypherGSParser.OC_ExpressionContext)((Object)k))).getExpr()).collect(Collectors.toList());
        String alias = this.aliasInfer.infer();
        String functionName = ctx.getChild(0).getText();
        boolean isDistinct = ctx.DISTINCT() != null;
        switch (functionName.toUpperCase()) {
            case "COUNT": {
                aggCall = this.builder.count(isDistinct, alias, variables);
                break;
            }
            case "SUM": {
                aggCall = this.builder.sum(isDistinct, alias, (RexNode)variables.get(0));
                break;
            }
            case "AVG": {
                aggCall = this.builder.avg(isDistinct, alias, (RexNode)variables.get(0));
                break;
            }
            case "MIN": {
                aggCall = this.builder.min(alias, (RexNode)variables.get(0));
                break;
            }
            case "MAX": {
                aggCall = this.builder.max(alias, (RexNode)variables.get(0));
                break;
            }
            case "COLLECT": {
                aggCall = this.builder.collect(ctx.DISTINCT() != null, alias, variables);
                break;
            }
            default: {
                throw new UnsupportedOperationException("aggregate function " + functionName + " is unsupported yet");
            }
        }
        return new ExprVisitorResult((List<RelBuilder.AggCall>)ImmutableList.of((Object)aggCall), (RexNode)RexTmpVariable.of(alias, ((GraphAggCall)aggCall).getType()));
    }

    @Override
    public ExprVisitorResult visitOC_UserDefinedFunctionInvocation(CypherGSParser.OC_UserDefinedFunctionInvocationContext ctx) {
        String functionName = ctx.oC_UserDefinedFunctionName().getText();
        ArrayList aggCalls = Lists.newArrayList();
        ArrayList parameters = Lists.newArrayList();
        ctx.oC_Expression().forEach(k -> {
            ExprVisitorResult res = (ExprVisitorResult)this.visitOC_Expression((CypherGSParser.OC_ExpressionContext)((Object)k));
            aggCalls.addAll(res.getAggCalls());
            parameters.add(res.getExpr());
        });
        Configs configs = (Configs)this.parent.getGraphBuilder().getContext().unwrapOrThrow(Configs.class);
        GraphFunctions functions = GraphFunctions.instance(configs);
        RexNode udfCall = this.builder.call((SqlOperator)GraphStdOperatorTable.USER_DEFINED_FUNCTION(functions.getFunction(functionName)), parameters);
        return new ExprVisitorResult(aggCalls, udfCall);
    }

    @Override
    public ExprVisitorResult visitOC_ScalarFunctionInvocation(CypherGSParser.OC_ScalarFunctionInvocationContext ctx) {
        List<CypherGSParser.OC_ExpressionContext> exprCtx = ctx.oC_Expression();
        String functionName = ctx.getChild(0).getText();
        switch (functionName.toUpperCase()) {
            case "LABELS": {
                RexGraphVariable labelVar = this.builder.variable(exprCtx.get(0).getText());
                Preconditions.checkArgument((labelVar.getType() instanceof GraphSchemaType && ((GraphSchemaType)labelVar.getType()).getScanOpt() == GraphOpt.Source.VERTEX ? 1 : 0) != 0, (Object)"'labels' can only be applied on vertex type");
                return new ExprVisitorResult((RexNode)this.builder.variable(exprCtx.get(0).getText(), "~label"));
            }
            case "TYPE": {
                RexGraphVariable typeVar = this.builder.variable(exprCtx.get(0).getText());
                Preconditions.checkArgument((typeVar.getType() instanceof GraphSchemaType && ((GraphSchemaType)typeVar.getType()).getScanOpt() == GraphOpt.Source.EDGE ? 1 : 0) != 0, (Object)"'type' can only be applied on edge type");
                return new ExprVisitorResult((RexNode)this.builder.variable(exprCtx.get(0).getText(), "~label"));
            }
            case "ELEMENTID": {
                RexGraphVariable idVar = this.builder.variable(exprCtx.get(0).getText());
                Preconditions.checkArgument((boolean)(idVar.getType() instanceof GraphSchemaType), (Object)"'elementId' can only be applied on vertex or edge type");
                return new ExprVisitorResult((RexNode)this.builder.variable(exprCtx.get(0).getText(), "~id"));
            }
            case "LENGTH": {
                Preconditions.checkArgument((!exprCtx.isEmpty() ? 1 : 0) != 0, (Object)"LENGTH function should have one argument");
                return new ExprVisitorResult((RexNode)this.builder.variable(exprCtx.get(0).getText(), "~len"));
            }
            case "HEAD": {
                Preconditions.checkArgument((!exprCtx.isEmpty() ? 1 : 0) != 0, (Object)"HEAD function should have one argument");
                String errorMessage = "'head(collect(...))' is the only supported usage of HEAD function";
                ExprVisitorResult argResult = (ExprVisitorResult)this.visitOC_Expression(exprCtx.get(0));
                List<RelBuilder.AggCall> aggCalls = argResult.getAggCalls();
                if (aggCalls.size() == 1) {
                    GraphAggCall oldAggCall = (GraphAggCall)aggCalls.get(0);
                    if (oldAggCall.getAggFunction().getKind() == SqlKind.COLLECT) {
                        GraphAggCall newAggCall = new GraphAggCall(oldAggCall.getCluster(), GraphStdOperatorTable.FIRST_VALUE, oldAggCall.getOperands()).as(oldAggCall.getAlias());
                        return new ExprVisitorResult((List<RelBuilder.AggCall>)ImmutableList.of((Object)newAggCall), argResult.getExpr());
                    }
                    throw new UnsupportedOperationException(errorMessage + " , but got " + oldAggCall.getAggFunction().getName());
                }
                throw new UnsupportedOperationException(errorMessage);
            }
            case "POWER": {
                Preconditions.checkArgument((exprCtx.size() == 2 ? 1 : 0) != 0, (Object)"POWER function should have two arguments");
                ExprVisitorResult left = (ExprVisitorResult)this.visitOC_Expression(exprCtx.get(0));
                ExprVisitorResult right = (ExprVisitorResult)this.visitOC_Expression(exprCtx.get(1));
                ArrayList allAggCalls = Lists.newArrayList();
                allAggCalls.addAll(left.getAggCalls());
                allAggCalls.addAll(right.getAggCalls());
                return new ExprVisitorResult(allAggCalls, this.builder.call((SqlOperator)GraphStdOperatorTable.POWER, left.getExpr(), right.getExpr()));
            }
            case "DURATION": {
                ExprVisitorResult operand = (ExprVisitorResult)this.visitOC_Expression(exprCtx.get(0));
                Preconditions.checkArgument((operand.getExpr().getKind() == SqlKind.MAP_VALUE_CONSTRUCTOR ? 1 : 0) != 0, (Object)"parameter of scalar function 'duration' should be a map literal");
                RexCall mapValues = (RexCall)operand.getExpr();
                RexNode intervals = null;
                for (int i = 0; i < mapValues.getOperands().size(); i += 2) {
                    RexNode key = (RexNode)mapValues.getOperands().get(i);
                    RexNode value = (RexNode)mapValues.getOperands().get(i + 1);
                    String timeField = ((NlsString)((RexLiteral)key).getValueAs(NlsString.class)).getValue();
                    RexNode interval = Utils.createIntervalExpr(value, Utils.createDurationUnit(timeField), this.builder);
                    intervals = intervals == null ? interval : this.builder.call((SqlOperator)GraphStdOperatorTable.PLUS, intervals, interval);
                }
                Preconditions.checkArgument((intervals != null ? 1 : 0) != 0, (Object)"parameter of scalar function 'duration' should not be empty");
                return new ExprVisitorResult(operand.getAggCalls(), intervals);
            }
        }
        throw new IllegalArgumentException("scalar function " + functionName + " is unsupported yet");
    }

    @Override
    public ExprVisitorResult visitOC_CountAny(CypherGSParser.OC_CountAnyContext ctx) {
        String alias = this.aliasInfer.infer();
        RelBuilder.AggCall aggCall = this.builder.count(new RexNode[0]);
        return new ExprVisitorResult((List<RelBuilder.AggCall>)ImmutableList.of((Object)aggCall), (RexNode)RexTmpVariable.of(alias, ((GraphAggCall)aggCall).getType()));
    }

    @Override
    public ExprVisitorResult visitOC_CaseExpression(CypherGSParser.OC_CaseExpressionContext ctx) {
        ExprVisitorResult inputExpr = ctx.oC_InputExpression() == null ? null : (ExprVisitorResult)this.visitOC_InputExpression(ctx.oC_InputExpression());
        ArrayList operands = Lists.newArrayList();
        for (CypherGSParser.OC_CaseAlternativeContext whenThen : ctx.oC_CaseAlternative()) {
            Preconditions.checkArgument((whenThen.oC_Expression().size() == 2 ? 1 : 0) != 0, (Object)"whenThen expression should have 2 parts");
            ExprVisitorResult whenExpr = (ExprVisitorResult)this.visitOC_Expression(whenThen.oC_Expression(0));
            if (inputExpr != null) {
                operands.add(this.builder.equals(inputExpr.getExpr(), whenExpr.getExpr()));
            } else {
                operands.add(whenExpr.getExpr());
            }
            ExprVisitorResult thenExpr = (ExprVisitorResult)this.visitOC_Expression(whenThen.oC_Expression(1));
            operands.add(thenExpr.getExpr());
        }
        ExprVisitorResult elseExpr = ctx.oC_ElseExpression() == null ? new ExprVisitorResult((RexNode)this.builder.literal(null)) : (ExprVisitorResult)this.visitOC_ElseExpression(ctx.oC_ElseExpression());
        operands.add(elseExpr.getExpr());
        return new ExprVisitorResult(this.builder.call(GraphStdOperatorTable.CASE, operands));
    }

    public Map<Integer, String> getDynamicParams() {
        return Collections.unmodifiableMap(this.paramManager.paramIdToNameMap);
    }

    private class ParamManager {
        private final AtomicInteger idGenerator = new AtomicInteger();
        private Map<String, Integer> paramNameToIdMap = Maps.newHashMap();
        private Map<Integer, String> paramIdToNameMap = Maps.newHashMap();

        public int generate(@Nullable String paramName) {
            Integer paramId = this.paramNameToIdMap.get(paramName);
            if (paramId == null) {
                paramId = this.idGenerator.getAndIncrement();
                this.paramNameToIdMap.put(paramName, paramId);
            }
            return paramId;
        }

        public void addIdToName(int paramId, String paramName) {
            this.paramIdToNameMap.put(paramId, paramName);
        }
    }
}

