/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.cypher.executor;

import com.alibaba.graphscope.common.client.ExecutionClient;
import com.alibaba.graphscope.common.client.type.ExecutionRequest;
import com.alibaba.graphscope.common.client.type.ExecutionResponseListener;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.QueryTimeoutConfig;
import com.alibaba.graphscope.common.exception.FrontendException;
import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.meta.procedure.StoredProcedureMeta;
import com.alibaba.graphscope.common.ir.rex.RexProcedureCall;
import com.alibaba.graphscope.common.ir.tools.GraphPlanExecutor;
import com.alibaba.graphscope.common.ir.tools.GraphPlanner;
import com.alibaba.graphscope.common.ir.tools.LogicalPlan;
import com.alibaba.graphscope.common.ir.tools.QueryCache;
import com.alibaba.graphscope.common.ir.tools.QueryIdGenerator;
import com.alibaba.graphscope.common.manager.IrMetaQueryCallback;
import com.alibaba.graphscope.common.utils.ClassUtils;
import com.alibaba.graphscope.cypher.executor.CypherPlanExecution;
import com.alibaba.graphscope.gaia.proto.IrResult;
import com.alibaba.graphscope.gremlin.plugin.MetricsCollector;
import com.alibaba.graphscope.gremlin.plugin.QueryStatusCallback;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.Executor;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.eval.CatalogManager;
import org.neo4j.fabric.eval.UseEvaluation;
import org.neo4j.fabric.executor.FabricExecutor;
import org.neo4j.fabric.executor.FabricStatementLifecycles;
import org.neo4j.fabric.planning.FabricPlanner;
import org.neo4j.fabric.stream.QuerySubject;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.StatementResults;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.logging.LogProvider;
import org.neo4j.values.virtual.MapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQueryExecutor
extends FabricExecutor {
    private static final Logger logger = LoggerFactory.getLogger(GraphQueryExecutor.class);
    private static final String GET_ROUTING_TABLE_STATEMENT = "CALL dbms.routing.getRoutingTable($routingContext, $databaseName)";
    private static final String PING_STATEMENT = "CALL db.ping()";
    private final Configs graphConfig;
    private final IrMetaQueryCallback metaQueryCallback;
    private final ExecutionClient client;
    private final QueryIdGenerator idGenerator;
    private final FabricConfig fabricConfig;
    private final QueryCache queryCache;
    private final GraphPlanner graphPlanner;

    public GraphQueryExecutor(FabricConfig config, FabricPlanner planner, UseEvaluation useEvaluation, CatalogManager catalogManager, LogProvider internalLog, FabricStatementLifecycles statementLifecycles, Executor fabricWorkerExecutor, Configs graphConfig, QueryIdGenerator idGenerator, IrMetaQueryCallback metaQueryCallback, ExecutionClient client, QueryCache queryCache, GraphPlanner graphPlanner) {
        super(config, planner, useEvaluation, catalogManager, internalLog, statementLifecycles, fabricWorkerExecutor);
        this.fabricConfig = config;
        this.graphConfig = graphConfig;
        this.idGenerator = idGenerator;
        this.metaQueryCallback = metaQueryCallback;
        this.client = client;
        this.queryCache = queryCache;
        this.graphPlanner = graphPlanner;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StatementResult run(FabricTransaction fabricTransaction, String statement, MapValue parameters) {
        StatementResult statementResult;
        block12: {
            GraphPlanner.Summary planSummary;
            String jobName;
            QueryCache.Value cacheValue;
            QueryStatusCallback statusCallback;
            BigInteger jobId;
            IrMeta irMeta;
            block10: {
                StatementResult statementResult2;
                block11: {
                    block8: {
                        StatementResult statementResult3;
                        block9: {
                            irMeta = null;
                            jobId = this.idGenerator.generateId();
                            statusCallback = ClassUtils.createQueryStatusCallback(jobId, null, statement, new MetricsCollector.Cypher(System.currentTimeMillis()), null, this.graphConfig);
                            if (!statement.equals(GET_ROUTING_TABLE_STATEMENT) && !statement.equals(PING_STATEMENT)) break block8;
                            statementResult3 = super.run(fabricTransaction, statement, parameters);
                            if (irMeta == null) break block9;
                            this.metaQueryCallback.afterExec(irMeta);
                        }
                        return statementResult3;
                    }
                    irMeta = this.metaQueryCallback.beforeExec();
                    QueryCache.Key cacheKey = this.queryCache.createKey(this.graphPlanner.instance(statement, irMeta));
                    cacheValue = this.queryCache.get(cacheKey);
                    Preconditions.checkArgument((cacheValue != null ? 1 : 0) != 0, (Object)"value should have been loaded automatically in query cache");
                    jobName = this.idGenerator.generateName(jobId);
                    planSummary = new GraphPlanner.Summary(cacheValue.summary.getLogicalPlan(), cacheValue.summary.getPhysicalPlan());
                    logger.debug("cypher query \"{}\", job conf name \"{}\", calcite logical plan {}, hash id {}", new Object[]{statement, jobName, planSummary.getLogicalPlan().explain(), cacheKey.hashCode()});
                    if (!planSummary.getLogicalPlan().isReturnEmpty()) break block10;
                    statementResult2 = StatementResults.initial();
                    if (irMeta == null) break block11;
                    this.metaQueryCallback.afterExec(irMeta);
                }
                return statementResult2;
            }
            try {
                logger.info("cypher query \"{}\", job conf name \"{}\", ir core logical plan {}", new Object[]{statement, jobName, planSummary.getPhysicalPlan().explain()});
                final QueryTimeoutConfig timeoutConfig = this.getQueryTimeoutConfig();
                GraphPlanExecutor executor = cacheValue.result != null && cacheValue.result.isCompleted ? new GraphPlanExecutor(){

                    @Override
                    public void execute(GraphPlanner.Summary summary, IrMeta irMeta, ExecutionResponseListener listener) throws Exception {
                        List<IrResult.Results> records = cacheValue.result.records;
                        records.forEach(k -> listener.onNext(k.getRecord()));
                        listener.onCompleted();
                    }
                } : (this.metaProcedureCall(planSummary.getLogicalPlan()) ? StoredProcedureMeta.Mode.SCHEMA : new GraphPlanExecutor(){

                    @Override
                    public void execute(GraphPlanner.Summary summary, IrMeta meta, ExecutionResponseListener listener) throws Exception {
                        ExecutionRequest request = new ExecutionRequest(jobId, jobName, summary.getLogicalPlan(), summary.getPhysicalPlan());
                        GraphQueryExecutor.this.client.submit(request, listener, timeoutConfig);
                    }
                });
                statementResult = StatementResults.connectVia((StatementResults.SubscribableExecution)new CypherPlanExecution(planSummary, timeoutConfig, statusCallback, irMeta, executor), (QuerySubject)new QuerySubject.BasicQuerySubject());
                if (irMeta == null) break block12;
            }
            catch (FrontendException e) {
                try {
                    e.getDetails().put("QueryId", jobId);
                    statusCallback.onErrorEnd(e.getMessage());
                    throw e;
                    catch (Throwable t) {
                        statusCallback.onErrorEnd(t.getMessage());
                        throw new RuntimeException(t);
                    }
                }
                catch (Throwable throwable) {
                    if (irMeta != null) {
                        this.metaQueryCallback.afterExec(irMeta);
                    }
                    throw throwable;
                }
            }
            this.metaQueryCallback.afterExec(irMeta);
        }
        return statementResult;
    }

    private QueryTimeoutConfig getQueryTimeoutConfig() {
        return new QueryTimeoutConfig(this.fabricConfig.getTransactionTimeout().toMillis());
    }

    private boolean metaProcedureCall(LogicalPlan plan) {
        if (!(plan.getProcedureCall() instanceof RexProcedureCall)) {
            return false;
        }
        RexProcedureCall procedureCall = (RexProcedureCall)plan.getProcedureCall();
        return procedureCall.getMode() == StoredProcedureMeta.Mode.SCHEMA;
    }
}

