/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.cypher.result;

import com.alibaba.graphscope.common.ir.type.ArbitraryArrayType;
import com.alibaba.graphscope.common.ir.type.ArbitraryMapType;
import com.alibaba.graphscope.common.ir.type.GraphLabelType;
import com.alibaba.graphscope.common.ir.type.GraphPathType;
import com.alibaba.graphscope.common.result.RecordParser;
import com.alibaba.graphscope.common.result.Utils;
import com.alibaba.graphscope.gaia.proto.Common;
import com.alibaba.graphscope.gaia.proto.IrResult;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CypherRecordParser
implements RecordParser<AnyValue> {
    private static final Logger logger = LoggerFactory.getLogger(CypherRecordParser.class);
    private final RelDataType outputType;

    public CypherRecordParser(RelDataType outputType) {
        this.outputType = outputType;
    }

    @Override
    public List<AnyValue> parseFrom(IrResult.Record record) {
        logger.debug("record {}", (Object)record);
        Preconditions.checkArgument((record.getColumnsCount() == this.outputType.getFieldCount() ? 1 : 0) != 0, (Object)("column size of results " + record.getColumnsCount() + " should be consistent with output type " + this.outputType.getFieldCount()));
        ArrayList<AnyValue> columns = new ArrayList<AnyValue>(record.getColumnsCount());
        for (int i = 0; i < record.getColumnsCount(); ++i) {
            RelDataTypeField field = (RelDataTypeField)this.outputType.getFieldList().get(i);
            IrResult.Column column = record.getColumns(i);
            columns.add(this.parseEntry(column.getEntry(), field.getType()));
        }
        return columns;
    }

    @Override
    public RelDataType schema() {
        return this.outputType;
    }

    protected AnyValue parseEntry(IrResult.Entry entry, @Nullable RelDataType dataType) {
        if (dataType instanceof GraphPathType) {
            return this.parseElement(entry.getElement(), dataType);
        }
        switch (dataType.getSqlTypeName()) {
            case MULTISET: 
            case ARRAY: {
                if (dataType instanceof ArbitraryArrayType) {
                    return this.parseCollection(entry.getCollection(), ((ArbitraryArrayType)dataType).getComponentTypes());
                }
                return this.parseCollection(entry.getCollection(), dataType.getComponentType());
            }
            case MAP: {
                if (dataType instanceof ArbitraryMapType) {
                    return this.parseKeyValues(entry.getMap(), ((ArbitraryMapType)dataType).getKeyValueTypeMap());
                }
                return this.parseKeyValues(entry.getMap(), dataType.getKeyType(), dataType.getValueType());
            }
        }
        return this.parseElement(entry.getElement(), dataType);
    }

    protected AnyValue parseElement(IrResult.Element element, @Nullable RelDataType dataType) {
        switch (element.getInnerCase()) {
            case VERTEX: {
                return this.parseVertex(element.getVertex(), dataType);
            }
            case EDGE: {
                return this.parseEdge(element.getEdge(), dataType);
            }
            case GRAPH_PATH: {
                return this.parseGraphPath(element.getGraphPath(), dataType);
            }
        }
        return this.parseValue(element.getObject(), dataType);
    }

    protected AnyValue parseCollection(IrResult.Collection collection, RelDataType componentType) {
        switch (componentType.getSqlTypeName()) {
            case BOOLEAN: {
                Boolean[] boolObjs = (Boolean[])collection.getCollectionList().stream().map(k -> k.getObject().getBoolean()).toArray(Boolean[]::new);
                return Values.booleanArray((boolean[])ArrayUtils.toPrimitive((Boolean[])boolObjs));
            }
            case INTEGER: {
                return Values.intArray((int[])collection.getCollectionList().stream().mapToInt(k -> k.getObject().getI32()).toArray());
            }
            case BIGINT: {
                return Values.longArray((long[])collection.getCollectionList().stream().mapToLong(k -> k.getObject().getI64()).toArray());
            }
            case DOUBLE: {
                return Values.doubleArray((double[])collection.getCollectionList().stream().mapToDouble(k -> k.getObject().getF64()).toArray());
            }
            case CHAR: {
                return Values.stringArray((String[])((String[])collection.getCollectionList().stream().map(k -> k.getObject().getStr()).toArray(String[]::new)));
            }
            case ROW: {
                return VirtualValues.fromList(collection.getCollectionList().stream().map(k -> this.parseElement((IrResult.Element)k, componentType)).collect(Collectors.toList()));
            }
        }
        throw new NotImplementedException(componentType.getSqlTypeName() + " is unsupported yet");
    }

    protected AnyValue parseCollection(IrResult.Collection collection, List<RelDataType> componentTypes) {
        List<IrResult.Element> elements = collection.getCollectionList();
        Preconditions.checkArgument((elements.size() == componentTypes.size() ? 1 : 0) != 0, (Object)("Collection element size=" + elements.size() + " is not consistent with type size=" + componentTypes.size()));
        ArrayList values = Lists.newArrayList();
        for (int i = 0; i < elements.size(); ++i) {
            values.add(this.parseElement(elements.get(i), componentTypes.get(i)));
        }
        return VirtualValues.fromList((List)values);
    }

    protected AnyValue parseKeyValues(IrResult.KeyValues keyValues, RelDataType keyType, RelDataType valueType) {
        LinkedHashMap valueMap = Maps.newLinkedHashMap();
        keyValues.getKeyValuesList().forEach(entry -> valueMap.put(entry.getKey().getStr(), this.parseEntry(entry.getValue(), valueType)));
        return VirtualValues.fromMap((Map)valueMap, (long)valueMap.size(), (long)0L);
    }

    protected AnyValue parseKeyValues(IrResult.KeyValues keyValues, Map<RexNode, ArbitraryMapType.KeyValueType> keyValueTypeMap) {
        LinkedHashMap valueMap = Maps.newLinkedHashMap();
        for (IrResult.KeyValues.KeyValue entry : keyValues.getKeyValuesList()) {
            ArbitraryMapType.KeyValueType keyValueType = Utils.getKeyValueType(entry.getKey(), keyValueTypeMap);
            valueMap.put(entry.getKey().getStr(), this.parseEntry(entry.getValue(), keyValueType == null ? null : (RelDataType)keyValueType.getValue()));
        }
        return VirtualValues.fromMap((Map)valueMap, (long)valueMap.size(), (long)0L);
    }

    protected NodeValue parseVertex(IrResult.Vertex vertex, @Nullable RelDataType dataType) {
        return VirtualValues.nodeValue((long)vertex.getId(), (TextArray)Values.stringArray((String[])new String[]{Utils.getLabelName(vertex.getLabel(), Utils.getLabelTypes(dataType))}), (MapValue)this.parseProperties(vertex.getPropertiesList(), dataType));
    }

    protected RelationshipValue parseEdge(IrResult.Edge edge, @Nullable RelDataType dataType) {
        return VirtualValues.relationshipValue((long)edge.getId(), (VirtualNodeValue)VirtualValues.nodeValue((long)edge.getSrcId(), (TextArray)Values.stringArray((String[])new String[]{Utils.getSrcLabelName(edge.getSrcLabel(), Utils.getLabelTypes(dataType))}), (MapValue)MapValue.EMPTY), (VirtualNodeValue)VirtualValues.nodeValue((long)edge.getDstId(), (TextArray)Values.stringArray((String[])new String[]{Utils.getDstLabelName(edge.getDstLabel(), Utils.getLabelTypes(dataType))}), (MapValue)MapValue.EMPTY), (TextValue)Values.stringValue((String)Utils.getLabelName(edge.getLabel(), Utils.getLabelTypes(dataType))), (MapValue)this.parseProperties(edge.getPropertiesList(), dataType));
    }

    private MapValue parseProperties(List<IrResult.Property> properties, RelDataType dataType) {
        LinkedHashMap valueMap = Maps.newLinkedHashMap();
        List typeFields = dataType.getFieldList();
        properties.forEach(k -> {
            String keyStr;
            RelDataTypeField field;
            Common.NameOrId key = k.getKey();
            switch (key.getItemCase()) {
                case NAME: {
                    field = Utils.findFieldByPredicate((Predicate<RelDataTypeField>)((Predicate)k1 -> k1.getName().equals(key.getName())), typeFields);
                    keyStr = key.getName();
                    break;
                }
                default: {
                    field = Utils.findFieldByPredicate((Predicate<RelDataTypeField>)((Predicate)k1 -> k1.getIndex() == key.getId()), typeFields);
                    keyStr = field != null ? field.getName() : String.valueOf(key.getId());
                }
            }
            AnyValue value = this.parseValue(k.getValue(), field != null ? field.getType() : null);
            valueMap.put(keyStr, value);
        });
        return VirtualValues.fromMap((Map)valueMap, (long)valueMap.size(), (long)0L);
    }

    protected AnyValue parseGraphPath(IrResult.GraphPath path, @Nullable RelDataType dataType) {
        ArrayList nodes = Lists.newArrayList();
        ArrayList relationships = Lists.newArrayList();
        path.getPathList().forEach(k -> {
            switch (k.getInnerCase()) {
                case VERTEX: {
                    nodes.add(this.parseVertex(k.getVertex(), Utils.getVertexType(dataType)));
                    break;
                }
                case EDGE: {
                    relationships.add(this.parseEdge(k.getEdge(), Utils.getEdgeType(dataType)));
                }
            }
        });
        return VirtualValues.path((NodeValue[])((NodeValue[])nodes.toArray(NodeValue[]::new)), (RelationshipValue[])((RelationshipValue[])relationships.toArray(RelationshipValue[]::new)));
    }

    protected AnyValue parseValue(Common.Value value, @Nullable RelDataType dataType) {
        if (dataType instanceof GraphLabelType) {
            return Values.stringValue((String)Utils.parseLabelValue(value, (GraphLabelType)dataType));
        }
        switch (value.getItemCase()) {
            case BOOLEAN: {
                return value.getBoolean() ? BooleanValue.TRUE : BooleanValue.FALSE;
            }
            case I32: {
                return Values.intValue((int)value.getI32());
            }
            case I64: {
                return Values.longValue((long)value.getI64());
            }
            case F64: {
                return Values.doubleValue((double)value.getF64());
            }
            case STR: {
                return Values.stringValue((String)value.getStr());
            }
            case I32_ARRAY: {
                return Values.intArray((int[])value.getI32Array().getItemList().stream().mapToInt(k -> k).toArray());
            }
            case I64_ARRAY: {
                return Values.longArray((long[])value.getI64Array().getItemList().stream().mapToLong(k -> k).toArray());
            }
            case F64_ARRAY: {
                return Values.doubleArray((double[])value.getF64Array().getItemList().stream().mapToDouble(k -> k).toArray());
            }
            case STR_ARRAY: {
                return Values.stringArray((String[])((String[])value.getStrArray().getItemList().toArray(String[]::new)));
            }
            case NONE: {
                return Values.NO_VALUE;
            }
            case DATE: {
                Preconditions.checkArgument((dataType.getSqlTypeName() == SqlTypeName.DATE ? 1 : 0) != 0, (Object)"date32 value should have date type");
                return DateValue.epochDate((long)value.getDate().getItem());
            }
            case TIME: {
                Preconditions.checkArgument((dataType.getSqlTypeName() == SqlTypeName.TIME ? 1 : 0) != 0, (Object)"time32 value should have time type");
                return TimeValue.time((long)((long)value.getTime().getItem() * 1000000L), (ZoneOffset)ZoneOffset.UTC);
            }
            case TIMESTAMP: {
                Preconditions.checkArgument((dataType.getSqlTypeName() == SqlTypeName.TIMESTAMP ? 1 : 0) != 0, (Object)"timestamp value should have timestamp type");
                return DateTimeValue.ofEpochMillis((IntegralValue)Values.longValue((long)value.getTimestamp().getItem()));
            }
        }
        throw new NotImplementedException(value.getItemCase() + " is unsupported yet");
    }
}

