/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.cypher.service;

import com.alibaba.graphscope.common.client.ExecutionClient;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.ir.tools.GraphPlanner;
import com.alibaba.graphscope.common.ir.tools.QueryCache;
import com.alibaba.graphscope.common.ir.tools.QueryIdGenerator;
import com.alibaba.graphscope.common.manager.IrMetaQueryCallback;
import com.alibaba.graphscope.cypher.service.CypherQueryServiceBootstrap;
import com.alibaba.graphscope.gremlin.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.facade.DatabaseManagementServiceFactory;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.server.CommunityBootstrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CypherBootstrapper
extends CommunityBootstrapper {
    private static final Logger logger = LoggerFactory.getLogger(CypherBootstrapper.class);
    private final Dependencies externalDependencies;
    private final List<Class<?>> externalClassTypes;
    private final ExecutionClient client;

    public CypherBootstrapper(Configs graphConfig, QueryIdGenerator idGenerator, IrMetaQueryCallback queryCallback, ExecutionClient client, QueryCache queryCache, GraphPlanner graphPlanner) {
        this.client = client;
        this.externalDependencies = this.createExternalDependencies(graphConfig, idGenerator, queryCallback, client, queryCache, graphPlanner);
        this.externalClassTypes = Arrays.asList(Configs.class, QueryIdGenerator.class, IrMetaQueryCallback.class, ExecutionClient.class, QueryCache.class, GraphPlanner.class);
    }

    protected DatabaseManagementService createNeo(Config config, GraphDatabaseDependencies dependencies) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.client.close();
            }
            catch (Exception e) {
                logger.error("close client error", (Throwable)e);
            }
        }));
        dependencies.dependencies((DependencyResolver)this.externalDependencies);
        CypherDatabaseManagementServiceFactory facadeFactory = new CypherDatabaseManagementServiceFactory(DbmsInfo.COMMUNITY, x$0 -> new CypherModuleManagement((GlobalModule)x$0), this.externalClassTypes);
        return facadeFactory.build(config, (ExternalDependencies)dependencies);
    }

    private Dependencies createExternalDependencies(Configs configs, QueryIdGenerator idGenerator, IrMetaQueryCallback queryCallback, ExecutionClient client, QueryCache queryCache, GraphPlanner graphPlanner) {
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{configs, idGenerator, queryCallback, client, queryCache, graphPlanner});
        return dependencies;
    }

    private class CypherModuleManagement
    extends CommunityEditionModule {
        public CypherModuleManagement(GlobalModule globalModule) {
            super(globalModule);
            CypherQueryServiceBootstrap bootstrap = new CypherQueryServiceBootstrap(globalModule.getGlobalLife(), globalModule.getGlobalDependencies(), globalModule.getLogService());
            Utils.setFieldValue(CommunityEditionModule.class, (Object)this, "fabricServicesBootstrap", bootstrap);
        }
    }

    private class CypherDatabaseManagementServiceFactory
    extends DatabaseManagementServiceFactory {
        private final List<Class<?>> externalClassTypes;

        public CypherDatabaseManagementServiceFactory(DbmsInfo dbmsInfo, Function<GlobalModule, AbstractEditionModule> editionFactory, List<Class<?>> externalClassTypes) {
            super(dbmsInfo, editionFactory);
            this.externalClassTypes = externalClassTypes;
        }

        protected GlobalModule createGlobalModule(Config config, ExternalDependencies externalDependencies) {
            GlobalModule globalModule = new GlobalModule(config, this.dbmsInfo, externalDependencies);
            DependencyResolver externalDependencyResolver = globalModule.getExternalDependencyResolver();
            Dependencies globalDependencySatisfier = globalModule.getGlobalDependencies();
            for (Class<?> classType : this.externalClassTypes) {
                if (!externalDependencyResolver.containsDependency(classType)) continue;
                globalDependencySatisfier.satisfyDependency(externalDependencyResolver.resolveDependency(classType));
            }
            return globalModule;
        }
    }
}

