/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin;

import com.alibaba.graphscope.common.utils.ClassUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;

public class Utils
extends ClassUtils {
    public static <V> void setFieldValue(Class<?> clazz, Object obj, String fieldName, V value) {
        Preconditions.checkNotNull((Object)obj);
        Preconditions.checkNotNull((Object)fieldName);
        Preconditions.checkNotNull(value);
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> V getFieldValue(Class<?> clazz, Object obj, String fieldName) {
        Preconditions.checkNotNull((Object)obj);
        Preconditions.checkNotNull((Object)fieldName);
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (V)field.get(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] removeStringEle(int i, String[] data) {
        if (data.length == 0 || i < 0 || i >= data.length) {
            return data;
        }
        String[] copy = new String[data.length - 1];
        for (int j = 0; j < data.length - 1; ++j) {
            copy[j] = j < i ? data[j] : data[j + 1];
        }
        return copy;
    }

    public static String readStringFromFile(String filePath) throws IOException {
        return FileUtils.readFileToString((File)new File(filePath), (Charset)StandardCharsets.UTF_8);
    }
}

