/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.antlr4x.visitor;

import com.alibaba.graphscope.common.antlr4.ExprUniqueAliasInfer;
import com.alibaba.graphscope.common.antlr4.ExprVisitorResult;
import com.alibaba.graphscope.common.antlr4.Utils;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphAggCall;
import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.alibaba.graphscope.common.ir.rex.RexTmpVariable;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.GraphStdOperatorTable;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.type.GraphSchemaType;
import com.alibaba.graphscope.grammar.GremlinGSBaseVisitor;
import com.alibaba.graphscope.grammar.GremlinGSParser;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.LiteralVisitor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.NlsString;
import org.apache.commons.lang3.ObjectUtils;

public class ExtExpressionVisitor
extends GremlinGSBaseVisitor<ExprVisitorResult> {
    private final GraphBuilder builder;
    private final ExprUniqueAliasInfer aliasInfer;

    public ExtExpressionVisitor(GraphBuilder builder, ExprUniqueAliasInfer aliasInfer) {
        this.builder = Objects.requireNonNull(builder);
        this.aliasInfer = Objects.requireNonNull(aliasInfer);
    }

    @Override
    public ExprVisitorResult visitTraversalMethod_expr(GremlinGSParser.TraversalMethod_exprContext ctx) {
        return (ExprVisitorResult)this.visitOC_Expression(ctx.oC_Expression());
    }

    @Override
    public ExprVisitorResult visitOC_OrExpression(GremlinGSParser.OC_OrExpressionContext ctx) {
        if (ObjectUtils.isEmpty(ctx.oC_AndExpression())) {
            throw new IllegalArgumentException("and expression should not be empty");
        }
        return Utils.binaryCall((SqlOperator)GraphStdOperatorTable.OR, ctx.oC_AndExpression().stream().map(k -> this.visitOC_AndExpression((GremlinGSParser.OC_AndExpressionContext)((Object)k))).collect(Collectors.toList()), this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_AndExpression(GremlinGSParser.OC_AndExpressionContext ctx) {
        if (ObjectUtils.isEmpty(ctx.oC_NotExpression())) {
            throw new IllegalArgumentException("operands should not be empty in 'AND' operator");
        }
        return Utils.binaryCall((SqlOperator)GraphStdOperatorTable.AND, ctx.oC_NotExpression().stream().map(k -> this.visitOC_NotExpression((GremlinGSParser.OC_NotExpressionContext)((Object)k))).collect(Collectors.toList()), this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_NotExpression(GremlinGSParser.OC_NotExpressionContext ctx) {
        ExprVisitorResult operand = this.visitOC_NullPredicateExpression(ctx.oC_NullPredicateExpression());
        List<TerminalNode> notNodes = ctx.NOT();
        return Utils.unaryCall((List<SqlOperator>)(ObjectUtils.isNotEmpty(notNodes) && (notNodes.size() & 1) != 0 ? ImmutableList.of((Object)GraphStdOperatorTable.NOT) : ImmutableList.of()), operand, this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_ComparisonExpression(GremlinGSParser.OC_ComparisonExpressionContext ctx) {
        ArrayList<SqlOperator> operators = new ArrayList<SqlOperator>();
        ArrayList<ExprVisitorResult> operands = new ArrayList<ExprVisitorResult>();
        operands.add(this.visitOC_StringOrListPredicateExpression(ctx.oC_StringOrListPredicateExpression()));
        for (GremlinGSParser.OC_PartialComparisonExpressionContext partialCtx : ctx.oC_PartialComparisonExpression()) {
            operands.add(this.visitOC_StringOrListPredicateExpression(partialCtx.oC_StringOrListPredicateExpression()));
            operators.addAll(Utils.getOperators(partialCtx.children, (List<String>)ImmutableList.of((Object)"=", (Object)"<>", (Object)"<", (Object)">", (Object)"<=", (Object)">="), false));
        }
        return Utils.binaryCall(operators, operands, this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_StringOrListPredicateExpression(GremlinGSParser.OC_StringOrListPredicateExpressionContext ctx) {
        ArrayList operands = Lists.newArrayList((Object[])new ExprVisitorResult[]{this.visitOC_AddOrSubtractOrBitManipulationExpression(ctx.oC_AddOrSubtractOrBitManipulationExpression(0))});
        ArrayList operators = Lists.newArrayList();
        if (ctx.STARTS() != null && ctx.WITH() != null || ctx.ENDS() != null && ctx.WITH() != null || ctx.CONTAINS() != null) {
            RexNode rightExpr = this.visitOC_AddOrSubtractOrBitManipulationExpression(ctx.oC_AddOrSubtractOrBitManipulationExpression(1)).getExpr();
            Preconditions.checkArgument((rightExpr.getKind() == SqlKind.LITERAL && rightExpr.getType().getFamily() == SqlTypeFamily.CHARACTER ? 1 : 0) != 0, (Object)"the right operand of string predicate expression should be a string literal");
            String value = ((NlsString)((RexLiteral)rightExpr).getValueAs(NlsString.class)).getValue();
            StringBuilder regexPattern = new StringBuilder();
            if (ctx.STARTS() != null && ctx.WITH() != null) {
                regexPattern.append("^");
                regexPattern.append(value);
                regexPattern.append(".*");
            } else if (ctx.ENDS() != null && ctx.WITH() != null) {
                regexPattern.append(".*");
                regexPattern.append(value);
                regexPattern.append("$");
            } else {
                regexPattern.append(".*");
                regexPattern.append(value);
                regexPattern.append(".*");
            }
            operands.add(new ExprVisitorResult((RexNode)this.builder.literal(regexPattern.toString())));
            operators.add(GraphStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE);
        } else if (ctx.IN() != null) {
            operands.add(this.visitOC_AddOrSubtractOrBitManipulationExpression(ctx.oC_AddOrSubtractOrBitManipulationExpression(1)));
            operators.add(GraphStdOperatorTable.IN);
        }
        return Utils.binaryCall(operators, (List<ExprVisitorResult>)operands, this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_NullPredicateExpression(GremlinGSParser.OC_NullPredicateExpressionContext ctx) {
        ExprVisitorResult operand = this.visitOC_ComparisonExpression(ctx.oC_ComparisonExpression());
        ArrayList operators = Lists.newArrayList();
        if (ctx.IS() != null && ctx.NOT() != null && ctx.NULL() != null) {
            operators.add(GraphStdOperatorTable.IS_NOT_NULL);
        } else if (ctx.IS() != null && ctx.NULL() != null) {
            operators.add(GraphStdOperatorTable.IS_NULL);
        }
        return Utils.unaryCall(operators, operand, this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_AddOrSubtractOrBitManipulationExpression(GremlinGSParser.OC_AddOrSubtractOrBitManipulationExpressionContext ctx) {
        if (ObjectUtils.isEmpty(ctx.oC_MultiplyDivideModuloExpression())) {
            throw new IllegalArgumentException("multiply or divide expression should not be empty");
        }
        List<SqlOperator> operators = Utils.getOperators(ctx.children, (List<String>)ImmutableList.of((Object)"+", (Object)"-", (Object)"&", (Object)"|", (Object)"^", (Object)"<<", (Object)">>"), false);
        return Utils.binaryCall(operators, ctx.oC_MultiplyDivideModuloExpression().stream().map(k -> this.visitOC_MultiplyDivideModuloExpression((GremlinGSParser.OC_MultiplyDivideModuloExpressionContext)((Object)k))).collect(Collectors.toList()), this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_MultiplyDivideModuloExpression(GremlinGSParser.OC_MultiplyDivideModuloExpressionContext ctx) {
        Preconditions.checkArgument((boolean)ObjectUtils.isNotEmpty(ctx.oC_UnaryAddOrSubtractExpression()), (Object)"bit manipulation expression should not be empty");
        List<SqlOperator> operators = Utils.getOperators(ctx.children, (List<String>)ImmutableList.of((Object)"*", (Object)"/", (Object)"%"), false);
        return Utils.binaryCall(operators, ctx.oC_UnaryAddOrSubtractExpression().stream().map(k -> this.visitOC_UnaryAddOrSubtractExpression((GremlinGSParser.OC_UnaryAddOrSubtractExpressionContext)((Object)k))).collect(Collectors.toList()), this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_UnaryAddOrSubtractExpression(GremlinGSParser.OC_UnaryAddOrSubtractExpressionContext ctx) {
        ExprVisitorResult operand = (ExprVisitorResult)this.visitOC_ListOperatorExpression(ctx.oC_ListOperatorExpression());
        List<SqlOperator> operators = Utils.getOperators(ctx.children, (List<String>)ImmutableList.of((Object)"-", (Object)"+"), true);
        return Utils.unaryCall(operators, operand, this.builder);
    }

    @Override
    public ExprVisitorResult visitOC_PropertyOrLabelsExpression(GremlinGSParser.OC_PropertyOrLabelsExpressionContext ctx) {
        if (ctx.oC_PropertyLookup() == null) {
            return (ExprVisitorResult)this.visitOC_Atom(ctx.oC_Atom());
        }
        if (ctx.oC_Atom().oC_Literal() != null) {
            throw new IllegalArgumentException("cannot get property from an literal");
        }
        String aliasName = ctx.oC_Atom().oC_Variable().getText();
        RexGraphVariable variable = this.builder.variable(aliasName);
        String propertyName = ctx.oC_PropertyLookup().oC_PropertyKeyName().getText();
        RexGraphVariable expr = variable.getType() instanceof GraphSchemaType ? this.builder.variable(aliasName, propertyName) : this.builder.call((SqlOperator)GraphStdOperatorTable.EXTRACT, new RexNode[]{Utils.createIntervalExpr(null, Utils.createExtractUnit(propertyName), this.builder), variable});
        return new ExprVisitorResult((RexNode)expr);
    }

    @Override
    public ExprVisitorResult visitOC_ParenthesizedExpression(GremlinGSParser.OC_ParenthesizedExpressionContext ctx) {
        return (ExprVisitorResult)this.visitOC_Expression(ctx.oC_Expression());
    }

    @Override
    public ExprVisitorResult visitOC_Variable(GremlinGSParser.OC_VariableContext ctx) {
        String aliasName = ctx.getText();
        return new ExprVisitorResult((RexNode)this.builder.variable(aliasName));
    }

    @Override
    public ExprVisitorResult visitOC_PatternPredicate(GremlinGSParser.OC_PatternPredicateContext ctx) {
        throw new UnsupportedOperationException("pattern predicate is unsupported in gremlin expression");
    }

    @Override
    public ExprVisitorResult visitOC_Literal(GremlinGSParser.OC_LiteralContext ctx) {
        if (ctx.StringLiteral() != null) {
            return new ExprVisitorResult((RexNode)this.builder.literal(LiteralVisitor.INSTANCE.visitTerminal(ctx.StringLiteral())));
        }
        if (ctx.NULL() != null) {
            return new ExprVisitorResult((RexNode)this.builder.literal(LiteralVisitor.INSTANCE.visitTerminal(ctx.NULL())));
        }
        return (ExprVisitorResult)super.visitOC_Literal(ctx);
    }

    @Override
    public ExprVisitorResult visitOC_ListLiteral(GremlinGSParser.OC_ListLiteralContext ctx) {
        List<ExprVisitorResult> operands = ctx.oC_Expression().stream().map(k -> (ExprVisitorResult)this.visitOC_Expression((GremlinGSParser.OC_ExpressionContext)((Object)k))).collect(Collectors.toList());
        ArrayList aggCallList = Lists.newArrayList();
        ArrayList expressions = Lists.newArrayList();
        operands.forEach(k -> {
            if (!k.getAggCalls().isEmpty()) {
                aggCallList.addAll(k.getAggCalls());
            }
            expressions.add(k.getExpr());
        });
        return new ExprVisitorResult(aggCallList, this.builder.call(GraphStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, expressions));
    }

    @Override
    public ExprVisitorResult visitOC_MapLiteral(GremlinGSParser.OC_MapLiteralContext ctx) {
        List keys = ctx.oC_PropertyKeyName().stream().map(k -> k.getText()).collect(Collectors.toList());
        List values = ctx.oC_Expression().stream().map(k -> (ExprVisitorResult)this.visitOC_Expression((GremlinGSParser.OC_ExpressionContext)((Object)k))).collect(Collectors.toList());
        Preconditions.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (Object)("keys size=" + keys.size() + " is not consistent with values size=" + values.size() + " in MapLiteral"));
        ArrayList aggCallList = Lists.newArrayList();
        ArrayList expressions = Lists.newArrayList();
        for (int i = 0; i < keys.size(); ++i) {
            ExprVisitorResult valueExpr = (ExprVisitorResult)values.get(i);
            if (!valueExpr.getAggCalls().isEmpty()) {
                aggCallList.addAll(valueExpr.getAggCalls());
            }
            expressions.add(this.builder.literal(keys.get(i)));
            expressions.add(valueExpr.getExpr());
        }
        return new ExprVisitorResult(aggCallList, this.builder.call(GraphStdOperatorTable.MAP_VALUE_CONSTRUCTOR, expressions));
    }

    @Override
    public ExprVisitorResult visitOC_BooleanLiteral(GremlinGSParser.OC_BooleanLiteralContext ctx) {
        return new ExprVisitorResult((RexNode)this.builder.literal(LiteralVisitor.INSTANCE.visitOC_BooleanLiteral(ctx)));
    }

    @Override
    public ExprVisitorResult visitOC_IntegerLiteral(GremlinGSParser.OC_IntegerLiteralContext ctx) {
        return new ExprVisitorResult((RexNode)this.builder.literal(LiteralVisitor.INSTANCE.visitOC_IntegerLiteral(ctx)));
    }

    @Override
    public ExprVisitorResult visitOC_DoubleLiteral(GremlinGSParser.OC_DoubleLiteralContext ctx) {
        return new ExprVisitorResult((RexNode)this.builder.literal(LiteralVisitor.INSTANCE.visitOC_DoubleLiteral(ctx)));
    }

    @Override
    public ExprVisitorResult visitOC_AggregateFunctionInvocation(GremlinGSParser.OC_AggregateFunctionInvocationContext ctx) {
        RelBuilder.AggCall aggCall;
        List variables = ctx.oC_Expression().stream().map(k -> ((ExprVisitorResult)this.visitOC_Expression((GremlinGSParser.OC_ExpressionContext)((Object)k))).getExpr()).collect(Collectors.toList());
        String alias = this.aliasInfer.infer();
        String functionName = ctx.getChild(0).getText();
        boolean isDistinct = ctx.DISTINCT() != null;
        switch (functionName.toUpperCase()) {
            case "COUNT": {
                aggCall = this.builder.count(isDistinct, alias, variables);
                break;
            }
            case "SUM": {
                aggCall = this.builder.sum(isDistinct, alias, (RexNode)variables.get(0));
                break;
            }
            case "AVG": {
                aggCall = this.builder.avg(isDistinct, alias, (RexNode)variables.get(0));
                break;
            }
            case "MIN": {
                aggCall = this.builder.min(alias, (RexNode)variables.get(0));
                break;
            }
            case "MAX": {
                aggCall = this.builder.max(alias, (RexNode)variables.get(0));
                break;
            }
            case "COLLECT": {
                aggCall = this.builder.collect(ctx.DISTINCT() != null, alias, variables);
                break;
            }
            default: {
                throw new UnsupportedOperationException("aggregate function " + functionName + " is unsupported yet");
            }
        }
        return new ExprVisitorResult((List<RelBuilder.AggCall>)ImmutableList.of((Object)aggCall), (RexNode)RexTmpVariable.of(alias, ((GraphAggCall)aggCall).getType()));
    }

    @Override
    public ExprVisitorResult visitOC_ScalarFunctionInvocation(GremlinGSParser.OC_ScalarFunctionInvocationContext ctx) {
        List<GremlinGSParser.OC_ExpressionContext> exprCtx = ctx.oC_Expression();
        String functionName = ctx.getChild(0).getText();
        switch (functionName.toUpperCase()) {
            case "LABELS": {
                RexGraphVariable labelVar = this.builder.variable(exprCtx.get(0).getText());
                Preconditions.checkArgument((labelVar.getType() instanceof GraphSchemaType && ((GraphSchemaType)labelVar.getType()).getScanOpt() == GraphOpt.Source.VERTEX ? 1 : 0) != 0, (Object)"'labels' can only be applied on vertex type");
                return new ExprVisitorResult((RexNode)this.builder.variable(exprCtx.get(0).getText(), "~label"));
            }
            case "TYPE": {
                RexGraphVariable typeVar = this.builder.variable(exprCtx.get(0).getText());
                Preconditions.checkArgument((typeVar.getType() instanceof GraphSchemaType && ((GraphSchemaType)typeVar.getType()).getScanOpt() == GraphOpt.Source.EDGE ? 1 : 0) != 0, (Object)"'type' can only be applied on edge type");
                return new ExprVisitorResult((RexNode)this.builder.variable(exprCtx.get(0).getText(), "~label"));
            }
            case "ELEMENTID": {
                RexGraphVariable idVar = this.builder.variable(exprCtx.get(0).getText());
                Preconditions.checkArgument((boolean)(idVar.getType() instanceof GraphSchemaType), (Object)"'elementId' can only be applied on vertex or edge type");
                return new ExprVisitorResult((RexNode)this.builder.variable(exprCtx.get(0).getText(), "~id"));
            }
            case "LENGTH": {
                Preconditions.checkArgument((!exprCtx.isEmpty() ? 1 : 0) != 0, (Object)"LENGTH function should have one argument");
                return new ExprVisitorResult((RexNode)this.builder.variable(exprCtx.get(0).getText(), "~len"));
            }
            case "HEAD": {
                Preconditions.checkArgument((!exprCtx.isEmpty() ? 1 : 0) != 0, (Object)"HEAD function should have one argument");
                String errorMessage = "'head(collect(...))' is the only supported usage of HEAD function";
                ExprVisitorResult argResult = (ExprVisitorResult)this.visitOC_Expression(exprCtx.get(0));
                List<RelBuilder.AggCall> aggCalls = argResult.getAggCalls();
                if (aggCalls.size() == 1) {
                    GraphAggCall oldAggCall = (GraphAggCall)aggCalls.get(0);
                    if (oldAggCall.getAggFunction().getKind() == SqlKind.COLLECT) {
                        GraphAggCall newAggCall = new GraphAggCall(oldAggCall.getCluster(), GraphStdOperatorTable.FIRST_VALUE, oldAggCall.getOperands()).as(oldAggCall.getAlias());
                        return new ExprVisitorResult((List<RelBuilder.AggCall>)ImmutableList.of((Object)newAggCall), argResult.getExpr());
                    }
                    throw new UnsupportedOperationException(errorMessage + " , but got " + oldAggCall.getAggFunction().getName());
                }
                throw new UnsupportedOperationException(errorMessage);
            }
            case "POWER": {
                Preconditions.checkArgument((exprCtx.size() == 2 ? 1 : 0) != 0, (Object)"POWER function should have two arguments");
                ExprVisitorResult left = (ExprVisitorResult)this.visitOC_Expression(exprCtx.get(0));
                ExprVisitorResult right = (ExprVisitorResult)this.visitOC_Expression(exprCtx.get(1));
                ArrayList allAggCalls = Lists.newArrayList();
                allAggCalls.addAll(left.getAggCalls());
                allAggCalls.addAll(right.getAggCalls());
                return new ExprVisitorResult(allAggCalls, this.builder.call((SqlOperator)GraphStdOperatorTable.POWER, left.getExpr(), right.getExpr()));
            }
            case "DURATION": {
                ExprVisitorResult operand = (ExprVisitorResult)this.visitOC_Expression(exprCtx.get(0));
                Preconditions.checkArgument((operand.getExpr().getKind() == SqlKind.MAP_VALUE_CONSTRUCTOR ? 1 : 0) != 0, (Object)"parameter of scalar function 'duration' should be a map literal");
                RexCall mapValues = (RexCall)operand.getExpr();
                RexNode intervals = null;
                for (int i = 0; i < mapValues.getOperands().size(); i += 2) {
                    RexNode key = (RexNode)mapValues.getOperands().get(i);
                    RexNode value = (RexNode)mapValues.getOperands().get(i + 1);
                    String timeField = ((NlsString)((RexLiteral)key).getValueAs(NlsString.class)).getValue();
                    RexNode interval = Utils.createIntervalExpr(value, Utils.createDurationUnit(timeField), this.builder);
                    intervals = intervals == null ? interval : this.builder.call((SqlOperator)GraphStdOperatorTable.PLUS, intervals, interval);
                }
                Preconditions.checkArgument((intervals != null ? 1 : 0) != 0, (Object)"parameter of scalar function 'duration' should not be empty");
                return new ExprVisitorResult(operand.getAggCalls(), intervals);
            }
        }
        throw new IllegalArgumentException("scalar function " + functionName + " is unsupported yet");
    }

    @Override
    public ExprVisitorResult visitOC_CountAny(GremlinGSParser.OC_CountAnyContext ctx) {
        String alias = this.aliasInfer.infer();
        RelBuilder.AggCall aggCall = this.builder.count(new RexNode[0]);
        return new ExprVisitorResult((List<RelBuilder.AggCall>)ImmutableList.of((Object)aggCall), (RexNode)RexTmpVariable.of(alias, ((GraphAggCall)aggCall).getType()));
    }

    @Override
    public ExprVisitorResult visitOC_CaseExpression(GremlinGSParser.OC_CaseExpressionContext ctx) {
        ExprVisitorResult inputExpr = ctx.oC_InputExpression() == null ? null : (ExprVisitorResult)this.visitOC_InputExpression(ctx.oC_InputExpression());
        ArrayList operands = Lists.newArrayList();
        for (GremlinGSParser.OC_CaseAlternativeContext whenThen : ctx.oC_CaseAlternative()) {
            Preconditions.checkArgument((whenThen.oC_Expression().size() == 2 ? 1 : 0) != 0, (Object)"whenThen expression should have 2 parts");
            ExprVisitorResult whenExpr = (ExprVisitorResult)this.visitOC_Expression(whenThen.oC_Expression(0));
            if (inputExpr != null) {
                operands.add(this.builder.equals(inputExpr.getExpr(), whenExpr.getExpr()));
            } else {
                operands.add(whenExpr.getExpr());
            }
            ExprVisitorResult thenExpr = (ExprVisitorResult)this.visitOC_Expression(whenThen.oC_Expression(1));
            operands.add(thenExpr.getExpr());
        }
        ExprVisitorResult elseExpr = ctx.oC_ElseExpression() == null ? new ExprVisitorResult((RexNode)this.builder.literal(null)) : (ExprVisitorResult)this.visitOC_ElseExpression(ctx.oC_ElseExpression());
        operands.add(elseExpr.getExpr());
        return new ExprVisitorResult(this.builder.call(GraphStdOperatorTable.CASE, operands));
    }
}

