/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.antlr4x.visitor;

import com.alibaba.graphscope.common.antlr4.ExprUniqueAliasInfer;
import com.alibaba.graphscope.common.antlr4.ExprVisitorResult;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalProject;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalPathExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalSource;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphAggCall;
import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.alibaba.graphscope.common.ir.rex.RexTmpVariableConverter;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.GraphStdOperatorTable;
import com.alibaba.graphscope.common.ir.tools.config.ExpandConfig;
import com.alibaba.graphscope.common.ir.tools.config.GetVConfig;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.tools.config.LabelConfig;
import com.alibaba.graphscope.common.ir.tools.config.SourceConfig;
import com.alibaba.graphscope.grammar.GremlinGSBaseVisitor;
import com.alibaba.graphscope.grammar.GremlinGSParser;
import com.alibaba.graphscope.gremlin.antlr4.TraversalEnumParser;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.ExpressionVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.ExtExpressionVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.LiteralList;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.LiteralVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.NestedTraversalRelVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.NestedTraversalRexVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.NonStringValueByVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.PathExpandBuilderVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.TraversalMethodIterator;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.Utils;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.WherePredicateVisitor;
import com.alibaba.graphscope.gremlin.exception.InvalidGremlinScriptException;
import com.alibaba.graphscope.gremlin.exception.UnsupportedEvalException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.tools.RelBuilder;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.T;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.javatuples.Pair;

public class GraphBuilderVisitor
extends GremlinGSBaseVisitor<GraphBuilder> {
    private final GraphBuilder builder;
    private final ExprUniqueAliasInfer aliasInfer;
    private final Predicate<ParseTree> trimAlias;

    public GraphBuilderVisitor(GraphBuilder builder) {
        this(builder, new ExprUniqueAliasInfer());
    }

    public GraphBuilderVisitor(GraphBuilder builder, ExprUniqueAliasInfer aliasInfer) {
        this(builder, aliasInfer, t -> false);
    }

    public GraphBuilderVisitor(GraphBuilder builder, Predicate<ParseTree> trimAlias) {
        this(builder, new ExprUniqueAliasInfer(), trimAlias);
    }

    public GraphBuilderVisitor(GraphBuilder builder, ExprUniqueAliasInfer aliasInfer, Predicate<ParseTree> trimAlias) {
        this.builder = Objects.requireNonNull(builder);
        this.aliasInfer = Objects.requireNonNull(aliasInfer);
        this.trimAlias = Objects.requireNonNull(trimAlias);
    }

    public GraphBuilder visitChildren(RuleNode node) {
        GraphBuilder result = (GraphBuilder)((Object)this.defaultResult());
        int n = node.getChildCount();
        for (int i = 0; i < n && this.shouldVisitNextChild(node, (Object)result); ++i) {
            ParseTree c = node.getChild(i);
            GraphBuilder childResult = !this.trimAlias.test(c) ? (GraphBuilder)((Object)c.accept((ParseTreeVisitor)this)) : this.builder;
            result = (GraphBuilder)((Object)this.aggregateResult((Object)result, (Object)childResult));
        }
        return result;
    }

    @Override
    public GraphBuilder visitQuery(GremlinGSParser.QueryContext ctx) {
        super.visitQuery(ctx);
        return this.appendTailProject();
    }

    @Override
    public GraphBuilder visitTraversalSourceSpawnMethod_V(GremlinGSParser.TraversalSourceSpawnMethod_VContext ctx) {
        this.builder.source(new SourceConfig(GraphOpt.Source.VERTEX, new LabelConfig(true)));
        List<Number> ids = new LiteralList(ctx.oC_ListLiteral(), ctx.oC_Expression()).toList(Number.class);
        if (ids.size() == 1) {
            return this.builder.filter(this.builder.call((SqlOperator)GraphStdOperatorTable.EQUALS, new RexNode[]{this.builder.variable(null, "~id"), this.builder.literal(ids.get(0))}));
        }
        if (ids.size() > 1) {
            return this.builder.filter(this.builder.getRexBuilder().makeIn((RexNode)this.builder.variable(null, "~id"), ids.stream().map(k -> this.builder.literal(k)).collect(Collectors.toList())));
        }
        return this.builder;
    }

    @Override
    public GraphBuilder visitTraversalSourceSpawnMethod_E(GremlinGSParser.TraversalSourceSpawnMethod_EContext ctx) {
        this.builder.source(new SourceConfig(GraphOpt.Source.EDGE, new LabelConfig(true)));
        List<Number> ids = new LiteralList(ctx.oC_ListLiteral(), ctx.oC_Expression()).toList(Number.class);
        if (ids.size() == 1) {
            return this.builder.filter(this.builder.call((SqlOperator)GraphStdOperatorTable.EQUALS, new RexNode[]{this.builder.variable(null, "~id"), this.builder.literal(ids.get(0))}));
        }
        if (ids.size() > 1) {
            return this.builder.filter(this.builder.getRexBuilder().makeIn((RexNode)this.builder.variable(null, "~id"), ids.stream().map(k -> this.builder.literal(k)).collect(Collectors.toList())));
        }
        return this.builder;
    }

    @Override
    public GraphBuilder visitTraversalMethod_hasLabel(GremlinGSParser.TraversalMethod_hasLabelContext ctx) {
        List<String> labels = new LiteralList(ctx.oC_ListLiteral(), ctx.oC_Expression()).toList(String.class);
        Preconditions.checkArgument((!labels.isEmpty() ? 1 : 0) != 0, (Object)"there should be at least one label parameter in `hasLabel`");
        if (labels.size() == 1) {
            return this.builder.filter(this.builder.call((SqlOperator)GraphStdOperatorTable.EQUALS, new RexNode[]{this.builder.variable(null, "~label"), this.builder.literal(labels.get(0))}));
        }
        RexNode labelFilters = this.builder.getRexBuilder().makeIn((RexNode)this.builder.variable(null, "~label"), labels.stream().map(k -> this.builder.literal(k)).collect(Collectors.toList()));
        return this.builder.filter(labelFilters);
    }

    @Override
    public GraphBuilder visitTraversalMethod_hasId(GremlinGSParser.TraversalMethod_hasIdContext ctx) {
        List<Number> ids = new LiteralList(ctx.oC_ListLiteral(), ctx.oC_Expression()).toList(Number.class);
        Preconditions.checkArgument((!ids.isEmpty() ? 1 : 0) != 0, (Object)"there should be at least one id parameter in `hasId`");
        if (ids.size() == 1) {
            return this.builder.filter(this.builder.call((SqlOperator)GraphStdOperatorTable.EQUALS, new RexNode[]{this.builder.variable(null, "~id"), this.builder.literal(ids.get(0))}));
        }
        RexNode idFilters = this.builder.getRexBuilder().makeIn((RexNode)this.builder.variable(null, "~id"), ids.stream().map(k -> this.builder.literal(k)).collect(Collectors.toList()));
        return this.builder.filter(idFilters);
    }

    @Override
    public GraphBuilder visitTraversalMethod_has(GremlinGSParser.TraversalMethod_hasContext ctx) {
        String notice = "supported pattern is [has('key', 'value')] or [has('key', P)] or [has('label', 'key', 'value')] or [has('label', 'key', P)]";
        int childCount = ctx.getChildCount();
        if (childCount == 6 && ctx.oC_Literal() != null) {
            String propertyKey = (String)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral(0));
            Object propertyValue = LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal());
            return this.builder.filter(this.builder.call((SqlOperator)GraphStdOperatorTable.EQUALS, new RexNode[]{this.builder.variable(null, propertyKey), this.builder.literal(propertyValue)}));
        }
        if (childCount == 6 && ctx.traversalPredicate() != null) {
            String propertyKey = (String)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral(0));
            ExpressionVisitor exprVisitor = new ExpressionVisitor(this.builder, (RexNode)this.builder.variable(null, propertyKey));
            return this.builder.filter(exprVisitor.visitTraversalPredicate(ctx.traversalPredicate()));
        }
        if (childCount == 8 && ctx.oC_Literal() != null) {
            String labelValue = (String)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral(0));
            String propertyKey = (String)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral(1));
            Object propertyValue = LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal());
            return this.builder.filter(this.builder.call((SqlOperator)GraphStdOperatorTable.AND, this.builder.call((SqlOperator)GraphStdOperatorTable.EQUALS, new RexNode[]{this.builder.variable(null, "~label"), this.builder.literal(labelValue)}), this.builder.call((SqlOperator)GraphStdOperatorTable.EQUALS, new RexNode[]{this.builder.variable(null, propertyKey), this.builder.literal(propertyValue)})));
        }
        if (childCount == 8 && ctx.traversalPredicate() != null) {
            String labelValue = (String)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral(0));
            String propertyKey = (String)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral(1));
            ExpressionVisitor exprVisitor = new ExpressionVisitor(this.builder, (RexNode)this.builder.variable(null, propertyKey));
            return this.builder.filter(this.builder.call((SqlOperator)GraphStdOperatorTable.AND, this.builder.call((SqlOperator)GraphStdOperatorTable.EQUALS, new RexNode[]{this.builder.variable(null, "~label"), this.builder.literal(labelValue)}), exprVisitor.visitTraversalPredicate(ctx.traversalPredicate())));
        }
        if (childCount == 4 && ctx.StringLiteral() != null) {
            String propertyKey = LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral(0)).toString();
            return this.builder.filter(this.builder.call((SqlOperator)GraphStdOperatorTable.IS_NOT_NULL, new RexNode[]{this.builder.variable(null, propertyKey)}));
        }
        throw new UnsupportedEvalException(((Object)((Object)ctx)).getClass(), notice);
    }

    @Override
    public GraphBuilder visitTraversalMethod_hasNot(GremlinGSParser.TraversalMethod_hasNotContext ctx) {
        String propertyKey = (String)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral());
        return this.builder.filter(this.builder.call((SqlOperator)GraphStdOperatorTable.IS_NULL, new RexNode[]{this.builder.variable(null, propertyKey)}));
    }

    @Override
    public GraphBuilder visitTraversalMethod_outE(GremlinGSParser.TraversalMethod_outEContext ctx) {
        this.builder.expand(new ExpandConfig(GraphOpt.Expand.OUT, this.getLabelConfig(ctx.oC_ListLiteral(), ctx.oC_Expression())));
        if (ctx.traversalMethod_inV() != null) {
            this.visitTraversalMethod_inV(ctx.traversalMethod_inV());
        }
        return this.builder;
    }

    @Override
    public GraphBuilder visitTraversalMethod_inE(GremlinGSParser.TraversalMethod_inEContext ctx) {
        this.builder.expand(new ExpandConfig(GraphOpt.Expand.IN, this.getLabelConfig(ctx.oC_ListLiteral(), ctx.oC_Expression())));
        if (ctx.traversalMethod_outV() != null) {
            this.visitTraversalMethod_outV(ctx.traversalMethod_outV());
        }
        return this.builder;
    }

    @Override
    public GraphBuilder visitTraversalMethod_bothE(GremlinGSParser.TraversalMethod_bothEContext ctx) {
        this.builder.expand(new ExpandConfig(GraphOpt.Expand.BOTH, this.getLabelConfig(ctx.oC_ListLiteral(), ctx.oC_Expression())));
        if (ctx.traversalMethod_otherV() != null) {
            this.visitTraversalMethod_otherV(ctx.traversalMethod_otherV());
        }
        return this.builder;
    }

    @Override
    public GraphBuilder visitTraversalMethod_outV(GremlinGSParser.TraversalMethod_outVContext ctx) {
        return this.builder.getV(new GetVConfig(GraphOpt.GetV.START, new LabelConfig(true)));
    }

    @Override
    public GraphBuilder visitTraversalMethod_inV(GremlinGSParser.TraversalMethod_inVContext ctx) {
        return this.builder.getV(new GetVConfig(GraphOpt.GetV.END, new LabelConfig(true)));
    }

    @Override
    public GraphBuilder visitTraversalMethod_otherV(GremlinGSParser.TraversalMethod_otherVContext ctx) {
        return this.builder.getV(new GetVConfig(GraphOpt.GetV.OTHER, new LabelConfig(true)));
    }

    @Override
    public GraphBuilder visitTraversalMethod_endV(GremlinGSParser.TraversalMethod_endVContext ctx) {
        RelNode peek = this.builder.peek();
        if (peek instanceof GraphLogicalPathExpand) {
            GraphLogicalPathExpand pathExpand = (GraphLogicalPathExpand)peek;
            GraphLogicalExpand expand = (GraphLogicalExpand)pathExpand.getExpand();
            switch (expand.getOpt()) {
                case OUT: {
                    return this.builder.getV(new GetVConfig(GraphOpt.GetV.END, new LabelConfig(true)));
                }
                case IN: {
                    return this.builder.getV(new GetVConfig(GraphOpt.GetV.START, new LabelConfig(true)));
                }
            }
            return this.builder.getV(new GetVConfig(GraphOpt.GetV.OTHER, new LabelConfig(true)));
        }
        throw new InvalidGremlinScriptException("endV should follow with path expand");
    }

    @Override
    public GraphBuilder visitTraversalMethod_out(GremlinGSParser.TraversalMethod_outContext ctx) {
        if (this.pathExpandPattern(ctx.oC_ListLiteral(), ctx.oC_Expression())) {
            return this.builder.pathExpand(new PathExpandBuilderVisitor(this).visitTraversalMethod_out(ctx).buildConfig());
        }
        return this.builder.expand(new ExpandConfig(GraphOpt.Expand.OUT, this.getLabelConfig(ctx.oC_ListLiteral(), ctx.oC_Expression()))).getV(new GetVConfig(GraphOpt.GetV.END, new LabelConfig(true)));
    }

    @Override
    public GraphBuilder visitTraversalMethod_in(GremlinGSParser.TraversalMethod_inContext ctx) {
        if (this.pathExpandPattern(ctx.oC_ListLiteral(), ctx.oC_Expression())) {
            return this.builder.pathExpand(new PathExpandBuilderVisitor(this).visitTraversalMethod_in(ctx).buildConfig());
        }
        return this.builder.expand(new ExpandConfig(GraphOpt.Expand.IN, this.getLabelConfig(ctx.oC_ListLiteral(), ctx.oC_Expression()))).getV(new GetVConfig(GraphOpt.GetV.START, new LabelConfig(true)));
    }

    @Override
    public GraphBuilder visitTraversalMethod_both(GremlinGSParser.TraversalMethod_bothContext ctx) {
        if (this.pathExpandPattern(ctx.oC_ListLiteral(), ctx.oC_Expression())) {
            return this.builder.pathExpand(new PathExpandBuilderVisitor(this).visitTraversalMethod_both(ctx).buildConfig());
        }
        return this.builder.expand(new ExpandConfig(GraphOpt.Expand.BOTH, this.getLabelConfig(ctx.oC_ListLiteral(), ctx.oC_Expression()))).getV(new GetVConfig(GraphOpt.GetV.OTHER, new LabelConfig(true)));
    }

    @Override
    public GraphBuilder visitTraversalMethod_with(GremlinGSParser.TraversalMethod_withContext ctx) {
        return this.builder;
    }

    @Override
    public GraphBuilder visitTraversalMethod_as(GremlinGSParser.TraversalMethod_asContext ctx) {
        return this.builder.as((String)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral()));
    }

    @Override
    public GraphBuilder visitTraversalMethod_valueMap(GremlinGSParser.TraversalMethod_valueMapContext ctx) {
        RexNode expr = new ExpressionVisitor(this.builder, (RexNode)this.builder.variable(null)).visitTraversalMethod_valueMap(ctx);
        return this.builder.project((Iterable)ImmutableList.of((Object)expr), (Iterable)ImmutableList.of(), true);
    }

    @Override
    public GraphBuilder visitTraversalMethod_values(GremlinGSParser.TraversalMethod_valuesContext ctx) {
        if (ctx.getChildCount() == 4 && ctx.StringLiteral() != null) {
            RexNode expr = new ExpressionVisitor(this.builder, (RexNode)this.builder.variable(null)).visitTraversalMethod_values(ctx);
            return this.builder.project((Iterable)ImmutableList.of((Object)expr), (Iterable)ImmutableList.of(), true);
        }
        throw new UnsupportedEvalException(((Object)((Object)ctx)).getClass(), "supported pattern is [values('..')]");
    }

    @Override
    public GraphBuilder visitTraversalMethod_elementMap(GremlinGSParser.TraversalMethod_elementMapContext ctx) {
        RexNode expr = new ExpressionVisitor(this.builder, (RexNode)this.builder.variable(null)).visitTraversalMethod_elementMap(ctx);
        return this.builder.project((Iterable)ImmutableList.of((Object)expr), (Iterable)ImmutableList.of(), true);
    }

    @Override
    public GraphBuilder visitTraversalMethod_select(GremlinGSParser.TraversalMethod_selectContext ctx) {
        RexGraphVariable expr;
        LiteralList literalList = new LiteralList(ctx.oC_ListLiteral(), ctx.oC_Expression());
        if (!literalList.isEmpty()) {
            List<String> selectTags = literalList.toList(String.class);
            GremlinGSParser.TraversalMethod_selectby_listContext listCtx = ctx.traversalMethod_selectby_list();
            ImmutableList byCtxs = listCtx == null ? ImmutableList.of() : listCtx.getRuleContexts(GremlinGSParser.TraversalMethod_selectbyContext.class);
            LinkedHashMap keyValueMap = Maps.newLinkedHashMap();
            for (int i = 0; i < selectTags.size(); ++i) {
                String selectTag = selectTags.get(i);
                keyValueMap.put(selectTag, this.convertSelectByCtx((List<GremlinGSParser.TraversalMethod_selectbyContext>)byCtxs, i, selectTag));
            }
            Preconditions.checkArgument((!keyValueMap.isEmpty() ? 1 : 0) != 0, (Object)"keyValue should not be empty in select");
            if (keyValueMap.size() == 1) {
                expr = (RexNode)keyValueMap.entrySet().iterator().next().getValue();
            } else {
                ArrayList mapParameters = Lists.newArrayList();
                keyValueMap.forEach((k, v) -> {
                    mapParameters.add(this.builder.literal(k));
                    mapParameters.add(v);
                });
                expr = this.builder.call(GraphStdOperatorTable.MAP_VALUE_CONSTRUCTOR, mapParameters);
            }
        } else if (ctx.traversalColumn() != null) {
            Column column = TraversalEnumParser.parseTraversalEnumFromContext(Column.class, ctx.traversalColumn());
            expr = this.builder.variable(column.name());
        } else if (ctx.traversalMethod_expr() != null) {
            ExprVisitorResult exprRes = (ExprVisitorResult)new ExtExpressionVisitor(this.builder, this.aliasInfer).visit((ParseTree)ctx.traversalMethod_expr());
            if (!exprRes.getAggCalls().isEmpty()) {
                Preconditions.checkArgument((exprRes.getAggCalls().size() == 1 ? 1 : 0) != 0, (Object)"only one agg call in expr is supported");
                RelBuilder.AggCall aggCall = exprRes.getAggCalls().get(0);
                if (!(exprRes.getExpr() instanceof RexCall)) {
                    return this.builder.aggregate(this.builder.groupKey(), (Iterable)ImmutableList.of((Object)aggCall.as(null)));
                }
                this.builder.aggregate(this.builder.groupKey(), (Iterable)ImmutableList.of((Object)aggCall));
            }
            expr = (RexNode)exprRes.getExpr().accept((RexVisitor)new RexTmpVariableConverter(true, this.builder));
        } else {
            throw new InvalidGremlinScriptException(ctx.getText() + " is invalid, supported pattern is [select('key')] or [select('key1', 'key2', ...)] or [select(Column.keys)] or [select(expr)]");
        }
        return this.builder.project((Iterable)ImmutableList.of((Object)((Object)expr)), (Iterable)ImmutableList.of(), true);
    }

    @Override
    public GraphBuilder visitTraversalMethod_order(GremlinGSParser.TraversalMethod_orderContext ctx) {
        GremlinGSParser.TraversalMethod_orderby_listContext listCtx = ctx.traversalMethod_orderby_list();
        ImmutableList byCtxs = listCtx == null ? ImmutableList.of() : listCtx.getRuleContexts(GremlinGSParser.TraversalMethod_orderbyContext.class);
        ArrayList exprs = Lists.newArrayList();
        if (byCtxs.isEmpty()) {
            exprs.add(this.builder.variable(null));
        } else {
            for (GremlinGSParser.TraversalMethod_orderbyContext byCtx : byCtxs) {
                List<RexNode> byExprs = this.convertOrderByCtx(byCtx);
                Order orderOpt = Order.asc;
                if (byCtx.traversalOrder() != null) {
                    orderOpt = TraversalEnumParser.parseTraversalEnumFromContext(Order.class, byCtx.traversalOrder());
                }
                for (RexNode expr : byExprs) {
                    if (orderOpt == Order.desc) {
                        exprs.add(this.builder.desc(expr));
                        continue;
                    }
                    if (orderOpt != Order.asc) continue;
                    exprs.add(expr);
                }
            }
        }
        return this.builder.sortLimit((RexNode)null, (RexNode)null, (Iterable)exprs);
    }

    @Override
    public GraphBuilder visitTraversalMethod_limit(GremlinGSParser.TraversalMethod_limitContext ctx) {
        Number limit = (Number)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_IntegerLiteral());
        return (GraphBuilder)this.builder.limit(0, limit.intValue());
    }

    @Override
    public GraphBuilder visitTraversalMethod_group(GremlinGSParser.TraversalMethod_groupContext ctx) {
        return this.builder.aggregate(this.convertGroupKeyBy(ctx.traversalMethod_group_keyby()), this.convertGroupValueBy(ctx.traversalMethod_group_valueby()));
    }

    @Override
    public GraphBuilder visitTraversalMethod_groupCount(GremlinGSParser.TraversalMethod_groupCountContext ctx) {
        return (GraphBuilder)this.builder.aggregate(this.convertGroupKeyBy(ctx.traversalMethod_group_keyby()), new RelBuilder.AggCall[]{this.builder.count(false, Column.values.name(), new RexNode[]{this.builder.variable(null)})});
    }

    @Override
    public GraphBuilder visitOC_AggregateFunctionInvocation(GremlinGSParser.OC_AggregateFunctionInvocationContext ctx) {
        String functionName;
        switch (functionName = ctx.getChild(0).getText()) {
            case "count": {
                return (GraphBuilder)this.builder.aggregate(this.builder.groupKey(), new RelBuilder.AggCall[]{this.builder.count(new RexNode[]{this.builder.variable(null)})});
            }
            case "sum": {
                return (GraphBuilder)this.builder.aggregate(this.builder.groupKey(), new RelBuilder.AggCall[]{this.builder.sum(false, null, (RexNode)this.builder.variable(null))});
            }
            case "min": {
                return (GraphBuilder)this.builder.aggregate(this.builder.groupKey(), new RelBuilder.AggCall[]{this.builder.min(null, (RexNode)this.builder.variable(null))});
            }
            case "max": {
                return (GraphBuilder)this.builder.aggregate(this.builder.groupKey(), new RelBuilder.AggCall[]{this.builder.max(null, (RexNode)this.builder.variable(null))});
            }
            case "mean": {
                return (GraphBuilder)this.builder.aggregate(this.builder.groupKey(), new RelBuilder.AggCall[]{this.builder.avg(false, null, (RexNode)this.builder.variable(null))});
            }
            case "fold": {
                return (GraphBuilder)this.builder.aggregate(this.builder.groupKey(), new RelBuilder.AggCall[]{this.builder.collect(false, null, new RexNode[0])});
            }
        }
        throw new UnsupportedEvalException(((Object)((Object)ctx)).getClass(), "supported aggregation functions are count/sum/min/max/mean/fold");
    }

    @Override
    public GraphBuilder visitTraversalMethod_dedup(GremlinGSParser.TraversalMethod_dedupContext ctx) {
        List<String> dedupTags = new LiteralList(ctx.oC_ListLiteral(), ctx.oC_Expression()).toList(String.class);
        if (dedupTags.isEmpty()) {
            dedupTags.add(null);
        }
        List dedupByKeys = dedupTags.stream().map(k -> this.convertDedupByCtx(ctx.traversalMethod_dedupby(), (String)k)).collect(Collectors.toList());
        return this.builder.dedupBy(dedupByKeys);
    }

    @Override
    public GraphBuilder visitTraversalMethod_where(GremlinGSParser.TraversalMethod_whereContext ctx) {
        WherePredicateVisitor.Ring whereByRing = new WherePredicateVisitor.Ring(ctx.traversalMethod_whereby_list());
        if (ctx.StringLiteral() != null && ctx.traversalPredicate() != null) {
            return this.builder.filter(new WherePredicateVisitor(this.builder, (String)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral()), whereByRing).visitTraversalPredicate(ctx.traversalPredicate()));
        }
        if (ctx.traversalPredicate() != null) {
            return this.builder.filter(new WherePredicateVisitor(this.builder, null, whereByRing).visitTraversalPredicate(ctx.traversalPredicate()));
        }
        if (ctx.traversalMethod_expr() != null) {
            ExprVisitorResult exprRes = (ExprVisitorResult)new ExtExpressionVisitor(this.builder, this.aliasInfer).visit((ParseTree)ctx.traversalMethod_expr());
            if (!exprRes.getAggCalls().isEmpty()) {
                throw new IllegalArgumentException("aggregate functions should not exist in filter expression");
            }
            return this.builder.filter(exprRes.getExpr());
        }
        if (ctx.nestedTraversal() != null) {
            GremlinGSParser.TraversalMethodContext methodCtx;
            TraversalMethodIterator methodIterator = new TraversalMethodIterator(ctx.nestedTraversal());
            String alias = null;
            if (methodIterator.hasNext() && (methodCtx = methodIterator.next()).traversalMethod_as() != null) {
                alias = (String)LiteralVisitor.INSTANCE.visit((ParseTree)methodCtx.traversalMethod_as().StringLiteral());
            }
            RexNode subQuery = new NestedTraversalRexVisitor(this.builder, alias, ctx).visitNestedTraversal(ctx.nestedTraversal());
            return this.builder.filter((RexNode)Utils.convertExprToPair(subQuery).getValue0());
        }
        if (ctx.traversalMethod_not() != null) {
            return this.visitTraversalMethod_not(ctx.traversalMethod_not());
        }
        throw new UnsupportedEvalException(((Object)((Object)ctx)).getClass(), ctx.getText() + " is unsupported");
    }

    @Override
    public GraphBuilder visitTraversalMethod_not(GremlinGSParser.TraversalMethod_notContext ctx) {
        RexNode subQuery = new NestedTraversalRexVisitor(this.builder, null, ctx).visitNestedTraversal(ctx.nestedTraversal());
        return this.builder.filter((RexNode)Utils.convertExprToPair(subQuery).getValue0());
    }

    @Override
    public GraphBuilder visitTraversalMethod_is(GremlinGSParser.TraversalMethod_isContext ctx) {
        if (ctx.oC_Literal() != null) {
            return this.builder.filter(this.builder.equals((RexNode)this.builder.variable(null), (RexNode)this.builder.literal(LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal()))));
        }
        if (ctx.traversalPredicate() != null) {
            return this.builder.filter(new ExpressionVisitor(this.builder, (RexNode)this.builder.variable(null)).visitTraversalPredicate(ctx.traversalPredicate()));
        }
        throw new UnsupportedEvalException(((Object)((Object)ctx)).getClass(), ctx.getText() + " is unsupported");
    }

    @Override
    public GraphBuilder visitTraversalMethod_label(GremlinGSParser.TraversalMethod_labelContext ctx) {
        return this.builder.project((Iterable)ImmutableList.of((Object)((Object)this.builder.variable(null, T.label.getAccessor()))), (Iterable)ImmutableList.of(), true);
    }

    @Override
    public GraphBuilder visitTraversalMethod_id(GremlinGSParser.TraversalMethod_idContext ctx) {
        return this.builder.project((Iterable)ImmutableList.of((Object)((Object)this.builder.variable(null, T.id.getAccessor()))), (Iterable)ImmutableList.of(), true);
    }

    @Override
    public GraphBuilder visitTraversalMethod_match(GremlinGSParser.TraversalMethod_matchContext ctx) {
        Preconditions.checkArgument((boolean)(this.builder.peek() instanceof GraphLogicalSource), (Object)"match should start from global source vertices");
        GremlinGSParser.NestedTraversalExprContext exprCtx = ctx.nestedTraversalExpr();
        NestedTraversalRelVisitor visitor = new NestedTraversalRelVisitor(this.builder);
        ArrayList innerSentences = Lists.newArrayList();
        ArrayList antiSentences = Lists.newArrayList();
        for (int i = 0; i < exprCtx.getChildCount(); ++i) {
            if (!(exprCtx.getChild(i) instanceof GremlinGSParser.NestedTraversalContext)) continue;
            GremlinGSParser.NestedTraversalContext nestedCtx = (GremlinGSParser.NestedTraversalContext)exprCtx.getChild(i);
            GremlinGSParser.NestedTraversalContext antiCtx = this.getAntiContext(nestedCtx);
            if (antiCtx != null) {
                antiSentences.add(visitor.visitNestedTraversal(antiCtx));
                continue;
            }
            innerSentences.add(visitor.visitNestedTraversal(nestedCtx));
        }
        Preconditions.checkArgument((innerSentences.size() > 0 ? 1 : 0) != 0, (Object)"match should have at least one inner sentence");
        this.builder.build();
        if (innerSentences.size() == 1) {
            this.builder.match((RelNode)innerSentences.get(0), GraphOpt.Match.INNER);
        } else {
            this.builder.match((RelNode)innerSentences.get(0), innerSentences.subList(1, innerSentences.size()));
        }
        for (RelNode anti : antiSentences) {
            this.builder.match(anti, GraphOpt.Match.ANTI);
        }
        return this.builder;
    }

    private GremlinGSParser.NestedTraversalContext getAntiContext(GremlinGSParser.NestedTraversalContext ctx) {
        GremlinGSParser.TraversalMethodContext methodCtx;
        GremlinGSParser.ChainedTraversalContext chainedCtx = ctx.chainedTraversal();
        if (chainedCtx != null && chainedCtx.getChildCount() == 1 && (methodCtx = chainedCtx.traversalMethod()).traversalMethod_not() != null) {
            return methodCtx.traversalMethod_not().nestedTraversal();
        }
        return null;
    }

    @Override
    public GraphBuilder visitTraversalMethod_union(GremlinGSParser.TraversalMethod_unionContext ctx) {
        GremlinGSParser.NestedTraversalExprContext exprCtx = ctx.nestedTraversalExpr();
        NestedTraversalRelVisitor visitor = new NestedTraversalRelVisitor(this.builder);
        ArrayList branches = Lists.newArrayList();
        for (int i = 0; i < exprCtx.getChildCount(); ++i) {
            if (!(exprCtx.getChild(i) instanceof GremlinGSParser.NestedTraversalContext)) continue;
            GremlinGSParser.NestedTraversalContext nestedCtx = (GremlinGSParser.NestedTraversalContext)exprCtx.getChild(i);
            branches.add(visitor.visitNestedTraversal(nestedCtx));
        }
        Preconditions.checkArgument((branches.size() > 0 ? 1 : 0) != 0, (Object)"union should have at least one branch");
        this.builder.build();
        for (RelNode branch : branches) {
            this.builder.push(branch);
        }
        return (GraphBuilder)this.builder.union(true, branches.size());
    }

    @Override
    public GraphBuilder visitTraversalMethod_identity(GremlinGSParser.TraversalMethod_identityContext ctx) {
        return this.builder;
    }

    public GraphBuilder getGraphBuilder() {
        return this.builder;
    }

    public ExprUniqueAliasInfer getAliasInfer() {
        return this.aliasInfer;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private RelBuilder.GroupKey convertGroupKeyBy(GremlinGSParser.TraversalMethod_group_keybyContext keyCtx) {
        String defaultAlias = Column.keys.name();
        if (keyCtx != null) {
            if (keyCtx.StringLiteral() != null) {
                return this.builder.groupKey((List<RexNode>)ImmutableList.of((Object)((Object)this.builder.variable(null, (String)LiteralVisitor.INSTANCE.visit((ParseTree)keyCtx.StringLiteral())))), (List<String>)ImmutableList.of((Object)defaultAlias));
            }
            if (keyCtx.nonStringKeyByList() != null) {
                ArrayList exprs = Lists.newArrayList();
                @Nullable ArrayList aliases = Lists.newArrayList();
                for (int i = 0; i < keyCtx.nonStringKeyByList().getChildCount(); ++i) {
                    GremlinGSParser.NonStringKeyByContext byCtx = keyCtx.nonStringKeyByList().nonStringKeyBy(i);
                    if (byCtx == null) continue;
                    Pair<RexNode, @Nullable String> exprWithAlias = Utils.convertExprToPair(new NestedTraversalRexVisitor(this.builder, null, keyCtx).visitNestedTraversal(byCtx.nestedTraversal()));
                    exprs.add((RexNode)exprWithAlias.getValue0());
                    String alias = (String)exprWithAlias.getValue1();
                    aliases.add(alias == "_" ? null : alias);
                }
                if (exprs.size() == 1) {
                    if (aliases.isEmpty()) {
                        aliases.add(defaultAlias);
                    } else if (aliases.get(0) == null) {
                        aliases.set(0, defaultAlias);
                    }
                }
                return this.builder.groupKey(exprs, aliases);
            }
        }
        return this.builder.groupKey((List<RexNode>)ImmutableList.of((Object)((Object)this.builder.variable(null))), (List<String>)ImmutableList.of((Object)defaultAlias));
    }

    private List<RelBuilder.AggCall> convertGroupValueBy(GremlinGSParser.TraversalMethod_group_valuebyContext valueCtx) {
        String defaultAlias = Column.values.name();
        if (valueCtx != null) {
            if (valueCtx.StringLiteral() != null) {
                return ImmutableList.of((Object)this.builder.collect(false, defaultAlias, new RexNode[]{this.builder.variable(null, (String)LiteralVisitor.INSTANCE.visit((ParseTree)valueCtx.StringLiteral()))}));
            }
            if (valueCtx.nonStringValueByList() != null) {
                ArrayList aggCalls = Lists.newArrayList();
                for (int i = 0; i < valueCtx.nonStringValueByList().getChildCount(); ++i) {
                    GremlinGSParser.NonStringValueByContext byCtx = valueCtx.nonStringValueByList().nonStringValueBy(i);
                    if (byCtx == null) continue;
                    aggCalls.add(new NonStringValueByVisitor(this.builder).visitNonStringValueBy(byCtx));
                }
                if (aggCalls.size() == 1 && ((GraphAggCall)aggCalls.get(0)).getAlias() == null) {
                    aggCalls.set(0, ((GraphAggCall)aggCalls.get(0)).as(defaultAlias));
                }
                return aggCalls;
            }
        }
        return ImmutableList.of((Object)this.builder.collect(false, defaultAlias, new RexNode[]{this.builder.variable(null)}));
    }

    private RexNode convertDedupByCtx(GremlinGSParser.TraversalMethod_dedupbyContext byCtx, @Nullable String tag) {
        if (byCtx == null) {
            return this.builder.variable(tag);
        }
        if (byCtx.StringLiteral() != null) {
            return this.builder.variable(tag, (String)LiteralVisitor.INSTANCE.visit((ParseTree)byCtx.StringLiteral()));
        }
        if (byCtx.traversalToken() != null) {
            T token = TraversalEnumParser.parseTraversalEnumFromContext(T.class, byCtx.traversalToken());
            return this.builder.variable(tag, token.getAccessor());
        }
        if (byCtx.nestedTraversal() != null) {
            return (RexNode)Utils.convertExprToPair(new NestedTraversalRexVisitor(this.builder, tag, byCtx).visitNestedTraversal(byCtx.nestedTraversal())).getValue0();
        }
        throw new UnsupportedEvalException(((Object)((Object)byCtx)).getClass(), byCtx.getText() + " is unsupported yet");
    }

    private List<RexNode> convertOrderByCtx(GremlinGSParser.TraversalMethod_orderbyContext byCtx) {
        ArrayList exprs = Lists.newArrayList();
        if (byCtx.StringLiteral() != null) {
            exprs.add(this.builder.variable(null, (String)LiteralVisitor.INSTANCE.visit((ParseTree)byCtx.StringLiteral())));
        } else if (byCtx.traversalMethod_values() != null || byCtx.traversalMethod_select() != null) {
            RelNode project = byCtx.traversalMethod_values() != null ? this.visitTraversalMethod_values(byCtx.traversalMethod_values()).build() : this.visitTraversalMethod_select(byCtx.traversalMethod_select()).build();
            Preconditions.checkArgument((boolean)(project instanceof Project), (String)"rel=%s has invalid class type", (Object)project);
            this.builder.push(((Project)project).getInput());
            exprs.addAll(((Project)project).getProjects());
        } else if (byCtx.nestedTraversal() != null) {
            RexNode rex = (RexNode)Utils.convertExprToPair(new NestedTraversalRexVisitor(this.builder, null, byCtx).visitNestedTraversal(byCtx.nestedTraversal())).getValue0();
            exprs.add(rex);
        } else {
            exprs.add(this.builder.variable(null));
        }
        return exprs;
    }

    private RexNode convertSelectByCtx(List<GremlinGSParser.TraversalMethod_selectbyContext> byCtxs, int i, String tag) {
        int ctxCnt = byCtxs.size();
        if (ctxCnt == 0) {
            return this.builder.variable(tag);
        }
        GremlinGSParser.TraversalMethod_selectbyContext byCtx = byCtxs.get(i % ctxCnt);
        return new ExpressionVisitor(this.builder, (RexNode)this.builder.variable(tag)).visitTraversalMethod_selectby(byCtx);
    }

    private boolean pathExpandPattern(GremlinGSParser.OC_ListLiteralContext literalCtx, List<GremlinGSParser.OC_ExpressionContext> exprCtxList) {
        List<String> labels = new LiteralList(literalCtx, exprCtxList).toList(String.class);
        return !labels.isEmpty() && this.rangeExpression(labels.get(0));
    }

    private boolean rangeExpression(String label) {
        return label.matches("^\\d+\\.\\.\\d+");
    }

    private LabelConfig getLabelConfig(GremlinGSParser.OC_ListLiteralContext literalCtx, List<GremlinGSParser.OC_ExpressionContext> exprCtxList) {
        List<String> labels = new LiteralList(literalCtx, exprCtxList).toList(String.class);
        if (labels.isEmpty()) {
            return new LabelConfig(true);
        }
        LabelConfig labelConfig = new LabelConfig(false);
        labels.forEach(labelConfig::addLabel);
        return labelConfig;
    }

    private GraphBuilder appendTailProject() {
        Preconditions.checkArgument((this.builder.size() > 0 ? 1 : 0) != 0, (Object)"builder should not be empty");
        RelNode top = this.builder.peek();
        if (top instanceof Aggregate || top instanceof GraphLogicalProject && !((GraphLogicalProject)top).isAppend()) {
            return this.builder;
        }
        ArrayList exprs = Lists.newArrayList();
        ArrayList aliases = Lists.newArrayList();
        for (RelDataTypeField field : top.getRowType().getFieldList()) {
            exprs.add(this.builder.variable(field.getName()));
            aliases.add(field.getName() == "_" ? null : field.getName());
        }
        return this.builder.project((Iterable)exprs, (Iterable)aliases);
    }
}

