/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.antlr4x.visitor;

import com.alibaba.graphscope.common.antlr4.ExprVisitorResult;
import com.alibaba.graphscope.common.ir.tools.config.ExpandConfig;
import com.alibaba.graphscope.common.ir.tools.config.GetVConfig;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.tools.config.LabelConfig;
import com.alibaba.graphscope.common.ir.tools.config.PathExpandConfig;
import com.alibaba.graphscope.grammar.GremlinGSBaseVisitor;
import com.alibaba.graphscope.grammar.GremlinGSParser;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.ExtExpressionVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.GraphBuilderVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.LiteralList;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.LiteralVisitor;
import com.alibaba.graphscope.gremlin.antlr4x.visitor.TraversalMethodIterator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class PathExpandBuilderVisitor
extends GremlinGSBaseVisitor<PathExpandConfig.Builder> {
    private final PathExpandConfig.Builder builder;
    private final GraphBuilderVisitor parent;

    public PathExpandBuilderVisitor(GraphBuilderVisitor parent) {
        this.builder = PathExpandConfig.newBuilder(parent.getGraphBuilder());
        this.parent = parent;
    }

    @Override
    public PathExpandConfig.Builder visitTraversalMethod_out(GremlinGSParser.TraversalMethod_outContext ctx) {
        List<String> labels = new LiteralList(ctx.oC_ListLiteral(), ctx.oC_Expression()).toList(String.class);
        Preconditions.checkArgument((!labels.isEmpty() ? 1 : 0) != 0, (Object)"hop range can not be empty in path expand");
        String[] ranges = labels.get(0).split("\\.\\.");
        int lower = Integer.valueOf(ranges[0]);
        int upper = Integer.valueOf(ranges[1]);
        List<GremlinGSParser.TraversalMethod_withContext> nextWith = this.getNextWith((GremlinGSParser.TraversalMethodContext)ctx.getParent());
        nextWith.forEach(k -> this.visitTraversalMethod_with((GremlinGSParser.TraversalMethod_withContext)((Object)k)));
        return this.builder.expand(new ExpandConfig(GraphOpt.Expand.OUT, this.getExpandLabelConfig(labels))).getV(new GetVConfig(GraphOpt.GetV.END)).range(lower, upper - lower);
    }

    @Override
    public PathExpandConfig.Builder visitTraversalMethod_in(GremlinGSParser.TraversalMethod_inContext ctx) {
        List<String> labels = new LiteralList(ctx.oC_ListLiteral(), ctx.oC_Expression()).toList(String.class);
        Preconditions.checkArgument((!labels.isEmpty() ? 1 : 0) != 0, (Object)"hop range can not be empty in path expand");
        String[] ranges = labels.get(0).split("\\.\\.");
        int lower = Integer.valueOf(ranges[0]);
        int upper = Integer.valueOf(ranges[1]);
        List<GremlinGSParser.TraversalMethod_withContext> nextWith = this.getNextWith((GremlinGSParser.TraversalMethodContext)ctx.getParent());
        nextWith.forEach(k -> this.visitTraversalMethod_with((GremlinGSParser.TraversalMethod_withContext)((Object)k)));
        return this.builder.expand(new ExpandConfig(GraphOpt.Expand.IN, this.getExpandLabelConfig(labels))).getV(new GetVConfig(GraphOpt.GetV.START)).range(lower, upper - lower);
    }

    @Override
    public PathExpandConfig.Builder visitTraversalMethod_both(GremlinGSParser.TraversalMethod_bothContext ctx) {
        List<String> labels = new LiteralList(ctx.oC_ListLiteral(), ctx.oC_Expression()).toList(String.class);
        Preconditions.checkArgument((!labels.isEmpty() ? 1 : 0) != 0, (Object)"hop range can not be empty in path expand");
        String[] ranges = labels.get(0).split("\\.\\.");
        int lower = Integer.valueOf(ranges[0]);
        int upper = Integer.valueOf(ranges[1]);
        List<GremlinGSParser.TraversalMethod_withContext> nextWith = this.getNextWith((GremlinGSParser.TraversalMethodContext)ctx.getParent());
        nextWith.forEach(k -> this.visitTraversalMethod_with((GremlinGSParser.TraversalMethod_withContext)((Object)k)));
        return this.builder.expand(new ExpandConfig(GraphOpt.Expand.BOTH, this.getExpandLabelConfig(labels))).getV(new GetVConfig(GraphOpt.GetV.OTHER)).range(lower, upper - lower);
    }

    @Override
    public PathExpandConfig.Builder visitTraversalMethod_with(GremlinGSParser.TraversalMethod_withContext ctx) {
        String optKey = (String)LiteralVisitor.INSTANCE.visit((ParseTree)ctx.StringLiteral());
        switch (optKey.toUpperCase()) {
            case "PATH_OPT": {
                Object pathValue = LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal());
                return this.builder.pathOpt(GraphOpt.PathExpandPath.valueOf(String.valueOf(pathValue).toUpperCase()));
            }
            case "RESULT_OPT": {
                Object resultValue = LiteralVisitor.INSTANCE.visit((ParseTree)ctx.oC_Literal());
                return this.builder.resultOpt(GraphOpt.PathExpandResult.valueOf(String.valueOf(resultValue).toUpperCase()));
            }
            case "UNTIL": {
                ExprVisitorResult exprRes = new ExtExpressionVisitor(this.builder, this.parent.getAliasInfer()).visitTraversalMethod_expr(ctx.traversalMethod_expr());
                return this.builder.untilCondition(exprRes.getExpr());
            }
        }
        return this.builder;
    }

    private List<GremlinGSParser.TraversalMethod_withContext> getNextWith(GremlinGSParser.TraversalMethodContext curCtx) {
        GremlinGSParser.TraversalMethodContext next;
        ArrayList nextWith = Lists.newArrayList();
        TraversalMethodIterator methodIterator = new TraversalMethodIterator(curCtx);
        while (methodIterator.hasNext() && (next = methodIterator.next()).traversalMethod_with() != null) {
            nextWith.add(next.traversalMethod_with());
        }
        return nextWith;
    }

    private LabelConfig getExpandLabelConfig(List<String> parameters) {
        if (parameters.size() <= 1) {
            return new LabelConfig(true);
        }
        LabelConfig expandLabels = new LabelConfig(false);
        parameters.subList(1, parameters.size()).forEach(expandLabels::addLabel);
        return expandLabels;
    }
}

