/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.integration.graph;

import java.util.concurrent.CompletableFuture;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.remote.DriverRemoteConnection;
import org.apache.tinkerpop.gremlin.driver.ser.GryoMessageSerializerV1d0;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnectionException;
import org.apache.tinkerpop.gremlin.process.remote.traversal.RemoteTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;

public class RemoteGremlinConnection
implements RemoteConnection {
    private RemoteConnection remoteConnection;
    private Cluster cluster;

    public RemoteGremlinConnection(String endpoint) throws Exception {
        this.cluster = RemoteGremlinConnection.createCluster(endpoint);
        this.remoteConnection = DriverRemoteConnection.using((Cluster)this.cluster);
    }

    public static Cluster createCluster(String endpoint) throws Exception {
        String[] split = endpoint.split(":");
        GryoMessageSerializerV1d0 serializer = new GryoMessageSerializerV1d0();
        Cluster cluster = Cluster.build().addContactPoint(split[0]).port(Integer.valueOf(split[1]).intValue()).serializer((MessageSerializer)serializer).create();
        return cluster;
    }

    public <E> CompletableFuture<RemoteTraversal<?, E>> submitAsync(Bytecode bytecode) throws RemoteConnectionException {
        return this.remoteConnection.submitAsync(bytecode);
    }

    public void close() throws Exception {
        this.remoteConnection.close();
        this.cluster.close();
    }
}

