/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.integration.processor;

import com.alibaba.graphscope.common.client.ExecutionClient;
import com.alibaba.graphscope.common.client.channel.ChannelFetcher;
import com.alibaba.graphscope.common.client.type.ExecutionRequest;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.FrontendConfig;
import com.alibaba.graphscope.common.config.QueryTimeoutConfig;
import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.tools.GraphPlanner;
import com.alibaba.graphscope.common.ir.tools.QueryCache;
import com.alibaba.graphscope.common.ir.tools.QueryIdGenerator;
import com.alibaba.graphscope.common.manager.IrMetaQueryCallback;
import com.alibaba.graphscope.common.utils.ClassUtils;
import com.alibaba.graphscope.gaia.proto.IrResult;
import com.alibaba.graphscope.gremlin.integration.result.GraphProperties;
import com.alibaba.graphscope.gremlin.integration.result.GremlinTestResultProcessor;
import com.alibaba.graphscope.gremlin.integration.resultx.GremlinTestRecordParser;
import com.alibaba.graphscope.gremlin.plugin.MetricsCollector;
import com.alibaba.graphscope.gremlin.plugin.QueryStatusCallback;
import com.alibaba.graphscope.gremlin.plugin.processor.IrStandardOpProcessor;
import com.alibaba.graphscope.gremlin.plugin.script.AntlrGremlinScriptEngine;
import com.alibaba.graphscope.gremlin.resultx.ResultSchema;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.translator.GroovyTranslator;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.op.traversal.TraversalOpProcessor;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrTestOpProcessor
extends IrStandardOpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TraversalOpProcessor.class);
    private AntlrGremlinScriptEngine scriptEngine;
    private ScriptContext context = new SimpleScriptContext();
    private GraphProperties testGraph;

    public IrTestOpProcessor(Configs configs, QueryIdGenerator idGenerator, QueryCache queryCache, GraphPlanner graphPlanner, ExecutionClient executionClient, ChannelFetcher fetcher, IrMetaQueryCallback metaQueryCallback, Graph graph, GraphTraversalSource g, GraphProperties testGraph) {
        super(configs, idGenerator, queryCache, graphPlanner, executionClient, fetcher, metaQueryCallback, graph, g);
        SimpleBindings globalBindings = new SimpleBindings();
        globalBindings.put("g", (Object)g);
        this.context.setBindings(globalBindings, 100);
        this.scriptEngine = new AntlrGremlinScriptEngine();
        this.testGraph = testGraph;
    }

    public String getName() {
        return "traversal";
    }

    public ThrowingConsumer<Context> select(Context ctx) {
        RequestMessage message = ctx.getRequestMessage();
        logger.debug("tokens ops is {}", (Object)message.getOp());
        switch (message.getOp()) {
            case "bytecode": {
                ThrowingConsumer op = context -> {
                    Bytecode byteCode = (Bytecode)message.getArgs().get("gremlin");
                    String language = FrontendConfig.GREMLIN_SCRIPT_LANGUAGE_NAME.get(this.configs);
                    boolean removeQuoteInExpr = language.equals("antlr_gremlin_calcite");
                    String script = this.getScript(byteCode, removeQuoteInExpr);
                    BigInteger queryId = this.idGenerator.generateId();
                    String queryName = this.idGenerator.generateName(queryId);
                    IrMeta irMeta = this.metaQueryCallback.beforeExec();
                    QueryStatusCallback statusCallback = ClassUtils.createQueryStatusCallback(queryId, null, script, new MetricsCollector.Gremlin(evalOpTimer), this.queryHistogram, this.configs);
                    QueryTimeoutConfig timeoutConfig = new QueryTimeoutConfig(FrontendConfig.QUERY_EXECUTION_TIMEOUT_MS.get(this.configs).intValue());
                    switch (language) {
                        case "antlr_gremlin_traversal": {
                            Traversal traversal = (Traversal)this.scriptEngine.eval(script, this.context);
                            IrTestOpProcessor.applyStrategies(traversal);
                            this.processTraversal(traversal, new GremlinTestResultProcessor(this.configs, ctx, traversal, statusCallback, this.testGraph, timeoutConfig), irMeta, new QueryTimeoutConfig(ctx.getRequestTimeout()), statusCallback.getQueryLogger());
                            break;
                        }
                        case "antlr_gremlin_calcite": {
                            QueryCache.Value value = this.queryCache.get(this.queryCache.createKey(this.graphPlanner.instance(script, irMeta)));
                            GraphPlanner.Summary summary = value.summary;
                            ResultSchema resultSchema = new ResultSchema(summary.getLogicalPlan());
                            com.alibaba.graphscope.gremlin.integration.resultx.GremlinTestResultProcessor listener = new com.alibaba.graphscope.gremlin.integration.resultx.GremlinTestResultProcessor(this.configs, ctx, new GremlinTestRecordParser(resultSchema, this.testGraph.getProperties(this.configs)), resultSchema, statusCallback, timeoutConfig);
                            if (value.result != null && value.result.isCompleted) {
                                List<IrResult.Results> records = value.result.records;
                                records.forEach(k -> listener.onNext(k.getRecord()));
                                listener.onCompleted();
                            } else {
                                this.executionClient.submit(new ExecutionRequest(queryId, queryName, summary.getLogicalPlan(), summary.getPhysicalPlan()), listener, timeoutConfig);
                            }
                            listener.request();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid script language name: " + language);
                        }
                    }
                    this.metaQueryCallback.afterExec(irMeta);
                };
                return op;
            }
        }
        RequestMessage msg = ctx.getRequestMessage();
        String errorMsg = message.getOp() + " is unsupported";
        ctx.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_EVALUATION).statusMessage(errorMsg).create());
        return null;
    }

    private String getScript(Bytecode byteCode, boolean removeQuoteInExpr) {
        Object script = GroovyTranslator.of((String)"g").translate(byteCode).getScript();
        List<String> typeCastStrs = Arrays.asList("\\(int\\)", "\\(long\\)", "\\(double\\)", "\\(boolean\\)");
        for (String type : typeCastStrs) {
            script = ((String)script).replaceAll(type, "");
        }
        if (removeQuoteInExpr) {
            int i;
            String exprPattern = "expr(";
            int exprIdx = ((String)script).indexOf(exprPattern);
            if (exprIdx < 0) {
                return script;
            }
            for (i = exprIdx + exprPattern.length(); i < ((String)script).length() && !this.isQuote(((String)script).charAt(i)); ++i) {
            }
            if (i == ((String)script).length()) {
                return script;
            }
            int leftQuoteIdx = i;
            int leftBraceCnt = 1;
            while (i < ((String)script).length() && leftBraceCnt != 0) {
                if (((String)script).charAt(i) == '(') {
                    ++leftBraceCnt;
                } else if (((String)script).charAt(i) == ')') {
                    --leftBraceCnt;
                }
                ++i;
            }
            if (i == ((String)script).length()) {
                return script;
            }
            while (i > leftQuoteIdx && !this.isQuote(((String)script).charAt(i))) {
                --i;
            }
            if (i == leftQuoteIdx) {
                return script;
            }
            int rightQuoteIdx = i;
            script = ((String)script).substring(0, leftQuoteIdx) + ((String)script).substring(leftQuoteIdx + 1, rightQuoteIdx) + ((String)script).substring(rightQuoteIdx + 1);
        }
        return script;
    }

    private boolean isQuote(char ch) {
        return ch == '\'' || ch == '\"';
    }
}

