/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.integration.resultx;

import com.alibaba.graphscope.gaia.proto.IrResult;
import com.alibaba.graphscope.gremlin.resultx.GremlinRecordParser;
import com.alibaba.graphscope.gremlin.resultx.ResultSchema;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;

public class GremlinTestRecordParser
extends GremlinRecordParser {
    private static final String VERTEX_PROPERTIES = "vertex_properties";
    private static final String EDGE_PROPERTIES = "edge_properties";
    private final Map<String, Object> cachedProperties;

    public GremlinTestRecordParser(ResultSchema resultSchema, Map<String, Object> cachedProperties) {
        super(resultSchema);
        this.cachedProperties = cachedProperties;
    }

    @Override
    protected Map<String, Object> parseVertexProperties(IrResult.Vertex vertex, RelDataType type) {
        String idAsStr;
        Map vertexProperties = (Map)this.cachedProperties.get(VERTEX_PROPERTIES);
        Map properties = (Map)vertexProperties.get(idAsStr = String.valueOf(vertex.getId()));
        if (properties != null) {
            HashMap<String, Object> formatProperties = new HashMap<String, Object>();
            properties.forEach((k, v) -> formatProperties.put((String)k, Collections.singletonList(ImmutableMap.of((Object)"id", (Object)1L, (Object)"value", (Object)v))));
            return formatProperties;
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<String, Object> parseEdgeProperties(IrResult.Edge edge, RelDataType type) {
        String idAsStr;
        Map edgeProperties = (Map)this.cachedProperties.get(EDGE_PROPERTIES);
        Map properties = (Map)edgeProperties.get(idAsStr = String.valueOf(edge.getId()));
        return properties == null ? Collections.emptyMap() : properties;
    }
}

