/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.integration.resultx;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.QueryTimeoutConfig;
import com.alibaba.graphscope.common.result.RecordParser;
import com.alibaba.graphscope.gaia.proto.IrResult;
import com.alibaba.graphscope.gremlin.plugin.QueryStatusCallback;
import com.alibaba.graphscope.gremlin.resultx.GremlinResultProcessor;
import com.alibaba.graphscope.gremlin.resultx.ResultSchema;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.server.Context;

public class GremlinTestResultProcessor
extends GremlinResultProcessor {
    public GremlinTestResultProcessor(Configs configs, Context ctx, RecordParser recordParser, ResultSchema resultSchema, QueryStatusCallback statusCallback, QueryTimeoutConfig timeoutConfig) {
        super(configs, ctx, recordParser, resultSchema, statusCallback, timeoutConfig);
    }

    @Override
    protected void processRecord(IrResult.Record record) {
        List results = this.recordParser.parseFrom(record);
        if (this.resultSchema.isGroupBy && !results.isEmpty()) {
            if (results.stream().anyMatch(k -> !(k instanceof Map))) {
                throw new IllegalArgumentException("cannot reduce results " + results + " into a single map");
            }
            for (Object result : results) {
                this.reducer.putAll((Map)result);
            }
        } else if (!this.resultSchema.isGroupBy) {
            this.ctx.writeAndFlush(ResponseMessage.build((RequestMessage)this.ctx.getRequestMessage()).code(ResponseStatusCode.PARTIAL_CONTENT).result(results.stream().map(k -> new DefaultRemoteTraverser(k, 1L)).collect(Collectors.toList())).create());
        }
    }

    @Override
    protected void finishRecord() {
        ArrayList results = Lists.newArrayList();
        if (this.resultSchema.isGroupBy) {
            results.add(new DefaultRemoteTraverser((Object)this.reducer, 1L));
        }
        this.ctx.writeAndFlush(ResponseMessage.build((RequestMessage)this.ctx.getRequestMessage()).code(ResponseStatusCode.SUCCESS).result((Object)results).create());
    }
}

