/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.plugin;

import com.alibaba.graphscope.groot.common.constant.LogConstant;
import com.alibaba.graphscope.groot.common.util.Utils;
import com.google.gson.JsonObject;
import io.opentelemetry.api.trace.Span;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryLogger {
    private static final Logger defaultLogger = LoggerFactory.getLogger(QueryLogger.class);
    private static Logger metricLogger = LoggerFactory.getLogger((String)"MetricLog");
    private final String query;
    private final BigInteger queryId;
    private final String upstreamId;
    private String irPlan;

    public QueryLogger(String query, BigInteger queryId) {
        this.query = query;
        this.queryId = queryId;
        this.irPlan = null;
        this.upstreamId = null;
    }

    public QueryLogger(String query, BigInteger queryId, String upstreamId) {
        this.query = query;
        this.queryId = queryId;
        this.upstreamId = upstreamId;
        this.irPlan = null;
    }

    public void debug(String format, Object ... args) {
        defaultLogger.debug(this + " : " + format, args);
    }

    public void info(String format, Object ... args) {
        defaultLogger.info(this + " : " + format, args);
    }

    public void warn(String format, Object ... args) {
        defaultLogger.warn(this + " : " + format, args);
    }

    public void error(String format, Object ... args) {
        defaultLogger.error(this + " : " + format, args);
    }

    public void error(Throwable throwable) {
        JsonObject errorJson = new JsonObject();
        String traceId = Span.current().getSpanContext().getTraceId();
        if (this.upstreamId != null) {
            errorJson.addProperty(LogConstant.UPSTREAM_ID, this.upstreamId);
        }
        errorJson.addProperty(LogConstant.TRACE_ID, traceId);
        errorJson.addProperty(LogConstant.SUCCESS, Boolean.valueOf(false));
        errorJson.addProperty(LogConstant.STAGE, "java");
        errorJson.addProperty(LogConstant.LOG_TYPE, "query");
        errorJson.addProperty(LogConstant.ERROR_MESSAGE, throwable.getMessage());
        defaultLogger.error(errorJson.toString(), throwable);
    }

    public void print(String message, boolean success, Throwable t) {
        if (success) {
            defaultLogger.info(message);
        } else {
            defaultLogger.error(message, t);
        }
    }

    public void metricsInfo(String format, Object ... args) {
        metricLogger.info(this.queryId + " | " + this.query + " | " + format, args);
    }

    public void metricsInfo(boolean isSucceed, long cost) {
        String traceId = Span.current().getSpanContext().getTraceId();
        String metricJson = Utils.buildMetricJsonLog((boolean)isSucceed, (String)traceId, null, null, (long)cost, (Long)System.currentTimeMillis(), (String)"java", (String)"query");
        metricLogger.info(metricJson);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        if (this.upstreamId != null) {
            str.append("upstreamId=").append(this.upstreamId).append(", ");
        }
        str.append("query='").append(this.query).append("'").append(", queryId=").append(this.queryId).append("]");
        return str.toString();
    }

    public String getQuery() {
        return this.query;
    }

    public BigInteger getQueryId() {
        return this.queryId;
    }

    public void setIrPlan(String irPlan) {
        this.irPlan = irPlan;
    }

    public String getUpstreamId() {
        return this.upstreamId;
    }

    public String getIrPlan() {
        return this.irPlan;
    }
}

