/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.plugin.step;

import com.alibaba.graphscope.gremlin.exception.ExtendGremlinStepException;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.CoinStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class ScanFusionStep<S, E extends Element>
extends GraphStep<S, E>
implements HasContainerHolder,
AutoCloseable {
    private final List<HasContainer> hasContainers = new ArrayList<HasContainer>();
    private final List<String> graphLabels = new ArrayList<String>();
    private CoinStep coinStep = null;

    public ScanFusionStep(GraphStep<S, E> originalGraphStep) {
        super(originalGraphStep.getTraversal(), originalGraphStep.getReturnClass(), originalGraphStep.isStartStep(), originalGraphStep.getIds());
        originalGraphStep.getLabels().forEach(arg_0 -> ((ScanFusionStep)this).addLabel(arg_0));
    }

    public String toString() {
        return StringFactory.stepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName().toLowerCase(), Arrays.toString(this.ids), this.graphLabels, this.hasContainers});
    }

    public List<HasContainer> getHasContainers() {
        return Collections.unmodifiableList(this.hasContainers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScanFusionStep that = (ScanFusionStep)o;
        return Objects.equal(this.hasContainers, that.hasContainers) && Objects.equal(this.graphLabels, that.graphLabels);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.hasContainers, this.graphLabels});
    }

    public void addHasContainer(HasContainer hasContainer) {
        if (hasContainer.getPredicate() instanceof AndP) {
            for (P predicate : ((AndP)hasContainer.getPredicate()).getPredicates()) {
                this.addHasContainer(new HasContainer(hasContainer.getKey(), predicate));
            }
        } else {
            this.hasContainers.add(hasContainer);
        }
    }

    public List<String> getGraphLabels() {
        return Collections.unmodifiableList(this.graphLabels);
    }

    public void addGraphLabels(String label) {
        this.graphLabels.add(label);
    }

    public static boolean processHasLabels(ScanFusionStep<?, ?> graphStep, HasContainer hasContainer, List<HasContainer> originalContainers) {
        if (!hasContainer.getKey().equals(T.label.getAccessor()) || graphStep.getIds().length != 0 || graphStep.getGraphLabels().size() != 0 || hasContainer.getBiPredicate() != Compare.eq && hasContainer.getBiPredicate() != Contains.within) {
            return false;
        }
        if (ScanFusionStep.getContainer(originalContainers, T.id.getAccessor()) != null) {
            return false;
        }
        P predicate = hasContainer.getPredicate();
        if (predicate.getValue() instanceof List && ((List)predicate.getValue()).size() > 0 && ((List)predicate.getValue()).get(0) instanceof String) {
            List values = (List)predicate.getValue();
            values.forEach(k -> graphStep.addGraphLabels((String)k));
        } else if (predicate.getValue() instanceof String) {
            graphStep.addGraphLabels((String)predicate.getValue());
        } else {
            throw new ExtendGremlinStepException("hasLabel value type not support " + predicate.getValue().getClass());
        }
        return true;
    }

    public static HasContainer getContainer(List<HasContainer> originalContainers, String key) {
        for (HasContainer container : originalContainers) {
            if (!container.getKey().equals(key)) continue;
            return container;
        }
        return null;
    }

    public CoinStep getCoinStep() {
        return this.coinStep;
    }

    public void setCoinStep(CoinStep coinStep) {
        this.coinStep = coinStep;
    }
}

