/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.plugin.strategy;

import com.alibaba.graphscope.common.jna.type.FfiExpandOpt;
import com.alibaba.graphscope.gremlin.plugin.step.ExpandFusionStep;
import com.alibaba.graphscope.gremlin.plugin.step.GroupCountStep;
import com.alibaba.graphscope.gremlin.plugin.step.GroupStep;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NotStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WherePredicateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.InlineFilterStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class ExpandFusionStepStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final Set<Class<? extends TraversalStrategy.OptimizationStrategy>> PRIORS = new HashSet<Class>(Arrays.asList(InlineFilterStrategy.class));
    private static final ExpandFusionStepStrategy INSTANCE = new ExpandFusionStepStrategy();

    public static ExpandFusionStepStrategy instance() {
        return INSTANCE;
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        for (VertexStep originalVertexStep : TraversalHelper.getStepsOfClass(VertexStep.class, traversal)) {
            ExpandFusionStep expandFusionStep = new ExpandFusionStep(originalVertexStep);
            TraversalHelper.replaceStep((Step)originalVertexStep, expandFusionStep, traversal);
            if (expandFusionStep.getExpandOpt() != FfiExpandOpt.Edge) continue;
            Step currentStep = expandFusionStep.getNextStep();
            while (currentStep instanceof HasStep) {
                List originalContainers = ((HasContainerHolder)currentStep).getHasContainers();
                for (HasContainer hasContainer : originalContainers) {
                    expandFusionStep.addHasContainer(hasContainer);
                }
                TraversalHelper.copyLabels((Step)currentStep, (Step)currentStep.getPreviousStep(), (boolean)false);
                traversal.removeStep(currentStep);
                currentStep = currentStep.getNextStep();
            }
            currentStep = expandFusionStep.getNextStep();
            if (!expandFusionStep.getLabels().isEmpty() || !(currentStep instanceof EdgeVertexStep) && !(currentStep instanceof EdgeOtherVertexStep) || !this.canFuseExpandWithGetV(expandFusionStep, currentStep)) continue;
            expandFusionStep.setExpandOpt(FfiExpandOpt.Vertex);
            TraversalHelper.copyLabels((Step)currentStep, (Step)currentStep.getPreviousStep(), (boolean)false);
            traversal.removeStep(currentStep);
        }
        if (this.isApply(traversal) && traversal.getSteps().size() == 2 && traversal.getStartStep() instanceof ExpandFusionStep && traversal.getEndStep() instanceof CountGlobalStep) {
            ExpandFusionStep expandStep = (ExpandFusionStep)traversal.getStartStep();
            CountGlobalStep countStep = (CountGlobalStep)traversal.getEndStep();
            expandStep.setExpandOpt(FfiExpandOpt.Degree);
            TraversalHelper.copyLabels((Step)countStep, (Step)countStep.getPreviousStep(), (boolean)false);
            traversal.removeStep((Step)countStep);
        }
    }

    private boolean isApply(Traversal.Admin admin) {
        Step parent = admin.getParent().asStep();
        return parent instanceof SelectOneStep || parent instanceof SelectStep || parent instanceof DedupGlobalStep || parent instanceof OrderGlobalStep || parent instanceof GroupStep || parent instanceof GroupCountStep || parent instanceof WhereTraversalStep || parent instanceof TraversalFilterStep || parent instanceof WherePredicateStep || parent instanceof NotStep;
    }

    private boolean canFuseExpandWithGetV(ExpandFusionStep expandFusionStep, Step getVStep) {
        return expandFusionStep.getDirection() == Direction.OUT && getVStep instanceof EdgeVertexStep && ((EdgeVertexStep)getVStep).getDirection() == Direction.IN || expandFusionStep.getDirection() == Direction.IN && getVStep instanceof EdgeVertexStep && ((EdgeVertexStep)getVStep).getDirection() == Direction.OUT || expandFusionStep.getDirection() == Direction.BOTH && getVStep instanceof EdgeOtherVertexStep;
    }
}

