/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.result;

import com.alibaba.graphscope.common.jna.IrCoreLibrary;
import com.alibaba.graphscope.common.jna.type.FfiKeyType;
import com.alibaba.graphscope.common.jna.type.FfiResult;
import com.alibaba.graphscope.common.jna.type.ResultCode;
import com.alibaba.graphscope.gaia.proto.Common;
import com.alibaba.graphscope.gaia.proto.IrResult;
import com.alibaba.graphscope.gremlin.exception.GremlinResultParserException;
import com.alibaba.graphscope.gremlin.result.EmptyValue;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserUtils {
    private static final Logger logger = LoggerFactory.getLogger(ParserUtils.class);
    private static final IrCoreLibrary irCoreLib = IrCoreLibrary.INSTANCE;

    public static Object parseElement(IrResult.Element element) {
        switch (element.getInnerCase()) {
            case VERTEX: {
                return ParserUtils.parseVertex(element.getVertex());
            }
            case EDGE: {
                return ParserUtils.parseEdge(element.getEdge());
            }
            case GRAPH_PATH: {
                IrResult.GraphPath graphPath = element.getGraphPath();
                return graphPath.getPathList().stream().map(k -> {
                    if (k.getInnerCase() == IrResult.GraphPath.VertexOrEdge.InnerCase.VERTEX) {
                        return ParserUtils.parseVertex(k.getVertex());
                    }
                    if (k.getInnerCase() == IrResult.GraphPath.VertexOrEdge.InnerCase.EDGE) {
                        return ParserUtils.parseEdge(k.getEdge());
                    }
                    throw new GremlinResultParserException(k.getInnerCase() + " is invalid");
                }).collect(Collectors.toList());
            }
            case OBJECT: {
                return ParserUtils.parseCommonValue(element.getObject());
            }
        }
        throw new GremlinResultParserException(element.getInnerCase() + " is invalid");
    }

    public static List<Object> parseCollection(IrResult.Collection collection) {
        return collection.getCollectionList().stream().map(k -> ParserUtils.parseElement(k)).collect(Collectors.toList());
    }

    public static IrResult.Entry getHeadEntry(IrResult.Results results) {
        return results.getRecord().getColumns(0).getEntry();
    }

    private static Object parseCommonValue(Common.Value value) {
        switch (value.getItemCase()) {
            case BOOLEAN: {
                return value.getBoolean();
            }
            case I32: {
                return value.getI32();
            }
            case I64: {
                return value.getI64();
            }
            case F64: {
                return value.getF64();
            }
            case STR: {
                return value.getStr();
            }
            case DATE: {
                Preconditions.checkArgument((value.getDate().getItem() >= 0 ? 1 : 0) != 0, (String)"Date prior to 1970-00-00 is not supported, got %d", (int)value.getDate().getItem());
                return new Date((long)value.getDate().getItem() * 24L * 60L * 60L * 1000L);
            }
            case TIME: {
                Preconditions.checkArgument((value.getTime().getItem() >= 0 ? 1 : 0) != 0, (String)"Time of day must be greater than 00:00:00, got %d", (int)value.getTime().getItem());
                OffsetTime time = LocalTime.ofNanoOfDay((long)value.getTime().getItem() * 1000000L).atOffset(ZoneOffset.UTC);
                return time.toString();
            }
            case TIMESTAMP: {
                Preconditions.checkArgument((value.getTimestamp().getItem() >= 0L ? 1 : 0) != 0, (String)"Timestamp prior to 1970-00-00 00:00:00 is not supported, got %d", (long)value.getTimestamp().getItem());
                OffsetDateTime ts = Instant.ofEpochSecond(value.getTimestamp().getItem() / 1000L, value.getTimestamp().getItem() % 1000L * 1000000L).atOffset(ZoneOffset.UTC);
                return ts.toString();
            }
            case PAIR_ARRAY: {
                Common.PairArray pairs = value.getPairArray();
                HashMap pairInMap = new HashMap();
                pairs.getItemList().forEach(pair -> pairInMap.put(ParserUtils.parseCommonValue(pair.getKey()), ParserUtils.parseCommonValue(pair.getVal())));
                return pairInMap;
            }
            case STR_ARRAY: {
                return value.getStrArray().getItemList();
            }
            case NONE: {
                return EmptyValue.INSTANCE;
            }
        }
        throw new GremlinResultParserException(value.getItemCase() + " is unsupported yet");
    }

    private static Vertex parseVertex(IrResult.Vertex vertex) {
        Map<String, Object> properties = ParserUtils.parseProperties(vertex.getPropertiesList());
        return new DetachedVertex((Object)vertex.getId(), ParserUtils.getKeyName(vertex.getLabel(), FfiKeyType.Entity), properties);
    }

    private static Edge parseEdge(IrResult.Edge edge) {
        Map<String, Object> edgeProperties = ParserUtils.parseProperties(edge.getPropertiesList());
        return new DetachedEdge((Object)edge.getId(), ParserUtils.getKeyName(edge.getLabel(), FfiKeyType.Relation), edgeProperties, (Object)edge.getSrcId(), ParserUtils.getKeyName(edge.getSrcLabel(), FfiKeyType.Entity), (Object)edge.getDstId(), ParserUtils.getKeyName(edge.getDstLabel(), FfiKeyType.Entity));
    }

    private static Map<String, Object> parseProperties(List<IrResult.Property> properties) {
        return new HashMap<String, Object>();
    }

    public static String getKeyName(Common.NameOrId key, FfiKeyType type) {
        switch (key.getItemCase()) {
            case NAME: {
                return key.getName();
            }
            case ID: {
                FfiResult.ByValue result = irCoreLib.getKeyName(key.getId(), type);
                if (result.code != ResultCode.Success) {
                    String errorMsg = "code is " + result.code.name() + ", msg is " + result.getMsg();
                    throw new GremlinResultParserException("getKeyName fail " + errorMsg);
                }
                return result.getMsg();
            }
        }
        logger.error("{}", (Object)"key type is not set");
        return "";
    }

    public static Object parseEntry(IrResult.Entry entry) {
        switch (entry.getInnerCase()) {
            case ELEMENT: {
                return ParserUtils.parseElement(entry.getElement());
            }
            case COLLECTION: {
                List<Object> elements = ParserUtils.parseCollection(entry.getCollection());
                List notNull = elements.stream().filter(k -> !(k instanceof EmptyValue)).collect(Collectors.toList());
                return notNull.isEmpty() ? EmptyValue.INSTANCE : notNull;
            }
            case MAP: {
                LinkedHashMap valueMap = new LinkedHashMap();
                entry.getMap().getKeyValuesList().forEach(k -> valueMap.put(ParserUtils.parseCommonValue(k.getKey()), ParserUtils.parseElement(k)));
                return valueMap;
            }
        }
        throw new GremlinResultParserException("invalid " + entry.getInnerCase().name());
    }

    public static Object parseElement(IrResult.KeyValues.KeyValue value) {
        return ParserUtils.parseEntry(value.getValue());
    }
}

