/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.resultx;

import com.alibaba.graphscope.common.ir.type.ArbitraryArrayType;
import com.alibaba.graphscope.common.ir.type.ArbitraryMapType;
import com.alibaba.graphscope.common.ir.type.GraphLabelType;
import com.alibaba.graphscope.common.ir.type.GraphPathType;
import com.alibaba.graphscope.common.result.RecordParser;
import com.alibaba.graphscope.common.result.Utils;
import com.alibaba.graphscope.gaia.proto.Common;
import com.alibaba.graphscope.gaia.proto.IrResult;
import com.alibaba.graphscope.gremlin.exception.GremlinResultParserException;
import com.alibaba.graphscope.gremlin.resultx.ResultSchema;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GremlinRecordParser
implements RecordParser<Object> {
    protected final ResultSchema resultSchema;

    public GremlinRecordParser(ResultSchema resultSchema) {
        this.resultSchema = resultSchema;
    }

    @Override
    public List<Object> parseFrom(IrResult.Record record) {
        RelDataType outputType = this.resultSchema.outputType;
        Preconditions.checkArgument((record.getColumnsCount() == outputType.getFieldCount() ? 1 : 0) != 0, (Object)("column size of results " + record.getColumnsCount() + " should be consistent with output type " + outputType.getFieldCount()));
        LinkedHashMap mapValue = Maps.newLinkedHashMap();
        if (this.resultSchema.isGroupBy) {
            Preconditions.checkArgument((this.resultSchema.groupKeyCount <= outputType.getFieldCount() ? 1 : 0) != 0, (Object)("invalid group key count " + this.resultSchema.groupKeyCount));
            ArrayList groupKeys = Lists.newArrayList();
            for (int i = 0; i < this.resultSchema.groupKeyCount; ++i) {
                IrResult.Column column = record.getColumns(i);
                RelDataTypeField field = (RelDataTypeField)outputType.getFieldList().get(i);
                groupKeys.add(this.parseEntry(column.getEntry(), field.getType()));
            }
            ArrayList groupValues = Lists.newArrayList();
            for (int i = this.resultSchema.groupKeyCount; i < record.getColumnsCount(); ++i) {
                IrResult.Column column = record.getColumns(i);
                RelDataTypeField field = (RelDataTypeField)outputType.getFieldList().get(i);
                Object value = this.parseEntry(column.getEntry(), field.getType());
                if (value == null) continue;
                groupValues.add(value);
            }
            if (!groupValues.isEmpty() && !groupKeys.isEmpty()) {
                mapValue.put(groupKeys.size() == 1 ? groupKeys.get(0) : groupKeys, groupValues.size() == 1 ? groupValues.get(0) : groupValues);
            }
        } else {
            for (int i = 0; i < record.getColumnsCount(); ++i) {
                IrResult.Column column = record.getColumns(i);
                RelDataTypeField field = (RelDataTypeField)outputType.getFieldList().get(i);
                mapValue.put(field.getName(), this.parseEntry(column.getEntry(), field.getType()));
            }
        }
        return Lists.newArrayList((Object[])new Object[]{!this.resultSchema.isGroupBy && mapValue.size() == 1 ? mapValue.values().iterator().next() : mapValue});
    }

    @Override
    public RelDataType schema() {
        return this.resultSchema.outputType;
    }

    private Object parseEntry(IrResult.Entry entry, RelDataType type) {
        if (type instanceof GraphPathType) {
            return this.parseElement(entry.getElement(), type);
        }
        switch (type.getSqlTypeName()) {
            case MULTISET: 
            case ARRAY: {
                if (type instanceof ArbitraryArrayType) {
                    return this.parseCollection(entry.getCollection(), ((ArbitraryArrayType)type).getComponentTypes());
                }
                return this.parseCollection(entry.getCollection(), type.getComponentType());
            }
            case MAP: {
                if (type instanceof ArbitraryMapType) {
                    return this.parseKeyValues(entry.getMap(), ((ArbitraryMapType)type).getKeyValueTypeMap());
                }
                return this.parseKeyValues(entry.getMap(), type.getKeyType(), type.getValueType());
            }
        }
        return this.parseElement(entry.getElement(), type);
    }

    private List<Object> parseCollection(IrResult.Collection collection, RelDataType componentType) {
        return collection.getCollectionList().stream().map(k -> this.parseElement((IrResult.Element)k, componentType)).collect(Collectors.toList());
    }

    private List<Object> parseCollection(IrResult.Collection collection, List<RelDataType> componentTypes) {
        List<IrResult.Element> elements = collection.getCollectionList();
        Preconditions.checkArgument((elements.size() == componentTypes.size() ? 1 : 0) != 0, (Object)("Collection element size=" + elements.size() + " is not consistent with type size=" + componentTypes.size()));
        ArrayList values = Lists.newArrayList();
        for (int i = 0; i < elements.size(); ++i) {
            values.add(this.parseElement(elements.get(i), componentTypes.get(i)));
        }
        return values;
    }

    private Map<Object, Object> parseKeyValues(IrResult.KeyValues keyValues, RelDataType keyType, RelDataType valueType) {
        LinkedHashMap valueMap = Maps.newLinkedHashMap();
        keyValues.getKeyValuesList().forEach(entry -> {
            Object value = this.parseEntry(entry.getValue(), valueType);
            if (value != null) {
                valueMap.put(this.parseMapKey(entry.getKey().getStr()), value);
            }
        });
        return valueMap;
    }

    private Map<Object, Object> parseKeyValues(IrResult.KeyValues keyValues, Map<RexNode, ArbitraryMapType.KeyValueType> keyValueTypeMap) {
        LinkedHashMap valueMap = Maps.newLinkedHashMap();
        for (IrResult.KeyValues.KeyValue entry : keyValues.getKeyValuesList()) {
            ArbitraryMapType.KeyValueType keyValueType = Utils.getKeyValueType(entry.getKey(), keyValueTypeMap);
            Object value = this.parseEntry(entry.getValue(), keyValueType == null ? null : (RelDataType)keyValueType.getValue());
            if (value == null) continue;
            valueMap.put(this.parseMapKey(entry.getKey().getStr()), value);
        }
        return valueMap;
    }

    private Object parseMapKey(String mapKey) {
        if (mapKey.equals(T.id.getAccessor())) {
            return T.id;
        }
        if (mapKey.equals(T.label.getAccessor())) {
            return T.label;
        }
        if (mapKey.equals(T.key.getAccessor())) {
            return T.key;
        }
        if (mapKey.equals(T.value.getAccessor())) {
            return T.value;
        }
        return mapKey;
    }

    private Object parseElement(IrResult.Element element, RelDataType type) {
        switch (element.getInnerCase()) {
            case VERTEX: {
                return this.parseVertex(element.getVertex(), type);
            }
            case EDGE: {
                return this.parseEdge(element.getEdge(), type);
            }
            case GRAPH_PATH: {
                return this.parseGraphPath(element.getGraphPath(), type);
            }
        }
        return this.parseValue(element.getObject(), type);
    }

    private Vertex parseVertex(IrResult.Vertex vertex, RelDataType type) {
        return new DetachedVertex((Object)vertex.getId(), Utils.getLabelName(vertex.getLabel(), Utils.getLabelTypes(type)), this.parseVertexProperties(vertex, type));
    }

    private Edge parseEdge(IrResult.Edge edge, RelDataType type) {
        GraphLabelType labelType = Utils.getLabelTypes(type);
        return new DetachedEdge((Object)edge.getId(), Utils.getLabelName(edge.getLabel(), labelType), this.parseEdgeProperties(edge, type), (Object)edge.getSrcId(), Utils.getSrcLabelName(edge.getSrcLabel(), labelType), (Object)edge.getDstId(), Utils.getDstLabelName(edge.getDstLabel(), labelType));
    }

    protected Map<String, Object> parseVertexProperties(IrResult.Vertex vertex, RelDataType type) {
        return ImmutableMap.of();
    }

    protected Map<String, Object> parseEdgeProperties(IrResult.Edge edge, RelDataType type) {
        return ImmutableMap.of();
    }

    private List<Element> parseGraphPath(IrResult.GraphPath path, @Nullable RelDataType dataType) {
        return path.getPathList().stream().map(k -> {
            switch (k.getInnerCase()) {
                case VERTEX: {
                    return this.parseVertex(k.getVertex(), Utils.getVertexType(dataType));
                }
                case EDGE: {
                    return this.parseEdge(k.getEdge(), Utils.getEdgeType(dataType));
                }
            }
            throw new GremlinResultParserException(k.getInnerCase() + " is invalid");
        }).collect(Collectors.toList());
    }

    protected @Nullable Object parseValue(Common.Value value, @Nullable RelDataType dataType) {
        if (dataType instanceof GraphLabelType) {
            return Utils.parseLabelValue(value, (GraphLabelType)dataType);
        }
        switch (value.getItemCase()) {
            case BOOLEAN: {
                return value.getBoolean();
            }
            case I32: {
                return value.getI32();
            }
            case I64: {
                return value.getI64();
            }
            case F64: {
                return value.getF64();
            }
            case STR: {
                return value.getStr();
            }
            case I32_ARRAY: {
                return value.getI32Array().getItemList();
            }
            case I64_ARRAY: {
                return value.getI64Array().getItemList();
            }
            case F64_ARRAY: {
                return value.getF64Array().getItemList();
            }
            case STR_ARRAY: {
                return value.getStrArray().getItemList();
            }
            case PAIR_ARRAY: {
                if (dataType instanceof MapSqlType) {
                    return value.getPairArray().getItemList().stream().collect(Collectors.toMap(k -> this.parseValue(k.getKey(), dataType.getKeyType()), v -> this.parseValue(v.getVal(), dataType.getValueType())));
                }
                if (dataType instanceof ArbitraryMapType) {
                    LinkedHashMap map = Maps.newLinkedHashMap();
                    Map<RexNode, ArbitraryMapType.KeyValueType> keyValueTypeMap = ((ArbitraryMapType)dataType).getKeyValueTypeMap();
                    value.getPairArray().getItemList().forEach(pair -> {
                        ArbitraryMapType.KeyValueType keyValueType = Utils.getKeyValueType(pair.getKey(), keyValueTypeMap);
                        map.put(this.parseValue(pair.getKey(), keyValueType == null ? null : (RelDataType)keyValueType.getKey()), this.parseValue(pair.getVal(), keyValueType == null ? null : (RelDataType)keyValueType.getValue()));
                    });
                    return map;
                }
            }
            case NONE: {
                return null;
            }
        }
        throw new NotImplementedException(value.getItemCase() + " is unsupported yet");
    }
}

