/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.transform;

import com.alibaba.graphscope.common.exception.OpArgIllegalException;
import com.alibaba.graphscope.common.intermediate.ArgAggFn;
import com.alibaba.graphscope.common.intermediate.ArgUtils;
import com.alibaba.graphscope.common.intermediate.ArgVariable;
import com.alibaba.graphscope.common.intermediate.operator.ApplyOp;
import com.alibaba.graphscope.common.intermediate.operator.DedupOp;
import com.alibaba.graphscope.common.intermediate.operator.GroupOp;
import com.alibaba.graphscope.common.intermediate.operator.InterOpBase;
import com.alibaba.graphscope.common.intermediate.operator.OpArg;
import com.alibaba.graphscope.common.intermediate.operator.OrderOp;
import com.alibaba.graphscope.common.intermediate.operator.ProjectOp;
import com.alibaba.graphscope.common.intermediate.operator.SampleOp;
import com.alibaba.graphscope.common.intermediate.operator.SelectOp;
import com.alibaba.graphscope.common.jna.type.FfiAggOpt;
import com.alibaba.graphscope.common.jna.type.FfiAlias;
import com.alibaba.graphscope.common.jna.type.FfiJoinKind;
import com.alibaba.graphscope.common.jna.type.FfiOrderOpt;
import com.alibaba.graphscope.common.jna.type.FfiVariable;
import com.alibaba.graphscope.gremlin.InterOpCollectionBuilder;
import com.alibaba.graphscope.gremlin.Utils;
import com.alibaba.graphscope.gremlin.antlr4.GremlinAntlrToJava;
import com.alibaba.graphscope.gremlin.plugin.step.GroupCountStep;
import com.alibaba.graphscope.gremlin.plugin.step.GroupStep;
import com.alibaba.graphscope.gremlin.transform.ExprArg;
import com.alibaba.graphscope.gremlin.transform.ExprResult;
import com.alibaba.graphscope.gremlin.transform.PredicateExprTransformFactory;
import com.alibaba.graphscope.gremlin.transform.TraversalParentTransform;
import com.alibaba.graphscope.gremlin.transform.alias.AliasArg;
import com.alibaba.graphscope.gremlin.transform.alias.AliasManager;
import com.alibaba.graphscope.gremlin.transform.alias.AliasPrefixType;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NotStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.SampleGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WherePredicateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FoldStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.javatuples.Pair;

public enum TraversalParentTransformFactory implements TraversalParentTransform
{
    PROJECT_BY_STEP{

        @Override
        public List<InterOpBase> apply(TraversalParent parent) {
            ArrayList<InterOpBase> interOpList = new ArrayList<InterOpBase>();
            Map<String, Traversal.Admin> byTraversals = this.getProjectTraversals(parent);
            ArrayList<Pair> projectExprWithAlias = new ArrayList<Pair>();
            int stepIdx = TraversalHelper.stepIndex((Step)parent.asStep(), (Traversal.Admin)parent.asStep().getTraversal());
            int subId = 0;
            ExprResult exprRes = this.getSubTraversalAsExpr(new ExprArg(Collections.singletonList(parent.asStep())));
            Map<String, Optional<String>> tagExprMap = exprRes.getTagExprMap();
            for (Map.Entry<String, Optional<String>> entry : tagExprMap.entrySet()) {
                Object expr;
                String k = entry.getKey();
                Optional<String> v = entry.getValue();
                if (v.isPresent()) {
                    expr = v.get();
                } else {
                    ApplyOp applyOp = new ApplyOp();
                    applyOp.setJoinKind(new OpArg(FfiJoinKind.Inner));
                    Traversal copy = (Traversal)GremlinAntlrToJava.getTraversalSupplier().get();
                    copy.asAdmin().addStep((Step)new SelectOneStep(copy.asAdmin(), Pop.last, k));
                    Traversal.Admin admin = byTraversals.get(k);
                    admin.getSteps().forEach(s -> copy.asAdmin().addStep((Step)s));
                    applyOp.setSubOpCollection(new OpArg(new InterOpCollectionBuilder(copy).build()));
                    FfiAlias.ByValue applyAlias = AliasManager.getFfiAlias(new AliasArg(AliasPrefixType.PROJECT_TAG, k, stepIdx, subId));
                    applyOp.setAlias(new OpArg(applyAlias, Function.identity()));
                    interOpList.add(applyOp);
                    String aliasName = applyAlias.alias.name;
                    expr = "@" + aliasName;
                }
                FfiAlias.ByValue alias = AliasManager.getFfiAlias(new AliasArg(AliasPrefixType.PROJECT_TAG, k, stepIdx, subId));
                projectExprWithAlias.add(Pair.with((Object)expr, (Object)((Object)alias)));
                ++subId;
            }
            if (projectExprWithAlias.size() == 1) {
                Pair single = (Pair)projectExprWithAlias.get(0);
                projectExprWithAlias.set(0, single.setAt1((Object)ArgUtils.asNoneAlias()));
            }
            ProjectOp op = new ProjectOp();
            op.setExprWithAlias(new OpArg(projectExprWithAlias));
            interOpList.add(op);
            return interOpList;
        }
    }
    ,
    DEDUP_STEP{

        @Override
        public List<InterOpBase> apply(TraversalParent parent) {
            DedupGlobalStep dedupStep = (DedupGlobalStep)parent;
            ArrayList<InterOpBase> interOpList = new ArrayList<InterOpBase>();
            ArrayList<FfiVariable.ByValue> dedupVars = new ArrayList<FfiVariable.ByValue>();
            int stepIdx = TraversalHelper.stepIndex((Step)parent.asStep(), (Traversal.Admin)parent.asStep().getTraversal());
            int subId = 0;
            ExprResult exprRes = this.getSubTraversalAsExpr(new ExprArg(Collections.singletonList(parent.asStep())));
            Map<String, Optional<String>> tagExprMap = exprRes.getTagExprMap();
            IdentityTraversal byTraversal = dedupStep.getLocalChildren().isEmpty() ? new IdentityTraversal() : (Traversal.Admin)dedupStep.getLocalChildren().get(0);
            for (Map.Entry<String, Optional<String>> entry : tagExprMap.entrySet()) {
                Object expr;
                String k = entry.getKey();
                Optional<String> v = entry.getValue();
                if (v.isPresent()) {
                    expr = v.get();
                } else {
                    ApplyOp applyOp = new ApplyOp();
                    applyOp.setJoinKind(new OpArg(FfiJoinKind.Inner));
                    Traversal copy = (Traversal)GremlinAntlrToJava.getTraversalSupplier().get();
                    if (k != null && !k.isEmpty()) {
                        copy.asAdmin().addStep((Step)new SelectOneStep(copy.asAdmin(), Pop.last, k));
                    }
                    byTraversal.getSteps().forEach(s -> copy.asAdmin().addStep((Step)s));
                    applyOp.setSubOpCollection(new OpArg(new InterOpCollectionBuilder(copy).build()));
                    FfiAlias.ByValue applyAlias = AliasManager.getFfiAlias(new AliasArg(AliasPrefixType.DEFAULT, stepIdx, subId));
                    applyOp.setAlias(new OpArg(applyAlias));
                    interOpList.add(applyOp);
                    String applyAliasName = applyAlias.alias.name;
                    expr = "@" + applyAliasName;
                }
                dedupVars.add(this.getExpressionAsVar((String)expr));
                ++subId;
            }
            DedupOp dedupOp = new DedupOp();
            dedupOp.setDedupKeys(new OpArg(dedupVars));
            interOpList.add(dedupOp);
            return interOpList;
        }
    }
    ,
    SAMPLE_BY_STEP{

        @Override
        public List<InterOpBase> apply(TraversalParent parent) {
            Object expr;
            SampleGlobalStep sampleStep = (SampleGlobalStep)parent;
            IdentityTraversal probabilityTraversal = sampleStep.getLocalChildren().isEmpty() ? new IdentityTraversal() : (Traversal.Admin)sampleStep.getLocalChildren().get(0);
            Optional<String> exprOpt = this.getSubTraversalAsExpr(new ExprArg((Traversal.Admin)probabilityTraversal)).getSingleExpr();
            ArrayList interOpList = Lists.newArrayList();
            if (exprOpt.isPresent()) {
                expr = exprOpt.get();
            } else {
                ApplyOp applyOp = new ApplyOp();
                applyOp.setJoinKind(new OpArg(FfiJoinKind.Inner));
                Traversal copy = (Traversal)GremlinAntlrToJava.getTraversalSupplier().get();
                probabilityTraversal.getSteps().forEach(s -> copy.asAdmin().addStep((Step)s));
                applyOp.setSubOpCollection(new OpArg(new InterOpCollectionBuilder(copy).build()));
                int stepIdx = TraversalHelper.stepIndex((Step)parent.asStep(), (Traversal.Admin)parent.asStep().getTraversal());
                FfiAlias.ByValue applyAlias = AliasManager.getFfiAlias(new AliasArg(AliasPrefixType.DEFAULT, stepIdx, 0));
                applyOp.setAlias(new OpArg(applyAlias));
                interOpList.add(applyOp);
                String applyAliasName = applyAlias.alias.name;
                expr = "@" + applyAliasName;
            }
            int sampleAmount = (Integer)Utils.getFieldValue(SampleGlobalStep.class, sampleStep, "amountToSample");
            SampleOp sampleOp = new SampleOp(SampleOp.AmountType.create(sampleAmount), this.getSeed(sampleStep), this.getExpressionAsVar((String)expr));
            interOpList.add(sampleOp);
            return interOpList;
        }

        private long getSeed(SampleGlobalStep step) {
            Random random = (Random)Utils.getFieldValue(SampleGlobalStep.class, step, "random");
            AtomicLong seed = (AtomicLong)Utils.getFieldValue(Random.class, random, "seed");
            return seed.get();
        }
    }
    ,
    ORDER_BY_STEP{

        @Override
        public List<InterOpBase> apply(TraversalParent parent) {
            OrderGlobalStep orderStep = (OrderGlobalStep)parent;
            ArrayList<InterOpBase> interOpList = new ArrayList<InterOpBase>();
            ArrayList<Pair> exprWithOrderList = new ArrayList<Pair>();
            List comparators = orderStep.getComparators();
            int stepIdx = TraversalHelper.stepIndex((Step)parent.asStep(), (Traversal.Admin)parent.asStep().getTraversal());
            for (int i = 0; i < comparators.size(); ++i) {
                Pair pair = (Pair)comparators.get(i);
                Traversal.Admin admin = (Traversal.Admin)pair.getValue0();
                FfiOrderOpt orderOpt = this.getFfiOrderOpt((Order)pair.getValue1());
                ExprResult exprRes = this.getSubTraversalAsExpr(new ExprArg(admin));
                if (exprRes.getTagExprMap().size() != 1) {
                    throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "each order().by(..) is corresponding to exact one expression, multiple order keys should be defined in different bys");
                }
                Optional<String> singleExpr = exprRes.getSingleExpr();
                if (singleExpr.isPresent()) {
                    exprWithOrderList.add(Pair.with((Object)singleExpr.get(), (Object)orderOpt));
                    continue;
                }
                ApplyOp applyOp = new ApplyOp();
                applyOp.setJoinKind(new OpArg(FfiJoinKind.Inner));
                applyOp.setSubOpCollection(new OpArg(new InterOpCollectionBuilder((Traversal)admin).build()));
                FfiAlias.ByValue applyAlias = AliasManager.getFfiAlias(new AliasArg(AliasPrefixType.DEFAULT, stepIdx, i));
                applyOp.setAlias(new OpArg(applyAlias, Function.identity()));
                interOpList.add(applyOp);
                String aliasName = applyAlias.alias.name;
                exprWithOrderList.add(Pair.with((Object)("@" + aliasName), (Object)orderOpt));
            }
            OrderOp orderOp = new OrderOp();
            List varWithOrder = exprWithOrderList.stream().map(k -> {
                String expr = (String)k.getValue0();
                FfiVariable.ByValue var = this.getExpressionAsVar(expr);
                return k.setAt0((Object)var);
            }).collect(Collectors.toList());
            orderOp.setOrderVarWithOrder(new OpArg(varWithOrder));
            interOpList.add(orderOp);
            return interOpList;
        }

        private FfiOrderOpt getFfiOrderOpt(Order order) {
            switch (order) {
                case asc: {
                    return FfiOrderOpt.Asc;
                }
                case desc: {
                    return FfiOrderOpt.Desc;
                }
                case shuffle: {
                    return FfiOrderOpt.Shuffle;
                }
            }
            throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "invalid order type");
        }
    }
    ,
    GROUP_BY_STEP{

        @Override
        public List<InterOpBase> apply(TraversalParent parent) {
            ArrayList<InterOpBase> interOpList = new ArrayList<InterOpBase>();
            GroupOp groupOp = new GroupOp();
            groupOp.setGroupByKeys(new OpArg(this.getGroupKeysAsVars(parent, interOpList)));
            groupOp.setGroupByValues(new OpArg(this.getGroupValuesAsAggFns(parent)));
            interOpList.add(groupOp);
            return interOpList;
        }

        private List<Pair<FfiVariable.ByValue, FfiAlias.ByValue>> getGroupKeysAsVars(TraversalParent parent, List<InterOpBase> interOpList) {
            ArrayList<Pair<FfiVariable.ByValue, FfiAlias.ByValue>> vars = new ArrayList<Pair<FfiVariable.ByValue, FfiAlias.ByValue>>();
            int stepIdx = TraversalHelper.stepIndex((Step)parent.asStep(), (Traversal.Admin)parent.asStep().getTraversal());
            List<Traversal.Admin> keyTraversals = this.getKeyTraversals(parent);
            for (int i = 0; i < keyTraversals.size(); ++i) {
                FfiAlias.ByValue alias;
                Step endStep;
                Object expr;
                Traversal.Admin k = keyTraversals.get(i);
                ExprResult exprRes = this.getSubTraversalAsExpr(new ExprArg(k));
                if (exprRes.getTagExprMap().size() != 1) {
                    throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "each group().by(..) is corresponding to exact one expression, multiple group keys should be defined in different bys");
                }
                Optional<String> singleExpr = exprRes.getSingleExpr();
                if (singleExpr.isPresent()) {
                    expr = singleExpr.get();
                } else {
                    ApplyOp applyOp = new ApplyOp();
                    applyOp.setJoinKind(new OpArg(FfiJoinKind.Inner));
                    applyOp.setSubOpCollection(new OpArg(new InterOpCollectionBuilder((Traversal)k).build()));
                    FfiAlias.ByValue applyAlias = AliasManager.getFfiAlias(new AliasArg(AliasPrefixType.GROUP_KEYS, stepIdx, i));
                    applyOp.setAlias(new OpArg(applyAlias));
                    interOpList.add(applyOp);
                    String aliasName = applyAlias.alias.name;
                    expr = "@" + aliasName;
                }
                if (k != null && !((endStep = k.getEndStep()) instanceof EmptyStep) && !endStep.getLabels().isEmpty()) {
                    String queryAlias = (String)endStep.getLabels().iterator().next();
                    alias = ArgUtils.asAlias(queryAlias, true);
                } else {
                    alias = AliasManager.getFfiAlias(new AliasArg(AliasPrefixType.GROUP_KEYS, stepIdx, i));
                }
                vars.add((Pair<FfiVariable.ByValue, FfiAlias.ByValue>)Pair.with((Object)((Object)this.getExpressionAsVar((String)expr)), (Object)((Object)alias)));
            }
            return vars;
        }

        private List<ArgAggFn> getGroupValuesAsAggFns(TraversalParent parent) {
            List<Traversal.Admin> valueTraversals = this.getValueTraversals(parent);
            ArrayList<ArgAggFn> argAggFns = new ArrayList<ArgAggFn>();
            int stepIdx = TraversalHelper.stepIndex((Step)parent.asStep(), (Traversal.Admin)parent.asStep().getTraversal());
            for (int i = 0; i < valueTraversals.size(); ++i) {
                Step endStep;
                Traversal.Admin admin = valueTraversals.get(i);
                if (admin == null || (endStep = admin.getEndStep()) == null) {
                    throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "default is [FoldStep], null end step is invalid");
                }
                ArgAggFn aggFn = this.getAggFn(endStep, stepIdx, i);
                if (endStep instanceof CountGlobalStep && endStep.getPreviousStep() instanceof DedupGlobalStep) {
                    aggFn.setAggregate(FfiAggOpt.CountDistinct);
                } else if (endStep instanceof FoldStep && endStep.getPreviousStep() instanceof DedupGlobalStep) {
                    aggFn.setAggregate(FfiAggOpt.ToSet);
                }
                if (admin.getSteps().size() > 1) {
                    ExprArg exprArg = new ExprArg(admin.getSteps().subList(0, admin.getSteps().size() - 1));
                    ExprResult exprRes = this.getSubTraversalAsExpr(exprArg);
                    if (exprRes.getTagExprMap().size() != 1) {
                        throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "each group()..by(..) (value_by) is corresponding to exact one expression, multiple group values should be defined in different bys");
                    }
                    Optional<String> singleExpr = exprRes.getSingleExpr();
                    if (singleExpr.isPresent()) {
                        aggFn.setVar(this.getExpressionAsVar(singleExpr.get()));
                    } else {
                        throw new OpArgIllegalException(OpArgIllegalException.Cause.UNSUPPORTED_TYPE, "segment apply is unsupported");
                    }
                }
                argAggFns.add(aggFn);
            }
            return argAggFns;
        }

        private List<Traversal.Admin> getKeyTraversals(TraversalParent step) {
            if (step instanceof GroupStep) {
                GroupStep groupStep = (GroupStep)step;
                return groupStep.getKeyTraversalList();
            }
            if (step instanceof GroupCountStep) {
                GroupCountStep groupCountStep = (GroupCountStep)step;
                return groupCountStep.getKeyTraversalList();
            }
            throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "cannot get key traversal from " + step.getClass());
        }

        private List<Traversal.Admin> getValueTraversals(TraversalParent step) {
            if (step instanceof GroupStep) {
                GroupStep groupStep = (GroupStep)step;
                return groupStep.getValueTraversalList();
            }
            if (step instanceof GroupCountStep) {
                GroupCountStep groupCountStep = (GroupCountStep)step;
                return groupCountStep.getValueTraversalList();
            }
            throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "cannot get value traversal from " + step.getClass());
        }
    }
    ,
    WHERE_BY_STEP{

        @Override
        public List<InterOpBase> apply(TraversalParent parent) {
            ArrayList<InterOpBase> interOpList = new ArrayList<InterOpBase>();
            WherePredicateStep step = (WherePredicateStep)parent;
            Optional startKey = step.getStartKey();
            TraversalRing traversalRing = (TraversalRing)Utils.getFieldValue(WherePredicateStep.class, step, "traversalRing");
            int stepId = TraversalHelper.stepIndex((Step)parent.asStep(), (Traversal.Admin)parent.asStep().getTraversal());
            AtomicInteger subId = new AtomicInteger(0);
            String startTag = startKey.isPresent() ? (String)startKey.get() : "";
            String startExpr = this.getExprWithApplys(startTag, traversalRing.next(), stepId, subId, interOpList);
            P predicate = (P)step.getPredicate().get();
            List selectKeys = (List)Utils.getFieldValue(WherePredicateStep.class, step, "selectKeys");
            this.traverseAndUpdateP(predicate, selectKeys.iterator(), traversalRing, stepId, subId, interOpList);
            String expr = PredicateExprTransformFactory.HAS_STEP.flatPredicate(startExpr, predicate);
            SelectOp selectOp = new SelectOp();
            selectOp.setPredicate(new OpArg(expr));
            interOpList.add(selectOp);
            return interOpList;
        }

        private void traverseAndUpdateP(P predicate, Iterator<String> selectKeysIterator, TraversalRing traversalRing, int stepId, AtomicInteger subId, List<InterOpBase> applys) {
            if (predicate instanceof ConnectiveP) {
                ((ConnectiveP)predicate).getPredicates().forEach(p1 -> this.traverseAndUpdateP((P)p1, selectKeysIterator, traversalRing, stepId, subId, applys));
            } else {
                String expr = this.getExprWithApplys(selectKeysIterator.next(), traversalRing.next(), stepId, subId, applys);
                ArgVariable var = this.getExpressionAsArgVar(expr);
                predicate.setValue((Object)var);
            }
        }

        private String getExprWithApplys(String tag, Traversal.Admin whereby, int stepId, AtomicInteger subId, List<InterOpBase> applys) {
            Traversal.Admin tagBy = this.asSelectTraversal(tag, whereby);
            ExprResult exprRes = this.getSubTraversalAsExpr(new ExprArg(tagBy));
            if (exprRes.getTagExprMap().size() != 1) {
                throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "each where().by(..) is corresponding to exact one expression, multiple where conditions should be defined in different bys");
            }
            Optional<String> singleExpr = exprRes.getSingleExpr();
            if (singleExpr.isPresent()) {
                return singleExpr.get();
            }
            ApplyOp applyOp = new ApplyOp();
            applyOp.setJoinKind(new OpArg(FfiJoinKind.Inner));
            Traversal copy = (Traversal)GremlinAntlrToJava.getTraversalSupplier().get();
            copy.asAdmin().addStep((Step)new SelectOneStep(copy.asAdmin(), Pop.last, tag));
            whereby.getSteps().forEach(s -> copy.asAdmin().addStep((Step)s));
            applyOp.setSubOpCollection(new OpArg(new InterOpCollectionBuilder(copy).build()));
            FfiAlias.ByValue applyAlias = AliasManager.getFfiAlias(new AliasArg(AliasPrefixType.DEFAULT, stepId, subId.getAndIncrement()));
            applyOp.setAlias(new OpArg(applyAlias));
            applys.add(applyOp);
            return "@" + applyAlias.alias.name;
        }

        private Traversal.Admin asSelectTraversal(String selectKey, Traversal.Admin byTraversal) {
            Traversal.Admin traversal = (Traversal.Admin)GremlinAntlrToJava.getTraversalSupplier().get();
            SelectOneStep oneStep = new SelectOneStep(traversal, Pop.last, selectKey);
            oneStep.modulateBy(byTraversal);
            traversal.addStep((Step)oneStep);
            return traversal;
        }
    }
    ,
    WHERE_TRAVERSAL_STEP{

        @Override
        public List<InterOpBase> apply(TraversalParent parent) {
            Traversal.Admin subTraversal = this.getWhereSubTraversal(parent.asStep());
            ExprResult exprRes = this.getSubTraversalAsExpr(new ExprArg(subTraversal));
            if (exprRes.getTagExprMap().size() != 1) {
                throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "each where(..) is corresponding to exact one expression, multiple filter conditions should be defined in different wheres");
            }
            Optional<String> singleExpr = exprRes.getSingleExpr();
            if (singleExpr.isPresent()) {
                String expr = singleExpr.get();
                SelectOp selectOp = new SelectOp();
                selectOp.setPredicate(new OpArg(expr));
                return Collections.singletonList(selectOp);
            }
            ApplyOp applyOp = new ApplyOp();
            FfiJoinKind joinKind = FfiJoinKind.Semi;
            applyOp.setJoinKind(new OpArg(joinKind, Function.identity()));
            applyOp.setSubOpCollection(new OpArg(new InterOpCollectionBuilder((Traversal)subTraversal).build()));
            return Collections.singletonList(applyOp);
        }

        private Traversal.Admin getWhereSubTraversal(Step step) {
            if (step instanceof TraversalFilterStep) {
                return ((TraversalFilterStep)step).getFilterTraversal();
            }
            if (step instanceof WhereTraversalStep) {
                WhereTraversalStep whereStep = (WhereTraversalStep)step;
                List subTraversals = whereStep.getLocalChildren();
                return subTraversals.isEmpty() ? null : (Traversal.Admin)subTraversals.get(0);
            }
            throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "cannot get where traversal from " + step.getClass());
        }
    }
    ,
    NOT_TRAVERSAL_STEP{

        @Override
        public List<InterOpBase> apply(TraversalParent parent) {
            Traversal.Admin subTraversal = this.getNotSubTraversal(parent.asStep());
            ExprResult exprRes = this.getSubTraversalAsExpr(new ExprArg(subTraversal));
            if (exprRes.getTagExprMap().size() != 1) {
                throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "each not(..) is corresponding to exact one expression, multiple anti conditions should be defined in different nos");
            }
            Optional<String> singleExpr = exprRes.getSingleExpr();
            if (singleExpr.isPresent()) {
                String notExpr = this.getNotExpr(singleExpr.get());
                SelectOp selectOp = new SelectOp();
                selectOp.setPredicate(new OpArg(notExpr));
                return Collections.singletonList(selectOp);
            }
            ApplyOp applyOp = new ApplyOp();
            FfiJoinKind joinKind = FfiJoinKind.Anti;
            applyOp.setJoinKind(new OpArg(joinKind));
            applyOp.setSubOpCollection(new OpArg(new InterOpCollectionBuilder((Traversal)subTraversal).build()));
            return Collections.singletonList(applyOp);
        }

        private Traversal.Admin getNotSubTraversal(Step step) {
            if (step instanceof NotStep) {
                NotStep notStep = (NotStep)step;
                List subTraversals = notStep.getLocalChildren();
                return subTraversals.isEmpty() ? null : (Traversal.Admin)subTraversals.get(0);
            }
            throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "cannot get where traversal from " + step.getClass());
        }

        private String getNotExpr(String expr) {
            return expr.contains("&&") || expr.contains("||") ? String.format("!(%s)", expr) : "!" + expr;
        }
    };

}

