/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.alibaba.graphscope.common.ir.rex.RexCallBinding;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.implicit.TypeCoercion;
import org.apache.calcite.util.Litmus;

public class GraphFamilyOperandTypeChecker
extends FamilyOperandTypeChecker {
    protected final List<RelDataTypeFamily> expectedFamilies;

    protected GraphFamilyOperandTypeChecker(List<RelDataTypeFamily> typeFamilies, Predicate<Integer> optional) {
        super((List)ImmutableList.of(), optional);
        this.expectedFamilies = typeFamilies;
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (this.expectedFamilies.size() != callBinding.getOperandCount()) {
            Litmus.THROW.fail("Expect {} operands, but got {} operands, expected operands of types {}", new Object[]{this.expectedFamilies.size(), callBinding.getOperandCount(), this.expectedFamilies});
        }
        if (!(callBinding instanceof RexCallBinding)) {
            throw new IllegalArgumentException("argument \"callBinding\" in subclass=" + ((Object)((Object)this)).getClass() + " should be of type=" + RexCallBinding.class);
        }
        RexCallBinding rexCallBinding = (RexCallBinding)callBinding;
        for (Ord op : Ord.zip(rexCallBinding.getRexOperands())) {
            if (this.checkSingleOperandType(callBinding, (RexNode)op.e, op.i, false)) continue;
            boolean coerced = false;
            if (callBinding.isTypeCoercionEnabled()) {
                TypeCoercion typeCoercion = callBinding.getValidator().getTypeCoercion();
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < callBinding.getOperandCount(); ++i) {
                    builder.add((Object)callBinding.getOperandType(i));
                }
                ImmutableList dataTypes = builder.build();
                coerced = typeCoercion.builtinFunctionCoercion(callBinding, (List)dataTypes, (List)this.families);
            }
            for (Ord op1 : Ord.zip(rexCallBinding.getRexOperands())) {
                if (this.checkSingleOperandType(callBinding, (RexNode)op1.e, op1.i, throwOnFailure)) continue;
                return false;
            }
            return coerced;
        }
        return true;
    }

    public boolean checkOperandTypesWithoutTypeCoercion(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (this.expectedFamilies.size() != callBinding.getOperandCount()) {
            return false;
        }
        if (!(callBinding instanceof RexCallBinding)) {
            throw new IllegalArgumentException("callBinding in subclass=" + ((Object)((Object)this)).getClass() + " should be " + RexCallBinding.class);
        }
        RexCallBinding rexCallBinding = (RexCallBinding)callBinding;
        for (Ord op : Ord.zip(rexCallBinding.getRexOperands())) {
            if (this.checkSingleOperandType(callBinding, (RexNode)op.e, op.i, throwOnFailure)) continue;
            return false;
        }
        return true;
    }

    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
        throw new UnsupportedOperationException("checkSingleOperandType is unsupported for we will never depend on SqlNode to check type");
    }

    public String getAllowedSignatures(SqlOperator op, String opName) {
        return SqlUtil.getAliasedSignature((SqlOperator)op, (String)opName, this.expectedFamilies);
    }

    protected boolean checkSingleOperandType(SqlCallBinding callBinding, RexNode node, int iFormalOperand, boolean throwOnFailure) {
        RelDataTypeFamily expectedFamily = this.expectedFamilies.get(iFormalOperand);
        RelDataType type = node.getType();
        if (expectedFamily instanceof SqlTypeFamily) {
            SqlTypeFamily sqlTypeFamily = (SqlTypeFamily)expectedFamily;
            switch (sqlTypeFamily) {
                case ANY: {
                    SqlTypeName typeName = node.getType().getSqlTypeName();
                    if (typeName == SqlTypeName.CURSOR) {
                        if (throwOnFailure) {
                            throw callBinding.newValidationSignatureError();
                        }
                        return false;
                    }
                }
                case IGNORE: {
                    return true;
                }
            }
            if (this.isNullLiteral(node)) {
                if (callBinding.isTypeCoercionEnabled()) {
                    return true;
                }
                if (throwOnFailure) {
                    throw new IllegalArgumentException("node " + node + " should not be of null value");
                }
                return false;
            }
            SqlTypeName typeName = type.getSqlTypeName();
            if (typeName.getFamily() == SqlTypeFamily.ANY) {
                return true;
            }
            if (!this.getAllowedTypeNames(callBinding.getTypeFactory(), sqlTypeFamily, iFormalOperand).contains(typeName)) {
                if (throwOnFailure) {
                    throw callBinding.newValidationSignatureError();
                }
                return false;
            }
        } else {
            if (type.getFamily() == SqlTypeFamily.ANY || expectedFamily == SqlTypeFamily.ANY) {
                return true;
            }
            if (type.getFamily() != expectedFamily) {
                if (throwOnFailure) {
                    throw callBinding.newValidationSignatureError();
                }
                return false;
            }
        }
        return true;
    }

    protected Collection<SqlTypeName> getAllowedTypeNames(RelDataTypeFactory typeFactory, SqlTypeFamily family, int iFormalOperand) {
        return family.getTypeNames();
    }

    private boolean isNullLiteral(RexNode node) {
        if (node instanceof RexLiteral) {
            RexLiteral literal = (RexLiteral)node;
            if (literal.getTypeName() == SqlTypeName.NULL) {
                assert (null == literal.getValue());
                return true;
            }
            return false;
        }
        return false;
    }
}

