/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.api.DatabaseManagementException;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;
import org.neo4j.logging.Log;

public class DatabaseManagementServiceImpl
implements DatabaseManagementService {
    private final DatabaseManager<?> databaseManager;
    private final Lifecycle globalLife;
    private final DatabaseEventListeners databaseEventListeners;
    private final GlobalTransactionEventListeners transactionEventListeners;
    private final Log log;
    private final Config globalConfig;

    public DatabaseManagementServiceImpl(DatabaseManager<?> databaseManager, Lifecycle globalLife, DatabaseEventListeners databaseEventListeners, GlobalTransactionEventListeners transactionEventListeners, Log log, Config globalConfig) {
        this.databaseManager = databaseManager;
        this.globalLife = globalLife;
        this.databaseEventListeners = databaseEventListeners;
        this.transactionEventListeners = transactionEventListeners;
        this.log = log;
        this.globalConfig = globalConfig;
    }

    public GraphDatabaseService database(String name) throws DatabaseNotFoundException {
        return ((DatabaseContext)this.databaseManager.getDatabaseContext(name).orElseThrow(() -> new DatabaseNotFoundException(name))).databaseFacade();
    }

    public void createDatabase(String name, Configuration databaseSpecificSettings) {
        String storageEngineName = this.getStorageEngine(databaseSpecificSettings);
        this.systemDatabaseExecute("CREATE DATABASE `" + name + "` OPTIONS {storageEngine:\"" + storageEngineName + "\"}");
    }

    private String getStorageEngine(Configuration databaseSpecificSettings) {
        String dbSpecificStorageEngineName = (String)databaseSpecificSettings.get(GraphDatabaseInternalSettings.storage_engine);
        return dbSpecificStorageEngineName != null ? dbSpecificStorageEngineName : (String)this.globalConfig.get(GraphDatabaseInternalSettings.storage_engine);
    }

    public void dropDatabase(String name) {
        this.systemDatabaseExecute("DROP DATABASE `" + name + "`");
    }

    public void startDatabase(String name) {
        this.systemDatabaseExecute("START DATABASE `" + name + "`");
    }

    public void shutdownDatabase(String name) {
        this.systemDatabaseExecute("STOP DATABASE `" + name + "`");
    }

    public List<String> listDatabases() {
        return this.databaseManager.registeredDatabases().keySet().stream().map(NamedDatabaseId::name).sorted().collect(Collectors.toList());
    }

    public void registerDatabaseEventListener(DatabaseEventListener listener) {
        this.databaseEventListeners.registerDatabaseEventListener(listener);
    }

    public void unregisterDatabaseEventListener(DatabaseEventListener listener) {
        this.databaseEventListeners.unregisterDatabaseEventListener(listener);
    }

    public void registerTransactionEventListener(String databaseName, TransactionEventListener<?> listener) {
        DatabaseManagementServiceImpl.validateDatabaseName(databaseName);
        this.transactionEventListeners.registerTransactionEventListener(databaseName, listener);
    }

    public void unregisterTransactionEventListener(String databaseName, TransactionEventListener<?> listener) {
        this.transactionEventListeners.unregisterTransactionEventListener(databaseName, listener);
    }

    public void shutdown() {
        try {
            this.log.info("Shutdown started");
            this.globalLife.shutdown();
        }
        catch (Exception throwable) {
            String message = "Shutdown failed";
            this.log.error(message, (Throwable)throwable);
            throw new RuntimeException(message, throwable);
        }
    }

    private void systemDatabaseExecute(String query) {
        try {
            GraphDatabaseAPI database = (GraphDatabaseAPI)this.database("system");
            try (InternalTransaction transaction = database.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
                transaction.execute(query);
                transaction.commit();
            }
        }
        catch (QueryExecutionException e) {
            throw new DatabaseManagementException((Throwable)e);
        }
    }

    private static void validateDatabaseName(String databaseName) {
        if ("system".equals(databaseName)) {
            throw new IllegalArgumentException("Registration of transaction event listeners on system is not supported.");
        }
    }

    private static interface SystemDatabaseExecutionContext {
        public void accept(GraphDatabaseAPI var1, InternalTransaction var2) throws KernelException;
    }
}

