/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.kernel.KernelVersion;

public enum DbmsRuntimeVersion implements ComponentVersion
{
    V4_1(1, "dbms-runtime", "Neo4j 4.1", KernelVersion.V4_0),
    V4_2(2, "dbms-runtime", "Neo4j 4.2.0", KernelVersion.V4_2),
    V4_3(3, "dbms-runtime", "Neo4j 4.3.0-Drop02", KernelVersion.V4_2),
    V4_3_D4(4, "dbms-runtime", "Neo4j 4.3.0-Drop04", KernelVersion.V4_3_D4),
    V4_4(5, "dbms-runtime", "Neo4j 4.4", KernelVersion.V4_4);

    public static final DbmsRuntimeVersion LATEST_DBMS_RUNTIME_COMPONENT_VERSION;
    private final String componentName;
    private final String description;
    private final KernelVersion kernelVersion;
    private final int version;

    private DbmsRuntimeVersion(int version, String componentName, String description, KernelVersion kernelVersion) {
        this.version = version;
        this.componentName = componentName;
        this.description = description;
        this.kernelVersion = kernelVersion;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public boolean isCurrent() {
        return this.version == DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION.version;
    }

    @Override
    public boolean migrationSupported() {
        return true;
    }

    @Override
    public boolean runtimeSupported() {
        return true;
    }

    public static DbmsRuntimeVersion fromVersionNumber(int versionNumber) {
        for (DbmsRuntimeVersion componentVersion : DbmsRuntimeVersion.values()) {
            if (componentVersion.version != versionNumber) continue;
            return componentVersion;
        }
        throw new IllegalArgumentException("Unrecognised DBMS runtime version number: " + versionNumber);
    }

    @Override
    public boolean isGreaterThan(ComponentVersion other) {
        if (!(other instanceof DbmsRuntimeVersion)) {
            throw new IllegalArgumentException("Comparison to different Version type");
        }
        return this.getVersion() > other.getVersion();
    }

    public KernelVersion kernelVersion() {
        return this.kernelVersion;
    }

    static {
        LATEST_DBMS_RUNTIME_COMPONENT_VERSION = V4_4;
    }
}

