/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.database.UpgradeLocker;
import org.neo4j.kernel.impl.api.InjectedNLIUpgradeCallback;
import org.neo4j.kernel.impl.locking.LockAcquisitionTimeoutException;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.internal.event.InternalTransactionEventListener;
import org.neo4j.lock.Lock;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.KernelVersionRepository;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;

class DatabaseUpgradeTransactionHandler {
    private final StorageEngine storageEngine;
    private final DbmsRuntimeRepository dbmsRuntimeRepository;
    private final KernelVersionRepository kernelVersionRepository;
    private final DatabaseTransactionEventListeners transactionEventListeners;
    private final AtomicBoolean unregistered = new AtomicBoolean();
    private final UpgradeLocker locker;
    private final Log log;

    DatabaseUpgradeTransactionHandler(StorageEngine storageEngine, DbmsRuntimeRepository dbmsRuntimeRepository, KernelVersionRepository kernelVersionRepository, DatabaseTransactionEventListeners transactionEventListeners, UpgradeLocker locker, LogProvider logProvider) {
        this.storageEngine = storageEngine;
        this.dbmsRuntimeRepository = dbmsRuntimeRepository;
        this.kernelVersionRepository = kernelVersionRepository;
        this.transactionEventListeners = transactionEventListeners;
        this.locker = locker;
        this.log = logProvider.getLog(this.getClass());
    }

    void registerUpgradeListener(InternalTransactionCommitHandler internalTransactionCommitHandler) {
        if (!this.kernelVersionRepository.kernelVersion().isLatest()) {
            this.transactionEventListeners.registerTransactionEventListener(new DatabaseUpgradeListener(internalTransactionCommitHandler));
        }
    }

    private class DatabaseUpgradeListener
    extends InternalTransactionEventListener.Adapter<Lock> {
        private final InternalTransactionCommitHandler internalTransactionCommitHandler;

        DatabaseUpgradeListener(InternalTransactionCommitHandler internalTransactionCommitHandler) {
            this.internalTransactionCommitHandler = internalTransactionCommitHandler;
        }

        @Override
        public Lock beforeCommit(TransactionData data, KernelTransaction tx, GraphDatabaseService databaseService) throws Exception {
            KernelVersion checkKernelVersion = DatabaseUpgradeTransactionHandler.this.kernelVersionRepository.kernelVersion();
            if (DatabaseUpgradeTransactionHandler.this.dbmsRuntimeRepository.getVersion().kernelVersion().isGreaterThan(checkKernelVersion)) {
                try (Lock lock = DatabaseUpgradeTransactionHandler.this.locker.acquireWriteLock(tx);){
                    KernelVersion kernelVersionToUpgradeTo = DatabaseUpgradeTransactionHandler.this.dbmsRuntimeRepository.getVersion().kernelVersion();
                    KernelVersion currentKernelVersion = DatabaseUpgradeTransactionHandler.this.kernelVersionRepository.kernelVersion();
                    if (kernelVersionToUpgradeTo.isGreaterThan(currentKernelVersion)) {
                        DatabaseUpgradeTransactionHandler.this.log.info("Upgrade transaction from %s to %s started", new Object[]{currentKernelVersion, kernelVersionToUpgradeTo});
                        InjectedNLIUpgradeCallback callback = tx.injectedNLIUpgradeCallback();
                        this.internalTransactionCommitHandler.commit(DatabaseUpgradeTransactionHandler.this.storageEngine.createUpgradeCommands(kernelVersionToUpgradeTo, callback));
                        DatabaseUpgradeTransactionHandler.this.log.info("Upgrade transaction from %s to %s completed", new Object[]{currentKernelVersion, kernelVersionToUpgradeTo});
                    }
                }
                catch (DeadlockDetectedException | LockAcquisitionTimeoutException ignore) {
                    DatabaseUpgradeTransactionHandler.this.log.info("Upgrade transaction from %s to %s not possible right now due to conflicting transaction, will retry on next write", new Object[]{checkKernelVersion, DatabaseUpgradeTransactionHandler.this.dbmsRuntimeRepository.getVersion().kernelVersion()});
                }
            }
            return DatabaseUpgradeTransactionHandler.this.locker.acquireReadLock(tx);
        }

        public void afterCommit(TransactionData data, Lock readLock, GraphDatabaseService databaseService) {
            this.checkUnlockAndUnregister(readLock);
        }

        public void afterRollback(TransactionData data, Lock readLock, GraphDatabaseService databaseService) {
            this.checkUnlockAndUnregister(readLock);
        }

        private void checkUnlockAndUnregister(Lock readLock) {
            if (readLock == null) {
                return;
            }
            readLock.close();
            if (DatabaseUpgradeTransactionHandler.this.kernelVersionRepository.kernelVersion().isLatest() && DatabaseUpgradeTransactionHandler.this.unregistered.compareAndSet(false, true)) {
                try {
                    DatabaseUpgradeTransactionHandler.this.transactionEventListeners.unregisterTransactionEventListener(this);
                }
                catch (Throwable e) {
                    DatabaseUpgradeTransactionHandler.this.unregistered.set(false);
                    throw e;
                }
            }
        }
    }

    static interface InternalTransactionCommitHandler {
        public void commit(List<StorageCommand> var1) throws TransactionFailureException;
    }
}

