/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.List;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.io.IOUtils;

class CombinedPartSeeker<KEY, VALUE>
implements Seeker<KEY, VALUE> {
    private final KEY end;
    private final Seeker<KEY, VALUE>[] partCursors;
    private final Object[] partHeads;
    private final Layout<KEY, VALUE> layout;
    private KEY nextKey;
    private VALUE nextValue;

    CombinedPartSeeker(Layout<KEY, VALUE> layout, List<Seeker<KEY, VALUE>> parts) {
        this.layout = layout;
        int length = parts.size();
        this.end = layout.newKey();
        this.partCursors = parts.toArray(new Seeker[0]);
        this.partHeads = new Object[length];
    }

    public boolean next() throws IOException {
        int nextKeyIndex = -1;
        for (int i = 0; i < this.partCursors.length; ++i) {
            Object candidate = this.partHeads[i];
            if (candidate == this.end) continue;
            if (candidate == null) {
                this.partHeads[i] = this.partCursors[i].next() ? (candidate = this.partCursors[i].key()) : this.end;
            }
            if (candidate == null || nextKeyIndex != -1 && this.layout.compare(candidate, this.nextKey) >= 0) continue;
            this.nextKey = candidate;
            nextKeyIndex = i;
        }
        if (nextKeyIndex != -1) {
            this.nextValue = this.partCursors[nextKeyIndex].value();
            this.partHeads[nextKeyIndex] = null;
            return true;
        }
        this.nextKey = null;
        this.nextValue = null;
        return false;
    }

    public void close() throws IOException {
        IOUtils.closeAll(this.partCursors);
    }

    public KEY key() {
        assert (this.nextKey != null);
        return this.nextKey;
    }

    public VALUE value() {
        assert (this.nextValue != null);
        return this.nextValue;
    }
}

