/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.Values;

class RawBits {
    static final byte BYTE = 0;
    static final byte SHORT = 1;
    static final byte INT = 2;
    static final byte LONG = 3;
    static final byte FLOAT = 4;
    static final byte DOUBLE = 5;

    RawBits() {
    }

    static NumberValue asNumberValue(long rawBits, byte type) {
        switch (type) {
            case 0: {
                return Values.byteValue((byte)((byte)rawBits));
            }
            case 1: {
                return Values.shortValue((short)((short)rawBits));
            }
            case 2: {
                return Values.intValue((int)((int)rawBits));
            }
            case 3: {
                return Values.longValue((long)rawBits);
            }
            case 4: {
                return Values.floatValue((float)Float.intBitsToFloat((int)rawBits));
            }
            case 5: {
                return Values.doubleValue((double)Double.longBitsToDouble(rawBits));
            }
        }
        return Values.longValue((long)rawBits);
    }

    static int compare(long lhsRawBits, byte lhsType, long rhsRawBits, byte rhsType) {
        if (lhsType == 0 || lhsType == 1 || lhsType == 2 || lhsType == 3) {
            return RawBits.compareLongAgainstRawType(lhsRawBits, rhsRawBits, rhsType);
        }
        if (lhsType == 4) {
            double lhsFloat = Float.intBitsToFloat((int)lhsRawBits);
            return RawBits.compareDoubleAgainstRawType(lhsFloat, rhsRawBits, rhsType);
        }
        if (lhsType == 5) {
            double lhsDouble = Double.longBitsToDouble(lhsRawBits);
            return RawBits.compareDoubleAgainstRawType(lhsDouble, rhsRawBits, rhsType);
        }
        return Long.compare(lhsRawBits, rhsRawBits);
    }

    private static int compareLongAgainstRawType(long lhs, long rhsRawBits, byte rhsType) {
        if (rhsType == 0 || rhsType == 1 || rhsType == 2 || rhsType == 3) {
            return Long.compare(lhs, rhsRawBits);
        }
        if (rhsType == 4) {
            return NumberValues.compareLongAgainstDouble((long)lhs, (double)Float.intBitsToFloat((int)rhsRawBits));
        }
        if (rhsType == 5) {
            return NumberValues.compareLongAgainstDouble((long)lhs, (double)Double.longBitsToDouble(rhsRawBits));
        }
        return Long.compare(lhs, rhsRawBits);
    }

    private static int compareDoubleAgainstRawType(double lhsDouble, long rhsRawBits, byte rhsType) {
        if (rhsType == 0 || rhsType == 1 || rhsType == 2 || rhsType == 3) {
            return NumberValues.compareDoubleAgainstLong((double)lhsDouble, (long)rhsRawBits);
        }
        if (rhsType == 4) {
            return Double.compare(lhsDouble, Float.intBitsToFloat((int)rhsRawBits));
        }
        if (rhsType == 5) {
            return Double.compare(lhsDouble, Double.longBitsToDouble(rhsRawBits));
        }
        return Long.compare(Double.doubleToLongBits(lhsDouble), rhsRawBits);
    }
}

