/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.internal.unsafe.NativeMemoryAllocationRefusedError;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public class UnsafeDirectByteBufferAllocator
implements ByteBufferFactory.Allocator {
    private final List<ScopedBuffer> allocations = new ArrayList<ScopedBuffer>();
    private boolean closed;

    public synchronized ScopedBuffer allocate(int bufferSize, MemoryTracker memoryTracker) {
        this.assertOpen();
        try {
            NativeScopedBuffer byteBuffer = new NativeScopedBuffer(bufferSize, memoryTracker);
            this.allocations.add((ScopedBuffer)byteBuffer);
            return byteBuffer;
        }
        catch (NativeMemoryAllocationRefusedError allocationRefusedError) {
            return new HeapScopedBuffer(bufferSize, memoryTracker);
        }
    }

    public synchronized void close() {
        if (!this.closed) {
            this.allocations.forEach(ScopedBuffer::close);
            this.closed = true;
        }
    }

    private void assertOpen() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Already closed");
    }
}

