/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.time.Clock;
import org.neo4j.common.ProgressReporter;
import org.neo4j.internal.helpers.Format;
import org.neo4j.kernel.impl.util.monitoring.LogProgressReporter;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.migration.MigrationProgressMonitor;

class VisibleMigrationProgressMonitor
implements MigrationProgressMonitor {
    static final String MESSAGE_STARTED = "Starting upgrade of database";
    static final String MESSAGE_COMPLETED = "Successfully finished upgrade of database";
    static final String TX_LOGS_MIGRATION_STARTED = "Starting transaction logs migration.";
    static final String TX_LOGS_MIGRATION_COMPLETED = "Transaction logs migration completed.";
    private static final String MESSAGE_COMPLETED_WITH_DURATION = "Successfully finished upgrade of database, took %s";
    private final Log log;
    private final Clock clock;
    private int numStages;
    private int currentStage;
    private long startTime;

    VisibleMigrationProgressMonitor(Log log) {
        this(log, Clock.systemUTC());
    }

    VisibleMigrationProgressMonitor(Log log, Clock clock) {
        this.log = log;
        this.clock = clock;
    }

    public void started(int numStages) {
        this.numStages = numStages;
        this.log.info(MESSAGE_STARTED);
        this.startTime = this.clock.millis();
    }

    public ProgressReporter startSection(String name) {
        this.log.info(String.format("Migrating %s (%d/%d):", name, ++this.currentStage, this.numStages));
        return new LogProgressReporter(this.log);
    }

    public void completed() {
        long time = this.clock.millis() - this.startTime;
        this.log.info(MESSAGE_COMPLETED_WITH_DURATION, new Object[]{Format.duration((long)time)});
    }

    public void startTransactionLogsMigration() {
        this.log.info(TX_LOGS_MIGRATION_STARTED);
    }

    public void completeTransactionLogsMigration() {
        this.log.info(TX_LOGS_MIGRATION_COMPLETED);
    }
}

