/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitment;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.AppendTransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.monitoring.Health;
import org.neo4j.storageengine.api.TransactionIdStore;

class BatchingTransactionAppender
extends LifecycleAdapter
implements TransactionAppender {
    private final TransactionMetadataCache transactionMetadataCache;
    private final LogFile logFile;
    private final LogRotation logRotation;
    private final TransactionIdStore transactionIdStore;
    private final Health databaseHealth;
    private TransactionLogWriter transactionLogWriter;
    private int previousChecksum;

    BatchingTransactionAppender(LogFiles logFiles, TransactionMetadataCache transactionMetadataCache, TransactionIdStore transactionIdStore, Health databaseHealth) {
        this.logFile = logFiles.getLogFile();
        this.logRotation = this.logFile.getLogRotation();
        this.transactionIdStore = transactionIdStore;
        this.databaseHealth = databaseHealth;
        this.transactionMetadataCache = transactionMetadataCache;
        this.previousChecksum = transactionIdStore.getLastCommittedTransaction().checksum();
    }

    public void start() {
        this.transactionLogWriter = this.logFile.getTransactionLogWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long append(TransactionToApply batch, LogAppendEvent logAppendEvent) throws IOException {
        long lastTransactionId = 1L;
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            this.databaseHealth.assertHealthy(IOException.class);
            try (AppendTransactionEvent appendEvent = logAppendEvent.beginAppendTransaction(1);){
                for (TransactionToApply tx = batch; tx != null; tx = tx.next()) {
                    long transactionId = this.transactionIdStore.nextCommittingTransactionId();
                    this.matchAgainstExpectedTransactionIdIfAny(transactionId, tx);
                    TransactionCommitment commitment = this.appendToLog(tx.transactionRepresentation(), transactionId, logAppendEvent, this.previousChecksum);
                    this.previousChecksum = commitment.getTransactionChecksum();
                    tx.commitment(commitment, transactionId);
                    tx.logPosition(commitment.logPosition());
                    lastTransactionId = transactionId;
                }
            }
        }
        if (this.logFile.forceAfterAppend(logAppendEvent)) {
            boolean logRotated = this.logRotation.rotateLogIfNeeded(logAppendEvent);
            logAppendEvent.setLogRotated(logRotated);
        }
        BatchingTransactionAppender.publishAsCommitted(batch);
        return lastTransactionId;
    }

    private void matchAgainstExpectedTransactionIdIfAny(long transactionId, TransactionToApply tx) {
        long expectedTransactionId = tx.transactionId();
        if (expectedTransactionId != 0L && transactionId != expectedTransactionId) {
            IllegalStateException ex = new IllegalStateException("Received " + tx.transactionRepresentation() + " with txId:" + expectedTransactionId + " to be applied, but appending it ended up generating an unexpected txId:" + transactionId);
            this.databaseHealth.panic((Throwable)ex);
            throw ex;
        }
    }

    private static void publishAsCommitted(TransactionToApply batch) {
        while (batch != null) {
            batch.publishAsCommitted();
            batch = batch.next();
        }
    }

    private TransactionCommitment appendToLog(TransactionRepresentation transaction, long transactionId, LogAppendEvent logAppendEvent, int previousChecksum) throws IOException {
        try {
            LogPosition logPositionBeforeCommit = this.transactionLogWriter.getCurrentPosition();
            int checksum = this.transactionLogWriter.append(transaction, transactionId, previousChecksum);
            LogPosition logPositionAfterCommit = this.transactionLogWriter.getCurrentPosition();
            logAppendEvent.appendToLogFile(logPositionBeforeCommit, logPositionAfterCommit);
            this.transactionMetadataCache.cacheTransactionMetadata(transactionId, logPositionBeforeCommit);
            return new TransactionCommitment(transactionId, checksum, transaction.getTimeCommitted(), logPositionAfterCommit, this.transactionIdStore);
        }
        catch (Throwable panic) {
            this.databaseHealth.panic(panic);
            throw panic;
        }
    }
}

