/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.ArrayList;
import java.util.Map;
import org.neo4j.exceptions.StoreFailureException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.util.ReadAndDeleteTransactionConflictException;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.impl.util.WrappingEntity;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.VirtualValues;

public class NodeEntityWrappingNodeValue
extends NodeValue
implements WrappingEntity<Node> {
    static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeEntityWrappingNodeValue.class) + NodeEntity.SHALLOW_SIZE;
    private final Node node;
    private volatile TextArray labels;
    private volatile MapValue properties;

    NodeEntityWrappingNodeValue(Node node) {
        super(node.getId());
        this.node = node;
    }

    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        if (writer.entityMode() == AnyValueWriter.EntityMode.REFERENCE) {
            writer.writeNodeReference(this.id());
        } else {
            MapValue p;
            TextArray l;
            boolean isDeleted = false;
            try {
                l = this.labels();
                p = this.properties();
            }
            catch (ReadAndDeleteTransactionConflictException e) {
                if (!e.wasDeletedInThisTransaction()) {
                    throw e;
                }
                l = Values.stringArray((String[])new String[0]);
                p = VirtualValues.EMPTY_MAP;
                isDeleted = true;
            }
            if (this.id() < 0L) {
                writer.writeVirtualNodeHack((Object)this.node);
            }
            writer.writeNode(this.node.getId(), l, p, isDeleted);
        }
    }

    public void populate(NodeCursor nodeCursor, PropertyCursor propertyCursor) {
        try {
            this.labels(nodeCursor);
            this.properties(nodeCursor, propertyCursor);
        }
        catch (ReadAndDeleteTransactionConflictException readAndDeleteTransactionConflictException) {
            // empty catch block
        }
    }

    public boolean isPopulated() {
        return this.labels != null && this.properties != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextArray labels(NodeCursor nodeCursor) {
        TextArray l = this.labels;
        if (l == null) {
            try {
                NodeEntityWrappingNodeValue nodeEntityWrappingNodeValue = this;
                synchronized (nodeEntityWrappingNodeValue) {
                    l = this.labels;
                    if (l == null) {
                        ArrayList<String> ls = new ArrayList<String>();
                        Iterable<Label> nodeLabels = this.node instanceof NodeEntity ? ((NodeEntity)this.node).getLabels(nodeCursor) : this.node.getLabels();
                        for (Label label : nodeLabels) {
                            ls.add(label.name());
                        }
                        l = this.labels = Values.stringArray((String[])ls.toArray(new String[0]));
                    }
                }
            }
            catch (IllegalStateException | StoreFailureException | NotFoundException e) {
                throw new ReadAndDeleteTransactionConflictException(NodeEntity.isDeletedInCurrentTransaction(this.node), e);
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextArray labels() {
        TextArray l = this.labels;
        if (l == null) {
            try {
                NodeEntityWrappingNodeValue nodeEntityWrappingNodeValue = this;
                synchronized (nodeEntityWrappingNodeValue) {
                    l = this.labels;
                    if (l == null) {
                        ArrayList<String> ls = new ArrayList<String>();
                        for (Label label : this.node.getLabels()) {
                            ls.add(label.name());
                        }
                        l = this.labels = Values.stringArray((String[])ls.toArray(new String[0]));
                    }
                }
            }
            catch (IllegalStateException | StoreFailureException | NotFoundException e) {
                throw new ReadAndDeleteTransactionConflictException(NodeEntity.isDeletedInCurrentTransaction(this.node), e);
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapValue properties() {
        MapValue m = this.properties;
        if (m == null) {
            try {
                NodeEntityWrappingNodeValue nodeEntityWrappingNodeValue = this;
                synchronized (nodeEntityWrappingNodeValue) {
                    m = this.properties;
                    if (m == null) {
                        m = this.properties = ValueUtils.asMapValue(this.node.getAllProperties());
                    }
                }
            }
            catch (IllegalStateException | StoreFailureException | NotFoundException e) {
                throw new ReadAndDeleteTransactionConflictException(NodeEntity.isDeletedInCurrentTransaction(this.node), e);
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapValue properties(NodeCursor nodeCursor, PropertyCursor propertyCursor) {
        MapValue m = this.properties;
        if (m == null) {
            try {
                NodeEntityWrappingNodeValue nodeEntityWrappingNodeValue = this;
                synchronized (nodeEntityWrappingNodeValue) {
                    m = this.properties;
                    if (m == null) {
                        Map<String, Object> nodeProperties = this.node instanceof NodeEntity ? ((NodeEntity)this.node).getAllProperties(nodeCursor, propertyCursor) : this.node.getAllProperties();
                        m = this.properties = ValueUtils.asMapValue(nodeProperties);
                    }
                }
            }
            catch (IllegalStateException | StoreFailureException | NotFoundException e) {
                throw new ReadAndDeleteTransactionConflictException(NodeEntity.isDeletedInCurrentTransaction(this.node), e);
            }
        }
        return m;
    }

    public long estimatedHeapUsage() {
        long size = SHALLOW_SIZE;
        if (this.labels != null) {
            size += this.labels.estimatedHeapUsage();
        }
        if (this.properties != null) {
            size += this.properties.estimatedHeapUsage();
        }
        return size;
    }

    @Override
    public Node getEntity() {
        return this.node;
    }
}

