/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.neo4j.internal.batchimport.cache.BaseNumberArray;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.memory.MemoryTracker;

public abstract class OffHeapNumberArray<N extends NumberArray<N>>
extends BaseNumberArray<N> {
    protected final long address;
    protected final long length;
    private final long allocatedBytes;
    protected final MemoryTracker memoryTracker;
    private boolean closed;

    protected OffHeapNumberArray(long length, int itemSize, long base, MemoryTracker memoryTracker) {
        super(itemSize, base);
        UnsafeUtil.assertHasUnsafe();
        this.memoryTracker = memoryTracker;
        this.length = length;
        this.allocatedBytes = length * (long)itemSize;
        this.address = UnsafeUtil.allocateMemory((long)this.allocatedBytes, (MemoryTracker)memoryTracker);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.offHeapUsage(this.allocatedBytes);
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.length > 0L) {
                UnsafeUtil.free((long)this.address, (long)this.allocatedBytes, (MemoryTracker)this.memoryTracker);
            }
            this.closed = true;
        }
    }
}

