/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.executor.ProcessorScheduler;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.internal.batchimport.staging.Step;

public class Stage
implements AutoCloseable {
    private final List<Step<?>> pipeline = new ArrayList();
    private final StageExecution execution;

    public Stage(String name, String part, Configuration config, int orderingGuarantees) {
        this(name, part, config, orderingGuarantees, ProcessorScheduler.SPAWN_THREAD, StageExecution.DEFAULT_PANIC_MONITOR);
    }

    public Stage(String name, String part, Configuration config, int orderingGuarantees, ProcessorScheduler scheduler, StageExecution.PanicMonitor panicMonitor) {
        this.execution = new StageExecution(name, part, config, this.pipeline, orderingGuarantees, scheduler, panicMonitor);
    }

    protected StageControl control() {
        return this.execution;
    }

    public void add(Step<?> step) {
        this.pipeline.add(step);
    }

    public StageExecution execute() {
        this.linkSteps();
        this.execution.start();
        this.pipeline.get(0).receive(1L, null);
        return this.execution;
    }

    private void linkSteps() {
        Step<?> previous = null;
        for (Step<?> step : this.pipeline) {
            if (previous != null) {
                previous.setDownstream(step);
            }
            previous = step;
        }
    }

    @Override
    public void close() {
        Exception exception = null;
        for (Step<?> step : this.pipeline) {
            try {
                step.close();
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        this.execution.close();
        if (exception != null) {
            throw new RuntimeException(exception);
        }
    }

    public String toString() {
        return this.execution.getStageName();
    }
}

