/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.collection.trackable.HeapTrackingLongArrayList;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.id.BufferingIdGenerator;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdSlotDistribution;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.IdUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;

public class BufferingIdGeneratorFactory
implements IdGeneratorFactory {
    private static final int MAX_QUEUED_BUFFERS = 20;
    private final Map<IdType, BufferingIdGenerator> overriddenIdGenerators = new HashMap<IdType, BufferingIdGenerator>();
    private Supplier<IdController.IdFreeCondition> boundaries;
    private MemoryTracker memoryTracker;
    private final IdGeneratorFactory delegate;
    private final Deque<IdBuffers> bufferQueue = new ArrayDeque<IdBuffers>();

    public BufferingIdGeneratorFactory(IdGeneratorFactory delegate) {
        this.delegate = delegate;
    }

    public void initialize(Supplier<IdController.IdFreeCondition> conditionSupplier, MemoryTracker memoryTracker) {
        this.boundaries = conditionSupplier;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public IdGenerator open(PageCache pageCache, Path filename, IdType idType, LongSupplier highIdScanner, long maxId, DatabaseReadOnlyChecker readOnlyChecker, Config config, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution) throws IOException {
        assert (this.boundaries != null) : "Factory needs to be initialized before usage";
        IdGenerator generator = this.delegate.open(pageCache, filename, idType, highIdScanner, maxId, readOnlyChecker, config, cursorContext, openOptions, slotDistribution);
        return this.wrapAndKeep(idType, generator);
    }

    @Override
    public IdGenerator create(PageCache pageCache, Path filename, IdType idType, long highId, boolean throwIfFileExists, long maxId, DatabaseReadOnlyChecker readOnlyChecker, Config config, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution) throws IOException {
        IdGenerator idGenerator = this.delegate.create(pageCache, filename, idType, highId, throwIfFileExists, maxId, readOnlyChecker, config, cursorContext, openOptions, slotDistribution);
        return this.wrapAndKeep(idType, idGenerator);
    }

    @Override
    public IdGenerator get(IdType idType) {
        IdGenerator generator = this.overriddenIdGenerators.get(idType);
        return generator != null ? generator : this.delegate.get(idType);
    }

    @Override
    public void visit(Consumer<IdGenerator> visitor) {
        this.overriddenIdGenerators.values().forEach(visitor);
    }

    @Override
    public void clearCache(CursorContext cursorContext) {
        this.delegate.clearCache(cursorContext);
    }

    @Override
    public Collection<Path> listIdFiles() {
        return this.delegate.listIdFiles();
    }

    private IdGenerator wrapAndKeep(IdType idType, IdGenerator generator) {
        BufferingIdGenerator bufferingGenerator = new BufferingIdGenerator(generator, this.memoryTracker);
        this.overriddenIdGenerators.put(idType, bufferingGenerator);
        return bufferingGenerator;
    }

    public synchronized void maintenance(CursorContext cursorContext) {
        IdBuffers candidate;
        if (this.bufferQueue.size() < 20) {
            ArrayList<IdBuffer> buffers = new ArrayList<IdBuffer>();
            this.overriddenIdGenerators.values().forEach(generator -> generator.collectBufferedIds(buffers));
            if (!buffers.isEmpty()) {
                this.bufferQueue.offer(new IdBuffers(buffers, this.boundaries.get()));
            }
        }
        while ((candidate = this.bufferQueue.peek()) != null && candidate.idFreeCondition.eligibleForFreeing()) {
            this.bufferQueue.remove();
            candidate.free(cursorContext);
        }
        this.overriddenIdGenerators.values().forEach(generator -> generator.maintenance(cursorContext));
    }

    static class IdBuffer {
        private final IdGenerator idGenerator;
        private final HeapTrackingLongArrayList ids;

        IdBuffer(IdGenerator idGenerator, HeapTrackingLongArrayList ids) {
            this.idGenerator = idGenerator;
            this.ids = ids;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void free(CursorContext cursorContext) {
            try (IdGenerator.Marker marker = this.idGenerator.marker(cursorContext);
                 PrimitiveLongResourceIterator idIterator = this.ids.iterator();){
                while (idIterator.hasNext()) {
                    long id = idIterator.next();
                    marker.markFree(IdUtils.idFromCombinedId(id), IdUtils.numberOfIdsFromCombinedId(id));
                }
            }
            finally {
                this.ids.close();
            }
        }
    }

    static class IdBuffers {
        private final List<IdBuffer> buffers;
        private final IdController.IdFreeCondition idFreeCondition;

        IdBuffers(List<IdBuffer> buffers, IdController.IdFreeCondition idFreeCondition) {
            this.buffers = buffers;
            this.idFreeCondition = idFreeCondition;
        }

        void free(CursorContext cursorContext) {
            for (IdBuffer buffer : this.buffers) {
                buffer.free(cursorContext);
            }
        }
    }
}

