/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.io.pagecache.PageCursor;

class CountsHeader
implements Header.Reader,
Consumer<PageCursor> {
    private boolean wasRead;
    private long highestGapFreeTxId;

    CountsHeader(long highestGapFreeTxId) {
        this.highestGapFreeTxId = highestGapFreeTxId;
    }

    public void read(ByteBuffer headerBytes) {
        this.wasRead = true;
        this.highestGapFreeTxId = headerBytes.getLong();
    }

    boolean wasRead() {
        return this.wasRead;
    }

    long highestGapFreeTxId() {
        return this.highestGapFreeTxId;
    }

    @Override
    public void accept(PageCursor cursor) {
        cursor.putLong(this.highestGapFreeTxId);
    }
}

