/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.ToLongFunction;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndexAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.LuceneIndexValueValidator;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

public class LuceneIndexAccessor
extends AbstractLuceneIndexAccessor<ValueIndexReader, SchemaIndex> {
    private final LuceneIndexValueValidator valueValidator;

    public LuceneIndexAccessor(SchemaIndex luceneIndex, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup, IndexUpdateIgnoreStrategy ignoreStrategy) {
        super(luceneIndex, descriptor, ignoreStrategy);
        this.valueValidator = new LuceneIndexValueValidator(descriptor, tokenNameLookup);
    }

    @Override
    protected IndexUpdater getIndexUpdater(IndexUpdateMode mode) {
        return new LuceneSchemaIndexUpdater(mode.requiresIdempotency(), mode.requiresRefresh());
    }

    public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
        return super.newAllEntriesReader(LuceneDocumentStructure::getNodeId, fromIdInclusive, toIdExclusive);
    }

    @Override
    public IndexEntriesReader[] newAllEntriesValueReader(ToLongFunction<Document> entityIdReader, int numPartitions) {
        return super.newAllEntriesValueReader(LuceneDocumentStructure::getNodeId, numPartitions);
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
        try {
            ((SchemaIndex)this.luceneIndex).verifyUniqueness(nodePropertyAccessor, this.descriptor.schema().getPropertyIds());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void validateBeforeCommit(long entityId, Value[] tuple) {
        this.valueValidator.validate(entityId, tuple);
    }

    private class LuceneSchemaIndexUpdater
    extends AbstractLuceneIndexAccessor.AbstractLuceneIndexUpdater {
        LuceneSchemaIndexUpdater(boolean idempotent, boolean refresh) {
            super(LuceneIndexAccessor.this, idempotent, refresh);
        }

        @Override
        protected void addIdempotent(long entityId, Value[] values) {
            try {
                Document document = LuceneDocumentStructure.documentRepresentingProperties(entityId, values);
                LuceneIndexAccessor.this.writer.updateOrDeleteDocument(LuceneDocumentStructure.newTermForChangeOrRemove(entityId), document);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected void add(long entityId, Value[] values) {
            try {
                Document document = LuceneDocumentStructure.documentRepresentingProperties(entityId, values);
                LuceneIndexAccessor.this.writer.nullableAddDocument(document);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected void change(long entityId, Value[] values) {
            try {
                Term term = LuceneDocumentStructure.newTermForChangeOrRemove(entityId);
                Document document = LuceneDocumentStructure.documentRepresentingProperties(entityId, values);
                LuceneIndexAccessor.this.writer.updateOrDeleteDocument(term, document);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected void remove(long entityId) {
            try {
                Term term = LuceneDocumentStructure.newTermForChangeOrRemove(entityId);
                LuceneIndexAccessor.this.writer.deleteDocuments(term);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

