/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.storestatistics;

import java.util.Arrays;

class Histogram {
    static final int[] COUNT_BUCKETS = new int[]{0, 1, 4, 16, 64, 256, 1024, 4096, 16384, 65536, 0x1000000, Integer.MAX_VALUE};
    static final int[] FRAG_MEASURE_BUCKETS = new int[]{100, 200, 300, 400, 500, 600, 700, 800, 900, 1000};
    private final int[] buckets;
    private final int[] frequencies;

    Histogram() {
        this(COUNT_BUCKETS);
    }

    static Histogram newFragMeasureHistogram() {
        return new Histogram(FRAG_MEASURE_BUCKETS);
    }

    private Histogram(int[] bucketUpperBounds) {
        this.buckets = bucketUpperBounds;
        this.frequencies = new int[bucketUpperBounds.length];
    }

    void addTo(Histogram totalHist) {
        if (!Arrays.equals(this.buckets, totalHist.buckets)) {
            throw new RuntimeException("Attempted to add histograms with different buckets. This is a bug.");
        }
        for (int i = 0; i < this.frequencies.length; ++i) {
            int n = i;
            totalHist.frequencies[n] = totalHist.frequencies[n] + this.frequencies[i];
        }
    }

    void addValue(int value) {
        for (int i = 0; i < this.buckets.length; ++i) {
            if (value > this.buckets[i]) continue;
            int n = i;
            this.frequencies[n] = this.frequencies[n] + 1;
            return;
        }
        throw new RuntimeException(String.format("Attempted to add value %d to histogram whose max value is %d. This is a bug.", value, this.buckets[this.buckets.length - 1]));
    }

    String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        int width = 0;
        for (int tmp = this.buckets[this.buckets.length - 1]; tmp > 0; tmp /= 10) {
            ++width;
        }
        width = Math.max(width, "Buckets".length());
        String bucketsFormat = String.format("%%%ds", width);
        sb.append(String.format(bucketsFormat, "Buckets"));
        sb.append(" | ");
        sb.append("Frequencies");
        for (int i = 0; i < this.buckets.length; ++i) {
            sb.append("\n");
            sb.append(String.format(bucketsFormat, this.buckets[i]));
            sb.append(" | ");
            sb.append(this.frequencies[i]);
        }
        return sb.toString();
    }
}

