/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.pegasus;

import com.alibaba.pegasus.RpcChannel;
import com.alibaba.pegasus.RpcClient;
import com.alibaba.pegasus.builder.JobBuilder;
import com.alibaba.pegasus.common.StreamIterator;
import com.alibaba.pegasus.intf.ResultProcessor;
import com.alibaba.pegasus.service.protocol.PegasusClient;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientExample {
    private static final Logger logger = LoggerFactory.getLogger(ClientExample.class);

    private static void error(Status status) {
        logger.error("on error {}", (Object)status.toString());
    }

    private static ArrayList<Long> toLongArray(byte[] bytes, int size) {
        ArrayList<Long> res = new ArrayList<Long>();
        for (int i = 0; i < size; i += 8) {
            long l = ClientExample.fromByteArray(Arrays.copyOfRange(bytes, i, i + 8));
            res.add(l);
        }
        return res;
    }

    private static byte[] toByteArray(long value) {
        byte[] result = new byte[8];
        for (int i = 0; i < 8; ++i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    private static long fromByteArray(byte[] bytes) {
        return ((long)bytes[7] & 0xFFL) << 56 | ((long)bytes[6] & 0xFFL) << 48 | ((long)bytes[5] & 0xFFL) << 40 | ((long)bytes[4] & 0xFFL) << 32 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[1] & 0xFFL) << 8 | (long)bytes[0] & 0xFFL;
    }

    private static ByteString getSeed(long a) {
        return ByteString.copyFrom((byte[])ClientExample.toByteArray(a));
    }

    private static ByteString getRoute() {
        return ByteString.EMPTY;
    }

    private static ByteString add(long a) {
        return ByteString.copyFrom((byte[])ClientExample.toByteArray(a));
    }

    private static ByteString copy(long a) {
        return ByteString.copyFrom((byte[])ClientExample.toByteArray(a));
    }

    private static ByteString getSink() {
        return ByteString.EMPTY;
    }

    public static void main(String[] args) throws Exception {
        RpcChannel rpcChannel0 = new RpcChannel("localhost", 1234);
        RpcChannel rpcChannel1 = new RpcChannel("localhost", 1235);
        ArrayList<RpcChannel> channels = new ArrayList<RpcChannel>();
        channels.add(rpcChannel0);
        channels.add(rpcChannel1);
        RpcClient rpcClient = new RpcClient(channels);
        logger.info("Will try to send request");
        PegasusClient.JobConfig confPb = PegasusClient.JobConfig.newBuilder().setJobId(2L).setJobName("ping_pong_example").setWorkers(2).setAll(PegasusClient.Empty.newBuilder().build()).build();
        JobBuilder jobBuilder = new JobBuilder(confPb);
        JobBuilder start = new JobBuilder();
        jobBuilder.addSource(ClientExample.getSeed(0L)).repeat(3, start.exchange(ClientExample.getRoute()).map(ClientExample.add(1L)).flatMap(ClientExample.copy(8L))).sink(ClientExample.getSink());
        PegasusClient.JobRequest req = jobBuilder.build();
        final StreamIterator resultIterator = new StreamIterator();
        rpcClient.submit(req, new ResultProcessor(){

            @Override
            public void process(PegasusClient.JobResponse response) {
                try {
                    resultIterator.putData(response);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void finish() {
                try {
                    resultIterator.finish();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void error(Status status) {
                resultIterator.fail(status.getCause());
            }
        }, 600000L);
        rpcClient.shutdown();
    }
}

