/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.pegasus.builder;

import com.alibaba.pegasus.builder.Plan;
import com.alibaba.pegasus.service.job.protocol.JobClient;
import com.alibaba.pegasus.service.protocol.PegasusClient;
import com.google.protobuf.ByteString;

public abstract class AbstractBuilder {
    protected PegasusClient.JobConfig conf;
    protected ByteString source;
    protected Plan plan;
    protected JobClient.Sink sink;

    public AbstractBuilder(PegasusClient.JobConfig conf, ByteString source, Plan plan, JobClient.Sink sink) {
        this.conf = conf;
        this.source = source;
        this.plan = plan;
        this.sink = sink;
    }

    public AbstractBuilder(PegasusClient.JobConfig conf, ByteString source, Plan plan) {
        this.conf = conf;
        this.source = source;
        this.plan = plan;
        this.sink = JobClient.Sink.newBuilder().build();
    }

    public AbstractBuilder(PegasusClient.JobConfig conf, ByteString source) {
        this.conf = conf;
        this.source = source;
        this.plan = new Plan();
        this.sink = JobClient.Sink.newBuilder().build();
    }

    public AbstractBuilder(PegasusClient.JobConfig conf) {
        this.conf = conf;
        this.plan = new Plan();
        this.sink = JobClient.Sink.newBuilder().build();
    }

    public AbstractBuilder() {
        this.plan = new Plan();
        this.sink = JobClient.Sink.newBuilder().build();
    }

    public PegasusClient.JobConfig getConf() {
        return this.conf;
    }

    public void setConf(PegasusClient.JobConfig conf) {
        this.conf = conf;
    }

    public ByteString getSource() {
        return this.source;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    public PegasusClient.JobRequest build() {
        JobClient.Sink sink = this.sink;
        return PegasusClient.JobRequest.newBuilder().setConf(this.conf).setSource(this.source).setPlan(JobClient.TaskPlan.newBuilder().addAllPlan(this.plan.getPlan()).build().toByteString()).setResource(sink.toByteString()).build();
    }
}

