/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.neo4j.memory.MemoryTracker;

public class ScopedMemoryTracker
implements MemoryTracker {
    private final MemoryTracker delegate;
    private long trackedNative;
    private long trackedHeap;
    private boolean isClosed;

    public ScopedMemoryTracker(MemoryTracker delegate) {
        this.delegate = delegate;
    }

    @Override
    public long usedNativeMemory() {
        return this.trackedNative;
    }

    @Override
    public long estimatedHeapMemory() {
        return this.trackedHeap;
    }

    @Override
    public void allocateNative(long bytes) {
        this.throwIfClosed();
        this.delegate.allocateNative(bytes);
        this.trackedNative += bytes;
    }

    @Override
    public void releaseNative(long bytes) {
        this.throwIfClosed();
        this.delegate.releaseNative(bytes);
        this.trackedNative -= bytes;
    }

    @Override
    public void allocateHeap(long bytes) {
        this.throwIfClosed();
        this.delegate.allocateHeap(bytes);
        this.trackedHeap += bytes;
    }

    @Override
    public void releaseHeap(long bytes) {
        this.throwIfClosed();
        this.delegate.releaseHeap(bytes);
        this.trackedHeap -= bytes;
    }

    private void throwIfClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Should not use a closed ScopedMemoryTracker");
        }
    }

    @Override
    public long heapHighWaterMark() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.delegate.releaseNative(this.trackedNative);
        this.delegate.releaseHeap(this.trackedHeap);
        this.trackedNative = 0L;
        this.trackedHeap = 0L;
    }

    @Override
    public void close() {
        if (!(this.delegate instanceof ScopedMemoryTracker) || !((ScopedMemoryTracker)this.delegate).isClosed) {
            this.delegate.releaseNative(this.trackedNative);
            this.delegate.releaseHeap(this.trackedHeap);
        }
        this.trackedNative = 0L;
        this.trackedHeap = 0L;
        this.isClosed = true;
    }

    @Override
    public MemoryTracker getScopedMemoryTracker() {
        return new ScopedMemoryTracker(this);
    }
}

