/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.string;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Globbing {
    private static final String specialCharacters = "<([{\\^-=$!|]})+.>";
    private static final String escapedSpecialCharacters = "<([{\\^-=$!|]})+.>".replaceAll(".", "\\\\$0");
    private static final Pattern specialCharacterPattern = Pattern.compile("[" + escapedSpecialCharacters + "]");

    public static Predicate<String> globPredicate(String globbing) {
        Matcher m = specialCharacterPattern.matcher(globbing);
        String escaped = m.replaceAll("\\\\$0");
        String escapedString = escaped.replaceAll("\\*", ".*").replaceAll("\\?", ".{1}");
        return Pattern.compile(escapedString, 2).asMatchPredicate();
    }
}

