/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.meta;

import com.alibaba.graphscope.groot.common.exception.GrootException;
import com.alibaba.graphscope.groot.common.exception.InternalException;
import com.alibaba.graphscope.groot.common.exception.InvalidDataTypeException;
import com.alibaba.graphscope.groot.common.meta.DataTypeDeserializer;
import com.alibaba.graphscope.groot.common.meta.DataTypeSerializer;
import com.alibaba.graphscope.groot.common.meta.InternalDataType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;

@JsonSerialize(using=DataTypeSerializer.class)
@JsonDeserialize(using=DataTypeDeserializer.class)
public class DataType {
    public static final DataType BOOL = new DataType(InternalDataType.BOOL);
    public static final DataType CHAR = new DataType(InternalDataType.CHAR);
    public static final DataType SHORT = new DataType(InternalDataType.SHORT);
    public static final DataType INT = new DataType(InternalDataType.INT);
    public static final DataType LONG = new DataType(InternalDataType.LONG);
    public static final DataType FLOAT = new DataType(InternalDataType.FLOAT);
    public static final DataType DOUBLE = new DataType(InternalDataType.DOUBLE);
    public static final DataType BYTES = new DataType(InternalDataType.BYTES);
    public static final DataType STRING = new DataType(InternalDataType.STRING);
    public static final DataType DATE = new DataType(InternalDataType.DATE);
    public static final DataType TIME = new DataType(InternalDataType.TIME);
    public static final DataType TIMESTAMP = new DataType(InternalDataType.TIMESTAMP);
    @JsonProperty
    private String expression;
    @JsonProperty
    private InternalDataType type;

    public DataType(InternalDataType internalDataType) {
        this.type = internalDataType;
    }

    public static DataType toDataType(int i) {
        return new DataType(InternalDataType.values()[i]);
    }

    public static DataType valueOf(String typeName) {
        if (typeName.startsWith("DATE")) {
            return DATE;
        }
        if (typeName.startsWith("TIME")) {
            return TIME;
        }
        if (typeName.startsWith("TIMESTAMP")) {
            return TIMESTAMP;
        }
        return new DataType(InternalDataType.valueOf(typeName));
    }

    public boolean isInt() {
        return this.type == InternalDataType.SHORT || this.type == InternalDataType.INT || this.type == InternalDataType.LONG;
    }

    public void setExpression(String expression) throws GrootException {
        if (this.isPrimitiveType()) {
            this.expression = null;
            return;
        }
        if (!this.isValid(expression)) {
            throw new InvalidDataTypeException("expression is not valid, subType must be primitiveTypes: " + InternalDataType.primitiveTypes);
        }
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public InternalDataType getType() {
        return this.type;
    }

    @JsonIgnore
    public String name() {
        return this.getType().name();
    }

    @JsonValue
    public String getJson() {
        return this.type.name() + (String)(this.expression.isEmpty() ? "" : "<" + this.expression + ">");
    }

    public boolean isValid(String expression) {
        if (this.type == InternalDataType.SET || this.type == InternalDataType.LIST) {
            return this.validSubTypes(expression);
        }
        if (this.type == InternalDataType.MAP) {
            String s = expression.replaceAll("[ ]*,[ ]*", ",");
            String[] split = s.split(",");
            if (split.length < 2) {
                return false;
            }
            return this.validSubTypes(split[0]) && this.validSubTypes(split[1]);
        }
        return true;
    }

    public boolean validSubTypes(String expression) {
        return InternalDataType.primitiveTypes.contains(expression.trim().toUpperCase());
    }

    public boolean isPrimitiveType() {
        return this.type != InternalDataType.LIST && this.type != InternalDataType.MAP && this.type != InternalDataType.SET;
    }

    public boolean isFixedLen() {
        switch (this.type) {
            case BOOL: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public int getFixedSize() {
        switch (this.type) {
            case BOOL: 
            case CHAR: {
                return 1;
            }
            case SHORT: {
                return 2;
            }
            case INT: 
            case FLOAT: {
                return 4;
            }
            case LONG: 
            case DOUBLE: {
                return 8;
            }
        }
        throw new InternalException("unreachable!");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataType)) {
            return false;
        }
        DataType dataType = (DataType)o;
        return Objects.equals(this.getExpression(), dataType.getExpression()) && this.getType() == dataType.getType();
    }

    public int hashCode() {
        return Objects.hashCode(this.getExpression() + this.getType());
    }

    public String toString() {
        return "DataType{expression='" + this.expression + "', type=" + this.type + "}";
    }
}

