/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.meta;

import com.alibaba.graphscope.groot.common.exception.GrootException;
import com.alibaba.graphscope.groot.common.exception.InvalidDataException;
import com.alibaba.graphscope.groot.common.meta.DataType;
import com.alibaba.graphscope.groot.common.meta.InternalDataType;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;

public class DataTypeDeserializer
extends StdDeserializer<DataType> {
    public DataTypeDeserializer() {
        this(null);
    }

    public DataTypeDeserializer(Class<?> vc) {
        super(vc);
    }

    public DataType deserialize(JsonParser p, DeserializationContext ctxt) throws GrootException {
        try {
            String data = p.getValueAsString();
            if (data.startsWith("LIST<")) {
                DataType ret = new DataType(InternalDataType.LIST);
                ret.setExpression(data.substring("LIST<".length(), data.length() - 1));
                return ret;
            }
            if (data.startsWith("S<")) {
                DataType ret = new DataType(InternalDataType.SET);
                ret.setExpression(data.substring(2, data.length() - 1));
                return ret;
            }
            if (!data.startsWith("M<")) {
                DataType ret = new DataType(InternalDataType.valueOf(data.toUpperCase()));
                return ret;
            }
        }
        catch (Exception ex) {
            throw new InvalidDataException(ex);
        }
        return null;
    }
}

