/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.impl;

import com.alibaba.graphscope.groot.common.exception.InvalidArgumentException;
import com.alibaba.graphscope.groot.common.schema.api.EdgeRelation;
import com.alibaba.graphscope.groot.common.schema.api.GraphEdge;
import com.alibaba.graphscope.groot.common.schema.api.GraphProperty;
import com.alibaba.graphscope.groot.common.schema.wrapper.TypeDef;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultGraphEdge
implements GraphEdge {
    private final int id;
    private final String label;
    private final List<GraphProperty> propertyList;
    private final List<EdgeRelation> relationList;
    private List<String> primaryKeyList;
    private final int versionId;

    public DefaultGraphEdge(int id, String label, List<GraphProperty> propertyList, List<EdgeRelation> relationList) {
        this(id, label, propertyList, relationList, 0);
    }

    public DefaultGraphEdge(int id, String label, List<GraphProperty> propertyList, List<EdgeRelation> relationList, List<String> primaryKeyList) {
        this(id, label, propertyList, relationList, primaryKeyList, 0);
    }

    public DefaultGraphEdge(int id, String label, List<GraphProperty> propertyList, List<EdgeRelation> relationList, int versionId) {
        this.id = id;
        this.label = label;
        this.propertyList = propertyList;
        this.relationList = relationList;
        this.versionId = versionId;
    }

    public DefaultGraphEdge(int id, String label, List<GraphProperty> propertyList, List<EdgeRelation> relationList, List<String> primaryKeyList, int versionId) {
        this.id = id;
        this.label = label;
        this.propertyList = propertyList;
        this.relationList = relationList;
        this.primaryKeyList = primaryKeyList;
        this.versionId = versionId;
    }

    public DefaultGraphEdge(TypeDef typeDef, List<EdgeRelation> edgeRelations) {
        this(typeDef.getLabelId(), typeDef.getLabel(), typeDef.getPropertyList(), edgeRelations, typeDef.getPrimaryKeyNameList(), typeDef.getVersionId());
    }

    @Override
    public List<EdgeRelation> getRelationList() {
        return this.relationList;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getLabelId() {
        return this.id;
    }

    @Override
    public List<GraphProperty> getPropertyList() {
        return this.propertyList;
    }

    @Override
    public GraphProperty getProperty(int propId) {
        for (GraphProperty property : this.propertyList) {
            if (property.getId() != propId) continue;
            return property;
        }
        throw new InvalidArgumentException("Invalid property id " + propId);
    }

    @Override
    public GraphProperty getProperty(String propName) {
        for (GraphProperty property : this.propertyList) {
            if (!Objects.equals(propName, property.getName())) continue;
            return property;
        }
        throw new InvalidArgumentException("Invalid property name " + propName);
    }

    @Override
    public int getVersionId() {
        return this.versionId;
    }

    @Override
    public List<GraphProperty> getPrimaryKeyList() {
        ArrayList<GraphProperty> props = new ArrayList<GraphProperty>();
        if (this.primaryKeyList != null) {
            for (String name : this.primaryKeyList) {
                props.add(this.getProperty(name));
            }
        }
        return props;
    }

    @Override
    public List<String> getPrimaryKeyNameList() {
        return this.primaryKeyList;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("label", (Object)this.label).add("propertyList", this.propertyList).add("relationList", this.relationList).add("versionId", this.versionId).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGraphEdge that = (DefaultGraphEdge)o;
        return this.id == that.id && this.versionId == that.versionId && this.label.equals(that.label) && Objects.equals(this.propertyList, that.propertyList) && Objects.equals(this.relationList, that.relationList);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.label, this.propertyList, this.relationList, this.versionId);
    }
}

