/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.impl;

import com.alibaba.graphscope.groot.common.exception.InvalidArgumentException;
import com.alibaba.graphscope.groot.common.exception.PropertyNotFoundException;
import com.alibaba.graphscope.groot.common.exception.TypeNotFoundException;
import com.alibaba.graphscope.groot.common.schema.api.EdgeRelation;
import com.alibaba.graphscope.groot.common.schema.api.GraphEdge;
import com.alibaba.graphscope.groot.common.schema.api.GraphElement;
import com.alibaba.graphscope.groot.common.schema.api.GraphProperty;
import com.alibaba.graphscope.groot.common.schema.api.GraphSchema;
import com.alibaba.graphscope.groot.common.schema.api.GraphVertex;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultEdgeRelation;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultGraphEdge;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultGraphProperty;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultGraphVertex;
import com.alibaba.graphscope.groot.common.schema.wrapper.DataType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGraphSchema
implements GraphSchema {
    private static final Logger logger = LoggerFactory.getLogger(DefaultGraphSchema.class);
    private final Map<String, GraphVertex> vertexList;
    private final Map<String, GraphEdge> edgeList;
    private final Map<String, Integer> propNameToIdList;
    private final Map<Integer, String> idToLabelList = Maps.newHashMap();

    public DefaultGraphSchema(Map<String, GraphVertex> vertexList, Map<String, GraphEdge> edgeList, Map<String, Integer> propNameToIdList) {
        this.vertexList = vertexList;
        this.edgeList = edgeList;
        vertexList.forEach((key, value) -> this.idToLabelList.put(value.getLabelId(), (String)key));
        edgeList.forEach((key, value) -> this.idToLabelList.put(value.getLabelId(), (String)key));
        this.propNameToIdList = propNameToIdList;
    }

    @Override
    public GraphElement getElement(String label) throws TypeNotFoundException {
        if (this.vertexList.containsKey(label)) {
            return this.vertexList.get(label);
        }
        if (this.edgeList.containsKey(label)) {
            return this.edgeList.get(label);
        }
        throw new TypeNotFoundException("label " + label + " not exist");
    }

    @Override
    public GraphElement getElement(int labelId) throws TypeNotFoundException {
        if (this.idToLabelList.containsKey(labelId)) {
            return this.getElement(this.idToLabelList.get(labelId));
        }
        throw new TypeNotFoundException("label not exist for label ID " + labelId);
    }

    @Override
    public List<GraphVertex> getVertexList() {
        return Lists.newArrayList(this.vertexList.values());
    }

    @Override
    public List<GraphEdge> getEdgeList() {
        return Lists.newArrayList(this.edgeList.values());
    }

    @Override
    public Integer getPropertyId(String propName) throws PropertyNotFoundException {
        if (this.propNameToIdList.containsKey(propName)) {
            return this.propNameToIdList.get(propName);
        }
        throw new PropertyNotFoundException("property " + propName + " not exist");
    }

    @Override
    public String getPropertyName(int propId) throws PropertyNotFoundException {
        for (Map.Entry<String, Integer> entry : this.propNameToIdList.entrySet()) {
            if (entry.getValue() != propId) continue;
            return entry.getKey();
        }
        throw new PropertyNotFoundException("property not exist for property id " + propId);
    }

    @Override
    public Map<GraphElement, GraphProperty> getPropertyList(String propName) {
        HashMap elementPropertyList = Maps.newHashMap();
        this.vertexList.forEach((key, value) -> {
            for (GraphProperty property : value.getPropertyList()) {
                if (!property.getName().equals(propName)) continue;
                elementPropertyList.put(value, property);
            }
        });
        this.edgeList.forEach((key, value) -> {
            for (GraphProperty property : value.getPropertyList()) {
                if (!property.getName().equals(propName)) continue;
                elementPropertyList.put(value, property);
            }
        });
        return elementPropertyList;
    }

    @Override
    public Map<GraphElement, GraphProperty> getPropertyList(int propId) {
        try {
            String propName = this.getPropertyName(propId);
            return this.getPropertyList(propName);
        }
        catch (Exception ignored) {
            return Maps.newHashMap();
        }
    }

    @Override
    public String getVersion() {
        return "0";
    }

    public static GraphSchema buildSchemaFromJson(String schemaJson) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode jsonNode = mapper.readTree(schemaJson);
            HashMap vertexList = Maps.newHashMap();
            HashMap edgeList = Maps.newHashMap();
            HashMap propNameToIdList = Maps.newHashMap();
            JsonNode typeList = jsonNode.get("types");
            if (null != typeList) {
                int propId = 1;
                for (JsonNode typeObject : typeList) {
                    List<String> primaryKeyList;
                    int labelId = typeObject.get("id").asInt();
                    String label = typeObject.get("label").asText();
                    String type = typeObject.get("type").asText();
                    HashMap namePropertyList = Maps.newHashMap();
                    ArrayList propertyList = Lists.newArrayList();
                    JsonNode propArray = typeObject.get("propertyDefList");
                    if (null != propArray) {
                        for (JsonNode propObject : propArray) {
                            String propName = propObject.get("name").asText();
                            int currPropId = propObject.has("id") ? propObject.get("id").asInt() : propId++;
                            String propDataTypeString = propObject.get("data_type").asText();
                            com.alibaba.graphscope.groot.common.meta.DataType dataType = com.alibaba.graphscope.groot.common.meta.DataType.valueOf(propDataTypeString);
                            DefaultGraphProperty property = new DefaultGraphProperty(currPropId, propName, DataType.parseFromDataType(dataType));
                            propertyList.add(property);
                            namePropertyList.put(propName, property);
                            propNameToIdList.put(propName, currPropId);
                        }
                    } else {
                        logger.warn("There's no property def list in " + label);
                    }
                    if (type.equalsIgnoreCase("VERTEX")) {
                        primaryKeyList = DefaultGraphSchema.getPrimaryKeyList(typeObject.get("indexes"));
                        DefaultGraphVertex graphVertex = new DefaultGraphVertex(labelId, label, propertyList, primaryKeyList);
                        vertexList.put(label, graphVertex);
                        continue;
                    }
                    primaryKeyList = DefaultGraphSchema.getPrimaryKeyList(typeObject.get("indexes"));
                    ArrayList relationList = Lists.newArrayList();
                    JsonNode relationArray = typeObject.get("rawRelationShips");
                    if (null != relationArray) {
                        for (JsonNode relationObject : relationArray) {
                            String sourceLabel = relationObject.get("srcVertexLabel").asText();
                            String targetLabel = relationObject.get("dstVertexLabel").asText();
                            relationList.add(new DefaultEdgeRelation((GraphVertex)vertexList.get(sourceLabel), (GraphVertex)vertexList.get(targetLabel)));
                        }
                    } else {
                        logger.warn("There's no relation def in edge " + label);
                    }
                    DefaultGraphEdge graphEdge = new DefaultGraphEdge(labelId, label, (List<GraphProperty>)propertyList, (List<EdgeRelation>)relationList, primaryKeyList);
                    edgeList.put(label, graphEdge);
                }
            } else {
                logger.error("Cant get types field in json[" + schemaJson + "]");
            }
            return new DefaultGraphSchema(vertexList, edgeList, propNameToIdList);
        }
        catch (JsonProcessingException e) {
            throw new InvalidArgumentException(e);
        }
    }

    private static List<String> getPrimaryKeyList(JsonNode indexArray) {
        ArrayList primaryKeyList = Lists.newArrayList();
        if (indexArray != null) {
            for (JsonNode indexObject : indexArray) {
                JsonNode priNameList = indexObject.get("propertyNames");
                for (JsonNode pri : priNameList) {
                    primaryKeyList.add(pri.asText());
                }
            }
        }
        return primaryKeyList;
    }

    public static void main(String[] args) throws JsonProcessingException {
        String schemaJson = "{\"partitionNum\": 2, \"types\": [{\"id\": 0, \"indexes\": [{\"propertyNames\": [\"id\"]}], \"label\": \"host\", \"propertyDefList\": [{\"data_type\": \"LONG\", \"id\": 6, \"name\": \"weight\"}, {\"data_type\": \"LONG\", \"id\": 4, \"name\": \"id\"}], \"rawRelationShips\": [], \"type\": \"VERTEX\", \"valid_properties\": [1, 1]}, {\"id\": 1, \"indexes\": [], \"label\": \"connect\", \"propertyDefList\": [{\"data_type\": \"LONG\", \"id\": 3, \"name\": \"eid\"}, {\"data_type\": \"LONG\", \"id\": 5, \"name\": \"src_label_id\"}, {\"data_type\": \"LONG\", \"id\": 2, \"name\": \"dst_label_id\"}, {\"data_type\": \"LONG\", \"id\": 1, \"name\": \"dist\"}], \"rawRelationShips\": [{\"dstVertexLabel\": \"host\", \"srcVertexLabel\": \"host\"}], \"type\": \"EDGE\", \"valid_properties\": [1, 1, 1, 1]}], \"valid_edges\": [1], \"valid_vertices\": [1]}";
        GraphSchema schema = DefaultGraphSchema.buildSchemaFromJson(schemaJson);
    }
}

