/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.mapper;

import com.alibaba.graphscope.groot.common.exception.InvalidArgumentException;
import com.alibaba.graphscope.groot.common.schema.api.EdgeRelation;
import com.alibaba.graphscope.groot.common.schema.api.GraphEdge;
import com.alibaba.graphscope.groot.common.schema.api.GraphProperty;
import com.alibaba.graphscope.groot.common.schema.api.GraphVertex;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultGraphEdge;
import com.alibaba.graphscope.groot.common.schema.mapper.EdgeRelationMapper;
import com.alibaba.graphscope.groot.common.schema.mapper.ElementIndexMapper;
import com.alibaba.graphscope.groot.common.schema.mapper.GraphPropertyMapper;
import com.alibaba.graphscope.groot.common.schema.mapper.SchemaElementMapper;
import com.alibaba.graphscope.groot.common.schema.wrapper.TypeEnum;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EdgeTypeMapper
extends SchemaElementMapper {
    private List<EdgeRelationMapper> relationShips;
    private List<ElementIndexMapper> indexes;

    public static SchemaElementMapper parseFromEdgeType(GraphEdge graphEdge) {
        EdgeTypeMapper edgeTypeMapper = new EdgeTypeMapper();
        edgeTypeMapper.setVersionId(graphEdge.getVersionId());
        edgeTypeMapper.setId(graphEdge.getLabelId());
        edgeTypeMapper.setLabel(graphEdge.getLabel());
        edgeTypeMapper.setType(TypeEnum.EDGE.toString());
        ElementIndexMapper elementIndexMapper = new ElementIndexMapper();
        elementIndexMapper.setName("primary_key");
        elementIndexMapper.setIndexType("PRIMARY_KEY");
        elementIndexMapper.setPropertyNames(graphEdge.getPrimaryKeyNameList());
        ArrayList<ElementIndexMapper> elementIndexMapperList = new ArrayList<ElementIndexMapper>();
        elementIndexMapperList.add(elementIndexMapper);
        edgeTypeMapper.setIndexes(elementIndexMapperList);
        ArrayList<EdgeRelationMapper> relationMapperList = new ArrayList<EdgeRelationMapper>();
        for (EdgeRelation edgeRelation : graphEdge.getRelationList()) {
            relationMapperList.add(EdgeRelationMapper.parseFromEdgeRelation(graphEdge.getLabel(), edgeRelation));
        }
        edgeTypeMapper.setRelationShips(relationMapperList);
        ArrayList<GraphPropertyMapper> propertyMapperList = new ArrayList<GraphPropertyMapper>();
        for (GraphProperty graphProperty : graphEdge.getPropertyList()) {
            propertyMapperList.add(GraphPropertyMapper.parseFromGraphProperty(graphProperty));
        }
        edgeTypeMapper.setPropertyDefList(propertyMapperList);
        return edgeTypeMapper;
    }

    public List<EdgeRelationMapper> getRelationShips() {
        return this.relationShips;
    }

    public List<ElementIndexMapper> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<ElementIndexMapper> indexes) {
        this.indexes = indexes;
    }

    public void setRelationShips(List<EdgeRelationMapper> relationShips) {
        this.relationShips = relationShips;
    }

    public GraphEdge toEdgeType(Map<String, GraphVertex> vertexTypeMap) {
        ArrayList<GraphProperty> graphPropertyList = null == this.getPropertyDefList() ? new ArrayList<GraphProperty>() : this.getPropertyDefList().stream().map(GraphPropertyMapper::toGraphProperty).collect(Collectors.toList());
        ArrayList<EdgeRelation> relationList = new ArrayList<EdgeRelation>();
        if (null != this.relationShips) {
            for (EdgeRelationMapper relationMapper : this.relationShips) {
                relationList.add(relationMapper.toEdgeRelation(vertexTypeMap));
            }
        }
        List<String> primaryKeyList = new ArrayList<String>();
        if (this.indexes != null && this.indexes.size() > 0) {
            if (this.indexes.size() > 1) {
                throw new InvalidArgumentException("Only support primary key now for " + this.indexes);
            }
            primaryKeyList = this.indexes.get(0).getPropertyNames();
        }
        return new DefaultGraphEdge(this.getId(), this.getLabel(), graphPropertyList, relationList, primaryKeyList, this.getVersionId());
    }
}

