/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.mapper;

import com.alibaba.graphscope.groot.common.exception.InvalidArgumentException;
import com.alibaba.graphscope.groot.common.schema.api.GraphEdge;
import com.alibaba.graphscope.groot.common.schema.api.GraphSchema;
import com.alibaba.graphscope.groot.common.schema.api.GraphVertex;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultGraphSchema;
import com.alibaba.graphscope.groot.common.schema.mapper.EdgeTypeMapper;
import com.alibaba.graphscope.groot.common.schema.mapper.GraphPropertyMapper;
import com.alibaba.graphscope.groot.common.schema.mapper.SchemaElementMapper;
import com.alibaba.graphscope.groot.common.schema.mapper.VertexTypeMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GraphSchemaMapper {
    private List<SchemaElementMapper> types;
    private String version;

    public List<SchemaElementMapper> getTypes() {
        return this.types;
    }

    public String getVersion() {
        return this.version;
    }

    public GraphSchema toGraphSchema() {
        HashMap<String, GraphVertex> vertexTypeMap = new HashMap<String, GraphVertex>();
        HashMap<String, GraphEdge> edgeTypeMap = new HashMap<String, GraphEdge>();
        HashMap<String, Integer> propNameToIdList = new HashMap<String, Integer>();
        for (SchemaElementMapper elementMapper : this.types) {
            if (elementMapper instanceof VertexTypeMapper) {
                GraphVertex graphVertex = ((VertexTypeMapper)elementMapper).toVertexType();
                vertexTypeMap.put(graphVertex.getLabel(), graphVertex);
            } else {
                GraphEdge graphEdge = ((EdgeTypeMapper)elementMapper).toEdgeType(vertexTypeMap);
                edgeTypeMap.put(graphEdge.getLabel(), graphEdge);
            }
            for (GraphPropertyMapper def : elementMapper.getPropertyDefList()) {
                propNameToIdList.put(def.getName(), def.getId());
            }
        }
        return new DefaultGraphSchema(vertexTypeMap, edgeTypeMap, propNameToIdList);
    }

    public String toJsonString() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new InvalidArgumentException("convert graph schema to json failed", (Throwable)e);
        }
    }

    public static GraphSchemaMapper parseFromSchema(GraphSchema schema) {
        GraphSchemaMapper schemaMapper = new GraphSchemaMapper();
        schemaMapper.version = schema.getVersion();
        schemaMapper.types = new ArrayList<SchemaElementMapper>();
        for (GraphVertex graphVertex : schema.getVertexList()) {
            schemaMapper.types.add(VertexTypeMapper.parseFromVertexType(graphVertex));
        }
        for (GraphEdge graphEdge : schema.getEdgeList()) {
            schemaMapper.types.add(EdgeTypeMapper.parseFromEdgeType(graphEdge));
        }
        return schemaMapper;
    }

    public static GraphSchemaMapper parseFromJson(String schemaJson) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            GraphSchemaMapper graphSchema = new GraphSchemaMapper();
            JsonNode jsonNode = mapper.readTree(schemaJson);
            graphSchema.version = jsonNode.has("version") ? jsonNode.get("version").asText() : "0";
            graphSchema.types = new ArrayList<SchemaElementMapper>();
            JsonNode typeArray = jsonNode.get("types");
            for (JsonNode typeNode : typeArray) {
                SchemaElementMapper typeMapper;
                String type = typeNode.get("type").asText();
                if (type.equalsIgnoreCase("VERTEX")) {
                    typeMapper = (VertexTypeMapper)mapper.convertValue((Object)typeNode, VertexTypeMapper.class);
                    graphSchema.types.add(typeMapper);
                    continue;
                }
                typeMapper = (EdgeTypeMapper)mapper.convertValue((Object)typeNode, EdgeTypeMapper.class);
                graphSchema.types.add(typeMapper);
            }
            return graphSchema;
        }
        catch (JsonProcessingException e) {
            throw new InvalidArgumentException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        String path = "groot-server/src/test/resources/schema.json";
        String schemaJson = new String(Files.readAllBytes(Paths.get(path, new String[0])), StandardCharsets.UTF_8);
        GraphSchema graphSchema = GraphSchemaMapper.parseFromJson(schemaJson).toGraphSchema();
        GraphSchemaMapper mapper = GraphSchemaMapper.parseFromSchema(graphSchema);
        System.out.println(mapper.toJsonString());
    }
}

