/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.unified;

import com.alibaba.graphscope.groot.common.exception.PropertyNotFoundException;
import com.alibaba.graphscope.groot.common.exception.TypeNotFoundException;
import com.alibaba.graphscope.groot.common.schema.api.GraphEdge;
import com.alibaba.graphscope.groot.common.schema.api.GraphElement;
import com.alibaba.graphscope.groot.common.schema.api.GraphProperty;
import com.alibaba.graphscope.groot.common.schema.api.GraphSchema;
import com.alibaba.graphscope.groot.common.schema.api.GraphVertex;
import com.alibaba.graphscope.groot.common.schema.unified.Converter;
import com.alibaba.graphscope.groot.common.schema.unified.Schema;
import com.alibaba.graphscope.groot.common.schema.unified.Type;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(converter=Converter.class)
public class Graph
implements GraphSchema {
    public String name;
    public String version;
    public Schema schema;

    public static Graph parseFromYaml(String yaml) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.findAndRegisterModules();
        Graph graph = (Graph)mapper.readValue(yaml, Graph.class);
        return graph;
    }

    public String toString() {
        return "Graph{name='" + this.name + "', schema=" + this.schema + "}";
    }

    @Override
    public GraphElement getElement(String label) throws TypeNotFoundException {
        for (Type type : this.schema.vertexTypes) {
            if (!Objects.equals(type.getLabel(), label)) continue;
            return type;
        }
        for (Type type : this.schema.edgeTypes) {
            if (!Objects.equals(type.getLabel(), label)) continue;
            return type;
        }
        return null;
    }

    @Override
    public GraphElement getElement(int labelId) throws TypeNotFoundException {
        for (Type type : this.schema.vertexTypes) {
            if (type.getLabelId() != labelId) continue;
            return type;
        }
        for (Type type : this.schema.edgeTypes) {
            if (type.getLabelId() != labelId) continue;
            return type;
        }
        return null;
    }

    @Override
    @JsonIgnore
    public List<GraphVertex> getVertexList() {
        return new ArrayList<GraphVertex>(this.schema.vertexTypes);
    }

    @Override
    @JsonIgnore
    public List<GraphEdge> getEdgeList() {
        return new ArrayList<GraphEdge>(this.schema.edgeTypes);
    }

    @Override
    public Integer getPropertyId(String propName) throws PropertyNotFoundException {
        for (Type type : this.schema.vertexTypes) {
            for (GraphProperty property : type.getPropertyList()) {
                if (!Objects.equals(property.getName(), propName)) continue;
                return property.getId();
            }
        }
        for (Type type : this.schema.edgeTypes) {
            for (GraphProperty property : type.getPropertyList()) {
                if (!Objects.equals(property.getName(), propName)) continue;
                return property.getId();
            }
        }
        return null;
    }

    @Override
    public String getPropertyName(int propId) throws PropertyNotFoundException {
        for (Type type : this.schema.vertexTypes) {
            for (GraphProperty property : type.getPropertyList()) {
                if (!Objects.equals(property.getId(), propId)) continue;
                return property.getName();
            }
        }
        for (Type type : this.schema.edgeTypes) {
            for (GraphProperty property : type.getPropertyList()) {
                if (!Objects.equals(property.getId(), propId)) continue;
                return property.getName();
            }
        }
        return null;
    }

    @Override
    public Map<GraphElement, GraphProperty> getPropertyList(String propName) {
        HashMap elementPropertyList = Maps.newHashMap();
        for (Type type : this.schema.vertexTypes) {
            for (GraphProperty property : type.getPropertyList()) {
                if (!Objects.equals(property.getName(), propName)) continue;
                elementPropertyList.put(type, property);
            }
        }
        for (Type type : this.schema.edgeTypes) {
            for (GraphProperty property : type.getPropertyList()) {
                if (!Objects.equals(property.getName(), propName)) continue;
                elementPropertyList.put(type, property);
            }
        }
        return elementPropertyList;
    }

    @Override
    public Map<GraphElement, GraphProperty> getPropertyList(int propId) {
        HashMap elementPropertyList = Maps.newHashMap();
        for (Type type : this.schema.vertexTypes) {
            for (GraphProperty property : type.getPropertyList()) {
                if (!Objects.equals(property.getId(), propId)) continue;
                elementPropertyList.put(type, property);
            }
        }
        for (Type type : this.schema.edgeTypes) {
            for (GraphProperty property : type.getPropertyList()) {
                if (!Objects.equals(property.getId(), propId)) continue;
                elementPropertyList.put(type, property);
            }
        }
        return elementPropertyList;
    }

    @Override
    @JsonIgnore
    public String getVersion() {
        if (this.version == null) {
            return "0";
        }
        return this.version;
    }
}

