/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.wrapper;

import com.alibaba.graphscope.groot.common.schema.wrapper.LabelId;
import com.alibaba.graphscope.proto.groot.EdgeKindPb;
import java.util.Objects;

public class EdgeKind {
    private final String edgeLabel;
    private final LabelId edgeLabelId;
    private final String srcVertexLabel;
    private final LabelId srcVertexLabelId;
    private final String dstVertexLabel;
    private final LabelId dstVertexLabelId;

    private EdgeKind(String edgeLabel, LabelId edgeLabelId, String srcVertexLabel, LabelId srcVertexLabelId, String dstVertexLabel, LabelId dstVertexLabelId) {
        this.edgeLabel = edgeLabel;
        this.edgeLabelId = edgeLabelId;
        this.srcVertexLabel = srcVertexLabel;
        this.srcVertexLabelId = srcVertexLabelId;
        this.dstVertexLabel = dstVertexLabel;
        this.dstVertexLabelId = dstVertexLabelId;
    }

    public String getEdgeLabel() {
        return this.edgeLabel;
    }

    public LabelId getEdgeLabelId() {
        return this.edgeLabelId;
    }

    public String getSrcVertexLabel() {
        return this.srcVertexLabel;
    }

    public LabelId getSrcVertexLabelId() {
        return this.srcVertexLabelId;
    }

    public String getDstVertexLabel() {
        return this.dstVertexLabel;
    }

    public LabelId getDstVertexLabelId() {
        return this.dstVertexLabelId;
    }

    public static EdgeKind parseProto(EdgeKindPb proto) {
        String edgeLabel = proto.getEdgeLabel();
        LabelId edgeLabelId = LabelId.parseProto(proto.getEdgeLabelId());
        String srcVertexLabel = proto.getSrcVertexLabel();
        LabelId srcVertexLabelId = LabelId.parseProto(proto.getSrcVertexLabelId());
        String dstVertexLabel = proto.getDstVertexLabel();
        LabelId dstVertexLabelId = LabelId.parseProto(proto.getDstVertexLabelId());
        return new EdgeKind(edgeLabel, edgeLabelId, srcVertexLabel, srcVertexLabelId, dstVertexLabel, dstVertexLabelId);
    }

    public EdgeKindPb toProto() {
        return EdgeKindPb.newBuilder().setEdgeLabel(this.edgeLabel).setEdgeLabelId(this.edgeLabelId.toProto()).setSrcVertexLabel(this.srcVertexLabel).setSrcVertexLabelId(this.srcVertexLabelId.toProto()).setDstVertexLabel(this.dstVertexLabel).setDstVertexLabelId(this.dstVertexLabelId.toProto()).build();
    }

    public EdgeKindPb toOperationProto() {
        return EdgeKindPb.newBuilder().setEdgeLabelId(this.edgeLabelId.toProto()).setSrcVertexLabelId(this.srcVertexLabelId.toProto()).setDstVertexLabelId(this.dstVertexLabelId.toProto()).build();
    }

    public EdgeKindPb toDdlProto() {
        return EdgeKindPb.newBuilder().setEdgeLabel(this.edgeLabel).setSrcVertexLabel(this.srcVertexLabel).setDstVertexLabel(this.dstVertexLabel).build();
    }

    public String toString() {
        return "EdgeKind{edgeLabel='" + this.edgeLabel + "', edgeLabelId=" + this.edgeLabelId + ", srcVertexLabel='" + this.srcVertexLabel + "', srcVertexLabelId=" + this.srcVertexLabelId + ", dstVertexLabel='" + this.dstVertexLabel + "', dstVertexLabelId=" + this.dstVertexLabelId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EdgeKind edgeKind = (EdgeKind)o;
        if (!Objects.equals(this.edgeLabelId, edgeKind.edgeLabelId)) {
            return false;
        }
        if (!Objects.equals(this.srcVertexLabelId, edgeKind.srcVertexLabelId)) {
            return false;
        }
        return Objects.equals(this.dstVertexLabelId, edgeKind.dstVertexLabelId);
    }

    public int hashCode() {
        int result = this.edgeLabelId != null ? this.edgeLabelId.hashCode() : 0;
        result = 31 * result + (this.srcVertexLabelId != null ? this.srcVertexLabelId.hashCode() : 0);
        result = 31 * result + (this.dstVertexLabelId != null ? this.dstVertexLabelId.hashCode() : 0);
        return result;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(EdgeKind edgeKind) {
        return new Builder(edgeKind);
    }

    public static class Builder {
        private String edgeLabel;
        private LabelId edgeLabelId;
        private String srcVertexLabel;
        private LabelId srcVertexLabelId;
        private String dstVertexLabel;
        private LabelId dstVertexLabelId;

        private Builder() {
        }

        private Builder(EdgeKind edgeKind) {
            this.edgeLabel = edgeKind.getEdgeLabel();
            this.edgeLabelId = edgeKind.getEdgeLabelId();
            this.srcVertexLabel = edgeKind.getSrcVertexLabel();
            this.srcVertexLabelId = edgeKind.getSrcVertexLabelId();
            this.dstVertexLabel = edgeKind.getDstVertexLabel();
            this.dstVertexLabelId = edgeKind.getDstVertexLabelId();
        }

        public Builder setEdgeLabel(String edgeLabel) {
            this.edgeLabel = edgeLabel;
            return this;
        }

        public Builder setEdgeLabelId(LabelId edgeLabelId) {
            this.edgeLabelId = edgeLabelId;
            return this;
        }

        public Builder setSrcVertexLabel(String srcVertexLabel) {
            this.srcVertexLabel = srcVertexLabel;
            return this;
        }

        public Builder setSrcVertexLabelId(LabelId srcVertexLabelId) {
            this.srcVertexLabelId = srcVertexLabelId;
            return this;
        }

        public Builder setDstVertexLabel(String dstVertexLabel) {
            this.dstVertexLabel = dstVertexLabel;
            return this;
        }

        public Builder setDstVertexLabelId(LabelId dstVertexLabelId) {
            this.dstVertexLabelId = dstVertexLabelId;
            return this;
        }

        public EdgeKind build() {
            return new EdgeKind(this.edgeLabel, this.edgeLabelId, this.srcVertexLabel, this.srcVertexLabelId, this.dstVertexLabel, this.dstVertexLabelId);
        }
    }
}

