/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.wrapper;

import com.alibaba.graphscope.groot.common.exception.IllegalStateException;
import com.alibaba.graphscope.groot.common.exception.InvalidArgumentException;
import com.alibaba.graphscope.groot.common.schema.wrapper.DataType;
import com.alibaba.graphscope.groot.common.schema.wrapper.SerdeUtils;
import com.alibaba.graphscope.proto.groot.PropertyValuePb;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.Objects;

public class PropertyValue {
    private final DataType dataType;
    private final byte[] valBytes;
    private Object valObject;

    public PropertyValue(DataType dataType, byte[] valBytes) {
        this.dataType = dataType;
        this.valBytes = valBytes;
    }

    public PropertyValue(DataType dataType, Object valObject) {
        this.dataType = dataType;
        this.valBytes = SerdeUtils.objectToBytes(dataType, PropertyValue.stringToObj(dataType, valObject));
        this.valObject = valObject;
    }

    private static Object stringToObj(DataType dataType, Object val) {
        if (!(val instanceof String)) {
            return val;
        }
        String valString = (String)val;
        try {
            switch (dataType) {
                case BOOL: {
                    return Boolean.parseBoolean(valString);
                }
                case CHAR: {
                    return Character.valueOf(valString.charAt(0));
                }
                case SHORT: {
                    return Short.valueOf(valString);
                }
                case INT: {
                    return Integer.valueOf(valString);
                }
                case LONG: {
                    return Long.valueOf(valString);
                }
                case FLOAT: {
                    return Float.valueOf(valString);
                }
                case DOUBLE: {
                    return Double.valueOf(valString);
                }
                case STRING: {
                    return valString;
                }
            }
            throw new IllegalStateException("Unexpected value: " + dataType);
        }
        catch (Exception e) {
            throw new InvalidArgumentException("unable to parse object to bytes. DataType [" + dataType + "], Object [" + valString + "], class [" + valString.getClass() + "]", (Throwable)e);
        }
    }

    public static PropertyValue parseProto(PropertyValuePb proto) {
        try {
            DataType dataType = DataType.parseProto(proto.getDataType());
            byte[] bytes = proto.getVal().toByteArray();
            return new PropertyValue(dataType, bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public PropertyValuePb toProto() {
        return PropertyValuePb.newBuilder().setDataType(this.dataType.toProto()).setVal(ByteString.copyFrom((byte[])this.valBytes)).build();
    }

    public Object getValue() {
        if (this.valObject != null) {
            return this.valObject;
        }
        if (this.dataType == DataType.UNKNOWN) {
            return null;
        }
        this.valObject = SerdeUtils.bytesToObject(this.dataType, this.valBytes);
        return this.valObject;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public byte[] getValBytes() {
        return this.valBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyValue that = (PropertyValue)o;
        return this.dataType == that.dataType && Arrays.equals(this.valBytes, that.valBytes);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.dataType});
        result = 31 * result + Arrays.hashCode(this.valBytes);
        return result;
    }

    public String toString() {
        return "PropertyValue{dataType=" + this.dataType + ", valObject=" + this.valObject + ", valBytes=" + this.encodeHexString(this.valBytes) + "}";
    }

    private String encodeHexString(byte[] byteArray) {
        StringBuffer hexStringBuffer = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            hexStringBuffer.append(this.byteToHex(byteArray[i]));
        }
        return hexStringBuffer.toString();
    }

    private String byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }
}

