/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.util;

import com.alibaba.graphscope.groot.common.util.VertexRecordKey;
import com.alibaba.graphscope.proto.groot.EdgeRecordKeyPb;

public class EdgeRecordKey {
    private final String label;
    private final VertexRecordKey srcVertexRecordKey;
    private final VertexRecordKey dstVertexRecordKey;
    private final long edgeInnerId;

    public EdgeRecordKey(String label, VertexRecordKey srcVertexRecordKey, VertexRecordKey dstVertexRecordKey) {
        this(label, srcVertexRecordKey, dstVertexRecordKey, -1L);
    }

    public EdgeRecordKey(String label, VertexRecordKey srcVertexRecordKey, VertexRecordKey dstVertexRecordKey, long edgeInnerId) {
        this.label = label;
        this.srcVertexRecordKey = srcVertexRecordKey;
        this.dstVertexRecordKey = dstVertexRecordKey;
        this.edgeInnerId = edgeInnerId;
    }

    public String getLabel() {
        return this.label;
    }

    public VertexRecordKey getSrcVertexRecordKey() {
        return this.srcVertexRecordKey;
    }

    public VertexRecordKey getDstVertexRecordKey() {
        return this.dstVertexRecordKey;
    }

    public long getEdgeInnerId() {
        return this.edgeInnerId;
    }

    public static EdgeRecordKey parseProto(EdgeRecordKeyPb proto) {
        String label = proto.getLabel();
        long innerId = proto.getInnerId();
        VertexRecordKey srcVertexRecordKey = VertexRecordKey.parseProto(proto.getSrcVertexKey());
        VertexRecordKey dstVertexRecordKey = VertexRecordKey.parseProto(proto.getDstVertexKey());
        return new EdgeRecordKey(label, srcVertexRecordKey, dstVertexRecordKey, innerId);
    }

    public EdgeRecordKeyPb toProto() {
        return EdgeRecordKeyPb.newBuilder().setLabel(this.label).setSrcVertexKey(this.srcVertexRecordKey.toProto()).setDstVertexKey(this.dstVertexRecordKey.toProto()).build();
    }
}

