/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.io.pagecache.PageCursor;

enum DynamicSizeOffsetFormat {
    OFFSET_2B(2){

        @Override
        void putOffset(PageCursor cursor, int offsetValue) {
            PageCursorUtil.putUnsignedShort(cursor, offsetValue);
        }

        @Override
        void putOffset(PageCursor cursor, int offset, int offsetValue) {
            PageCursorUtil.putUnsignedShort(cursor, offset, offsetValue);
        }

        @Override
        int getOffset(PageCursor cursor) {
            return PageCursorUtil.getUnsignedShort(cursor);
        }

        @Override
        int getOffset(PageCursor cursor, int atOffset) {
            return PageCursorUtil.getUnsignedShort(cursor, atOffset);
        }
    }
    ,
    OFFSET_3B(3){

        @Override
        void putOffset(PageCursor cursor, int offsetValue) {
            PageCursorUtil.put3BInt(cursor, offsetValue);
        }

        @Override
        void putOffset(PageCursor cursor, int offset, int offsetValue) {
            PageCursorUtil.put3BInt(cursor, offset, offsetValue);
        }

        @Override
        int getOffset(PageCursor cursor) {
            return PageCursorUtil.get3BInt(cursor);
        }

        @Override
        int getOffset(PageCursor cursor, int atOffset) {
            return PageCursorUtil.get3BInt(cursor, atOffset);
        }
    };

    private final int offsetSize;
    private final int bytePosAllocOffset;
    private final int bytePosDeadSpace;
    private final int headerLengthDynamic;

    private DynamicSizeOffsetFormat(int offsetSize) {
        this.offsetSize = offsetSize;
        this.bytePosAllocOffset = 82;
        this.bytePosDeadSpace = this.bytePosAllocOffset + offsetSize;
        this.headerLengthDynamic = this.bytePosDeadSpace + offsetSize;
    }

    abstract void putOffset(PageCursor var1, int var2);

    abstract void putOffset(PageCursor var1, int var2, int var3);

    abstract int getOffset(PageCursor var1);

    abstract int getOffset(PageCursor var1, int var2);

    int offsetSize() {
        return this.offsetSize;
    }

    int getBytePosAllocOffset() {
        return this.bytePosAllocOffset;
    }

    int getBytePosDeadSpace() {
        return this.bytePosDeadSpace;
    }

    int getHeaderLength() {
        return this.headerLengthDynamic;
    }
}

